/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Signature;

public class URLProblems
extends BytecodeScanningDetector {
    static final String[] BAD_SIGNATURES = new String[]{"Map<Ljava/net/URL", "Set<Ljava/net/URL"};
    private final BugReporter bugReporter;

    public URLProblems(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Signature obj) {
        String sig = obj.getSignature();
        String[] arr$ = BAD_SIGNATURES;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String s = arr$[i$];
            if (sig.indexOf(s) < 0) continue;
            if (this.visitingField()) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "DMI_COLLECTION_OF_URLS", 1).addClass((PreorderVisitor)this).addVisitedField((PreorderVisitor)this));
                continue;
            }
            if (this.visitingMethod()) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "DMI_COLLECTION_OF_URLS", 1).addClassAndMethod((PreorderVisitor)this));
                continue;
            }
            this.bugReporter.reportBug(new BugInstance((Detector)this, "DMI_COLLECTION_OF_URLS", 1).addClass((PreorderVisitor)this).addClass((PreorderVisitor)this));
        }
    }

    public void sawOpcode(int seen) {
        if (seen == 182 && this.getClassConstantOperand().equals("java/net/URL") && (this.getNameConstantOperand().equals("equals") && this.getSigConstantOperand().equals("(Ljava/lang/Object;)Z") || this.getNameConstantOperand().equals("hashCode") && this.getSigConstantOperand().equals("()I"))) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "DMI_BLOCKING_METHODS_ON_URL", 1).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this).addSourceLine((BytecodeScanningDetector)this));
        }
    }
}

