/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.FindBugsAnalysisFeatures;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.ClassMember;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefDataflow;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefSet;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.npe.ParameterNullnessProperty;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysis;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import java.util.BitSet;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class BuildUnconditionalParamDerefDatabase {
    public static final boolean VERBOSE_DEBUG = SystemProperties.getBoolean((String)"fnd.debug.nullarg.verbose");
    private static final boolean DEBUG = SystemProperties.getBoolean((String)"fnd.debug.nullarg") || VERBOSE_DEBUG;

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        boolean fullAnalysis = AnalysisContext.currentAnalysisContext().getBoolProperty(FindBugsAnalysisFeatures.INTERPROCEDURAL_ANALYSIS_OF_REFERENCED_CLASSES);
        if (!fullAnalysis && !AnalysisContext.currentAnalysisContext().getSubtypes().isApplicationClass(classContext.getJavaClass())) {
            return;
        }
        if (VERBOSE_DEBUG) {
            System.out.println("Visiting class " + classContext.getJavaClass().getClassName());
        }
        Method[] arr$ = methodList = classContext.getJavaClass().getMethods();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Method method = arr$[i$];
            boolean hasReferenceParameters = false;
            Type[] arr$2 = method.getArgumentTypes();
            int len$2 = arr$2.length;
            for (int i$2 = 0; i$2 < len$2; ++i$2) {
                Type argument = arr$2[i$2];
                if (!(argument instanceof ReferenceType)) continue;
                hasReferenceParameters = true;
            }
            if (!hasReferenceParameters || classContext.getMethodGen(method) == null) continue;
            if (VERBOSE_DEBUG) {
                System.out.println("Check " + method);
            }
            this.analyzeMethod(classContext, method);
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) {
        try {
            CFG cfg = classContext.getCFG(method);
            ValueNumberDataflow vnaDataflow = classContext.getValueNumberDataflow(method);
            UnconditionalValueDerefDataflow dataflow = classContext.getUnconditionalValueDerefDataflow(method);
            int numParams = new SignatureParser(method.getSignature()).getNumParameters();
            int paramLocalOffset = method.isStatic() ? 0 : 1;
            BitSet unconditionalDerefSet = new BitSet();
            UnconditionalValueDerefSet entryFact = (UnconditionalValueDerefSet)dataflow.getResultFact(cfg.getEntry());
            for (int i = 0; i < numParams; ++i) {
                ValueNumber paramVN = ((ValueNumberAnalysis)vnaDataflow.getAnalysis()).getEntryValue(i + paramLocalOffset);
                if (!entryFact.isUnconditionallyDereferenced(paramVN)) continue;
                unconditionalDerefSet.set(i);
            }
            if (unconditionalDerefSet.isEmpty()) {
                if (VERBOSE_DEBUG) {
                    System.out.println("\tResult is empty");
                }
                return;
            }
            if (VERBOSE_DEBUG) {
                ClassContext.dumpUnconditionalValueDerefDataflow((Method)method, (CFG)cfg, (ValueNumberDataflow)vnaDataflow, (IsNullValueDataflow)classContext.getIsNullValueDataflow(method), (UnconditionalValueDerefDataflow)dataflow);
            }
            ParameterNullnessProperty property = new ParameterNullnessProperty();
            property.setNonNullParamSet(unconditionalDerefSet);
            XMethod xmethod = XFactory.createXMethod((JavaClass)classContext.getJavaClass(), (Method)method);
            AnalysisContext.currentAnalysisContext().getUnconditionalDerefParamDatabase().setProperty((ClassMember)xmethod, (Object)property);
            if (DEBUG) {
                System.out.println("Unconditional deref: " + xmethod + "=" + property);
            }
        }
        catch (CFGBuilderException e) {
            AnalysisContext.currentAnalysisContext().getLookupFailureCallback().logError("Error analyzing " + method + " for unconditional deref training", (Throwable)e);
        }
        catch (DataflowAnalysisException e) {
            AnalysisContext.currentAnalysisContext().getLookupFailureCallback().logError("Error analyzing " + method + " for unconditional deref training", (Throwable)e);
        }
    }
}

