/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;

public class AdapterFactoryLabelProvider
implements ILabelProvider,
ITableLabelProvider,
INotifyChangedListener {
    protected AdapterFactory adapterFactory;
    protected Collection labelProviderListeners;
    private static final Class IItemLabelProviderClass;
    private static final Class ITableItemLabelProviderClass;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.IItemLabelProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IItemLabelProviderClass = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.emf.edit.provider.ITableItemLabelProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITableItemLabelProviderClass = clazz2;
    }

    public AdapterFactoryLabelProvider(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
        if (adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)adapterFactory).addListener((INotifyChangedListener)this);
        }
        this.labelProviderListeners = new ArrayList();
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void setAdapterFactory(AdapterFactory adapterFactory) {
        if (this.adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)this.adapterFactory).removeListener((INotifyChangedListener)this);
        }
        if (adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)adapterFactory).addListener((INotifyChangedListener)this);
        }
        this.adapterFactory = adapterFactory;
    }

    public void addListener(ILabelProviderListener listener) {
        this.labelProviderListeners.add(listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.labelProviderListeners.remove(listener);
    }

    public void dispose() {
        if (this.adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)this.adapterFactory).removeListener((INotifyChangedListener)this);
        }
    }

    public boolean isLabelProperty(Object object, String id) {
        return true;
    }

    public Image getImage(Object object) {
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt(object, (Object)IItemLabelProviderClass);
        return itemLabelProvider != null ? this.getImageFromObject(itemLabelProvider.getImage(object)) : this.getDefaultImage(object);
    }

    protected Image getDefaultImage(Object object) {
        String image = "full/obj16/GenericValue";
        if (object instanceof String) {
            image = "full/obj16/TextValue";
        } else if (object instanceof Boolean) {
            image = "full/obj16/BooleanValue";
        } else if (object instanceof Float || object instanceof Double) {
            image = "full/obj16/RealValue";
        } else if (object instanceof Integer || object instanceof Short || object instanceof Long || object instanceof Byte) {
            image = "full/obj16/RealValue";
        }
        return this.getImageFromObject(EMFEditPlugin.INSTANCE.getImage(image));
    }

    protected Image getImageFromObject(Object object) {
        return ExtendedImageRegistry.getInstance().getImage(object);
    }

    public String getText(Object object) {
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt(object, (Object)IItemLabelProviderClass);
        return itemLabelProvider != null ? itemLabelProvider.getText(object) : (object == null ? "" : object.toString());
    }

    public Image getColumnImage(Object object, int columnIndex) {
        ITableItemLabelProvider tableItemLabelProvider = (ITableItemLabelProvider)this.adapterFactory.adapt(object, (Object)ITableItemLabelProviderClass);
        Image result = null;
        if (tableItemLabelProvider != null) {
            result = this.getImageFromObject(tableItemLabelProvider.getColumnImage(object, columnIndex));
        } else {
            IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt(object, (Object)IItemLabelProviderClass);
            if (itemLabelProvider != null) {
                result = this.getImageFromObject(itemLabelProvider.getImage(object));
            }
        }
        return result;
    }

    public String getColumnText(Object object, int columnIndex) {
        ITableItemLabelProvider tableItemLabelProvider = (ITableItemLabelProvider)this.adapterFactory.adapt(object, (Object)ITableItemLabelProviderClass);
        if (tableItemLabelProvider != null) {
            return tableItemLabelProvider.getColumnText(object, columnIndex);
        }
        IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt(object, (Object)IItemLabelProviderClass);
        if (itemLabelProvider != null) {
            return itemLabelProvider.getText(object);
        }
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    public void fireLabelProviderChanged() {
        Iterator i = this.labelProviderListeners.iterator();
        while (i.hasNext()) {
            ILabelProviderListener labelProviderListener = (ILabelProviderListener)i.next();
            labelProviderListener.labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }
    }

    public void notifyChanged(Notification notification) {
    }
}

