/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.ECrossReferenceEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class ECrossReferenceAdapter
implements Adapter.Internal {
    protected Set unloadedResources = new HashSet();
    protected InverseCrossReferencer inverseCrossReferencer = this.createInverseCrossReferencer();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static ECrossReferenceAdapter getCrossReferenceAdapter(Notifier notifier) {
        EList adapters = notifier.eAdapters();
        int i = 0;
        int size = adapters.size();
        while (i < size) {
            Object adapter = adapters.get(i);
            if (adapter instanceof ECrossReferenceAdapter) {
                return (ECrossReferenceAdapter)adapter;
            }
            ++i;
        }
        return null;
    }

    public Collection getNonNavigableInverseReferences(EObject eObject) {
        return this.getNonNavigableInverseReferences(eObject, !this.resolve());
    }

    public Collection getNonNavigableInverseReferences(EObject eObject, boolean resolve) {
        Collection result;
        if (resolve) {
            this.resolveAll(eObject);
        }
        if ((result = (Collection)this.inverseCrossReferencer.get(eObject)) == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    public Collection getInverseReferences(EObject eObject) {
        return this.getInverseReferences(eObject, !this.resolve());
    }

    public Collection getInverseReferences(EObject eObject, boolean resolve) {
        Collection nonNavigableInverseReferences;
        EObject eContainer;
        ArrayList<EStructuralFeature.Setting> result = new ArrayList<EStructuralFeature.Setting>();
        if (resolve) {
            this.resolveAll(eObject);
        }
        if ((eContainer = eObject.eContainer()) != null) {
            result.add(((InternalEObject)eContainer).eSetting(eObject.eContainmentFeature()));
        }
        if ((nonNavigableInverseReferences = (Collection)this.inverseCrossReferencer.get(eObject)) != null) {
            result.addAll(nonNavigableInverseReferences);
        }
        Iterator i = eObject.eClass().getEAllReferences().iterator();
        while (i.hasNext()) {
            EReference eReference = (EReference)i.next();
            EReference eOpposite = eReference.getEOpposite();
            if (eOpposite == null || eReference.isContainer() || !eObject.eIsSet(eReference)) continue;
            if (eReference.isMany()) {
                Object collection = eObject.eGet(eReference);
                Iterator j = this.resolve() ? ((Collection)collection).iterator() : ((InternalEList)collection).basicIterator();
                while (j.hasNext()) {
                    InternalEObject referencingEObject = (InternalEObject)j.next();
                    result.add(referencingEObject.eSetting(eOpposite));
                }
                continue;
            }
            result.add(((InternalEObject)eObject.eGet(eReference, this.resolve())).eSetting(eOpposite));
        }
        return result;
    }

    protected void resolveAll(EObject eObject) {
        Resource resource;
        if (!eObject.eIsProxy() && (resource = eObject.eResource()) != null) {
            URI uri = resource.getURI();
            if (uri != null) {
                ResourceSet resourceSet = resource.getResourceSet();
                if (resourceSet != null) {
                    uri = resourceSet.getURIConverter().normalize(uri);
                }
                uri = uri.appendFragment(resource.getURIFragment(eObject));
            } else {
                URI.createHierarchicalURI(null, null, (String)resource.getURIFragment(eObject));
            }
            List proxies = this.inverseCrossReferencer.removeProxies(uri);
            if (proxies != null) {
                int i = 0;
                int size = proxies.size();
                while (i < size) {
                    EObject proxy = (EObject)proxies.get(i);
                    Iterator inverseReferences = this.getInverseReferences(proxy, false).iterator();
                    while (inverseReferences.hasNext()) {
                        List list;
                        int index;
                        EStructuralFeature.Setting setting = (EStructuralFeature.Setting)inverseReferences.next();
                        Object value = setting.get(true);
                        if (!setting.getEStructuralFeature().isMany() || (index = (list = (List)value).indexOf(proxy)) == -1) continue;
                        list.get(index);
                    }
                    ++i;
                }
            }
        }
    }

    protected boolean isIncluded(EReference eReference) {
        return eReference.getEOpposite() == null && !eReference.isDerived();
    }

    protected InverseCrossReferencer createInverseCrossReferencer() {
        return new InverseCrossReferencer();
    }

    public void notifyChanged(Notification notification) {
        this.selfAdapt(notification);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void selfAdapt(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof EObject) {
            Object feature = notification.getFeature();
            if (!(feature instanceof EReference)) return;
            EReference reference = (EReference)feature;
            if (reference.isContainment()) {
                this.handleContainment(notification);
                return;
            } else {
                if (!this.isIncluded(reference)) return;
                this.handleCrossReference(reference, notification);
            }
            return;
        }
        if (notifier instanceof Resource) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.ecore.resource.Resource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            switch (notification.getFeatureID((Class)clazz)) {
                case 2: {
                    if (this.unloadedResources.contains(notifier)) return;
                    this.handleContainment(notification);
                    return;
                }
                case 4: {
                    if (notification.getNewBooleanValue()) {
                        this.unloadedResources.remove(notifier);
                        Iterator i = ((Resource)notifier).getContents().iterator();
                        while (i.hasNext()) {
                            Notifier child = (Notifier)i.next();
                            this.addAdapter(child);
                        }
                        return;
                    }
                    this.unloadedResources.add(notifier);
                }
                default: {
                    return;
                }
            }
        }
        if (!(notifier instanceof ResourceSet)) return;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.emf.ecore.resource.ResourceSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (notification.getFeatureID((Class)clazz) != 0) return;
        this.handleContainment(notification);
    }

    protected void handleContainment(Notification notification) {
        switch (notification.getEventType()) {
            case 9: {
                Notifier oldValue = (Notifier)notification.getOldValue();
                this.removeAdapter(oldValue);
                Notifier newValue = (Notifier)notification.getNewValue();
                this.addAdapter(newValue);
                break;
            }
            case 2: {
                Object newValue = notification.getNewValue();
                if (newValue == null || newValue == Boolean.TRUE || newValue == Boolean.FALSE) break;
                this.addAdapter((Notifier)newValue);
                break;
            }
            case 1: {
                Notifier newValue = (Notifier)notification.getNewValue();
                if (newValue == null) break;
                this.addAdapter(newValue);
                break;
            }
            case 3: {
                Notifier newValue = (Notifier)notification.getNewValue();
                if (newValue == null) break;
                this.addAdapter(newValue);
                break;
            }
            case 5: {
                Collection newValues = (Collection)notification.getNewValue();
                Iterator i = newValues.iterator();
                while (i.hasNext()) {
                    Notifier newValue = (Notifier)i.next();
                    this.addAdapter(newValue);
                }
                break;
            }
        }
    }

    protected void handleCrossReference(EReference reference, Notification notification) {
        switch (notification.getEventType()) {
            case 1: 
            case 2: 
            case 9: {
                EObject newValue;
                EObject notifier = (EObject)notification.getNotifier();
                EReference feature = (EReference)notification.getFeature();
                EObject oldValue = (EObject)notification.getOldValue();
                if (oldValue != null) {
                    this.inverseCrossReferencer.remove(notifier, feature, oldValue);
                }
                if ((newValue = (EObject)notification.getNewValue()) == null) break;
                this.inverseCrossReferencer.add(notifier, feature, newValue);
                break;
            }
            case 3: {
                EObject newValue = (EObject)notification.getNewValue();
                if (newValue == null) break;
                this.inverseCrossReferencer.add((EObject)notification.getNotifier(), (EReference)notification.getFeature(), newValue);
                break;
            }
            case 5: {
                EObject notifier = (EObject)notification.getNotifier();
                EReference feature = (EReference)notification.getFeature();
                Collection newValues = (Collection)notification.getNewValue();
                Iterator i = newValues.iterator();
                while (i.hasNext()) {
                    EObject newValue = (EObject)i.next();
                    this.inverseCrossReferencer.add(notifier, feature, newValue);
                }
                break;
            }
            case 4: {
                EObject oldValue = (EObject)notification.getOldValue();
                if (oldValue == null) break;
                this.inverseCrossReferencer.remove((EObject)notification.getNotifier(), (EReference)notification.getFeature(), oldValue);
                break;
            }
            case 6: {
                EObject notifier = (EObject)notification.getNotifier();
                EReference feature = (EReference)notification.getFeature();
                Collection oldValues = (Collection)notification.getOldValue();
                Iterator i = oldValues.iterator();
                while (i.hasNext()) {
                    EObject oldValue = (EObject)i.next();
                    this.inverseCrossReferencer.remove(notifier, feature, oldValue);
                }
                break;
            }
        }
    }

    public void setTarget(Notifier target) {
        if (target instanceof EObject) {
            this.setTarget((EObject)target);
        } else if (target instanceof Resource) {
            this.setTarget((Resource)target);
        } else if (target instanceof ResourceSet) {
            this.setTarget((ResourceSet)target);
        }
    }

    protected void setTarget(EObject target) {
        this.inverseCrossReferencer.add(target);
        Iterator i = this.resolve() ? target.eContents().iterator() : ((InternalEList)target.eContents()).basicIterator();
        while (i.hasNext()) {
            Notifier notifier = (Notifier)i.next();
            this.addAdapter(notifier);
        }
    }

    protected void setTarget(Resource target) {
        if (!target.isLoaded()) {
            this.unloadedResources.add(target);
        }
        EList contents = target.getContents();
        int i = 0;
        int size = contents.size();
        while (i < size) {
            Notifier notifier = (Notifier)contents.get(i);
            this.addAdapter(notifier);
            ++i;
        }
    }

    protected void setTarget(ResourceSet target) {
        EList resources = target.getResources();
        int i = 0;
        while (i < resources.size()) {
            Notifier notifier = (Notifier)resources.get(i);
            this.addAdapter(notifier);
            ++i;
        }
    }

    public void unsetTarget(Notifier target) {
        if (target instanceof EObject) {
            this.unsetTarget((EObject)target);
        } else if (target instanceof Resource) {
            this.unsetTarget((Resource)target);
        } else if (target instanceof ResourceSet) {
            this.unsetTarget((ResourceSet)target);
        }
    }

    protected void unsetTarget(EObject target) {
        this.inverseCrossReferencer.remove(target);
        Iterator i = this.inverseCrossReferencer.getCrossReferences(target);
        while (i.hasNext()) {
            EObject crossReferencedEObject = (EObject)i.next();
            this.inverseCrossReferencer.remove(target, (EReference)i.feature(), crossReferencedEObject);
        }
        i = this.resolve() ? target.eContents().iterator() : ((InternalEList)target.eContents()).basicIterator();
        while (i.hasNext()) {
            Notifier notifier = (Notifier)i.next();
            this.removeAdapter(notifier);
        }
    }

    protected void unsetTarget(Resource target) {
        EList contents = target.getContents();
        int i = 0;
        int size = contents.size();
        while (i < size) {
            Notifier notifier = (Notifier)contents.get(i);
            this.removeAdapter(notifier);
            ++i;
        }
    }

    protected void unsetTarget(ResourceSet target) {
        EList resources = target.getResources();
        int i = 0;
        while (i < resources.size()) {
            Notifier notifier = (Notifier)resources.get(i);
            this.removeAdapter(notifier);
            ++i;
        }
    }

    protected void addAdapter(Notifier notifier) {
        EList eAdapters = notifier.eAdapters();
        if (!eAdapters.contains(this)) {
            eAdapters.add(this);
        }
    }

    protected void removeAdapter(Notifier notifier) {
        notifier.eAdapters().remove((Object)this);
    }

    public void dump() {
        EcoreUtil.CrossReferencer.print(System.out, this.inverseCrossReferencer);
    }

    public Notifier getTarget() {
        return null;
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    protected boolean resolve() {
        return true;
    }

    protected class InverseCrossReferencer
    extends EcoreUtil.CrossReferencer {
        protected Map proxyMap;

        protected InverseCrossReferencer() {
            super((Collection)null);
        }

        protected EContentsEList.FeatureIterator getCrossReferences(EObject eObject) {
            return new ECrossReferenceEList.FeatureIteratorImpl(this, eObject){
                final /* synthetic */ InverseCrossReferencer this$1;
                {
                    this.this$1 = inverseCrossReferencer;
                }

                protected boolean isIncluded(EStructuralFeature eStructuralFeature) {
                    return FeatureMapUtil.isFeatureMap(eStructuralFeature) || InverseCrossReferencer.access$0(this.this$1).isIncluded((EReference)eStructuralFeature);
                }

                protected boolean resolve() {
                    return this.this$1.resolve();
                }
            };
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            return ECrossReferenceAdapter.this.isIncluded(eReference);
        }

        protected Collection newCollection() {
            return new BasicEList(this){
                final /* synthetic */ InverseCrossReferencer this$1;
                {
                    this.this$1 = inverseCrossReferencer;
                }

                protected Object[] newData(int capacity) {
                    return new EStructuralFeature.Setting[capacity];
                }

                public boolean add(Object object) {
                    EStructuralFeature.Setting setting = (EStructuralFeature.Setting)object;
                    EObject eObject = setting.getEObject();
                    EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                    EStructuralFeature.Setting[] settingData = (EStructuralFeature.Setting[])this.data;
                    int i = 0;
                    while (i < this.size) {
                        EStructuralFeature.Setting containedSetting = settingData[i];
                        if (containedSetting.getEObject() == eObject && containedSetting.getEStructuralFeature() == eStructuralFeature) {
                            return false;
                        }
                        ++i;
                    }
                    this.addUnique(object);
                    return true;
                }
            };
        }

        public void add(EObject eObject) {
            this.handleCrossReference(eObject);
            if (!this.resolve()) {
                this.addProxy(eObject, eObject);
            }
        }

        protected void add(InternalEObject eObject, EReference eReference, EObject crossReferencedEObject) {
            super.add(eObject, eReference, crossReferencedEObject);
            if (!this.resolve()) {
                this.addProxy(crossReferencedEObject, eObject);
            }
        }

        public void add(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            this.add((InternalEObject)eObject, eReference, crossReferencedEObject);
        }

        protected void addProxy(EObject proxy, EObject context) {
            if (proxy.eIsProxy()) {
                URI uri;
                List proxies;
                if (this.proxyMap == null) {
                    this.proxyMap = new HashMap();
                }
                if ((proxies = (List)this.proxyMap.get(uri = this.normalizeURI(((InternalEObject)proxy).eProxyURI(), context))) == null) {
                    proxies = new BasicEList.FastCompare();
                    this.proxyMap.put(uri, proxies);
                }
                proxies.add(proxy);
            }
        }

        public Object remove(EObject eObject) {
            if (!this.resolve()) {
                this.removeProxy(eObject, eObject);
            }
            return super.remove(eObject);
        }

        public void remove(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            BasicEList collection;
            if (!this.resolve()) {
                this.removeProxy(crossReferencedEObject, eObject);
            }
            if ((collection = (BasicEList)this.get(crossReferencedEObject)) != null) {
                EStructuralFeature.Setting[] settingData = (EStructuralFeature.Setting[])collection.data();
                int i = 0;
                int size = collection.size();
                while (i < size) {
                    EStructuralFeature.Setting setting = settingData[i];
                    if (setting.getEObject() == eObject && setting.getEStructuralFeature() == eReference) {
                        if (collection.size() == 1) {
                            this.remove(crossReferencedEObject);
                            break;
                        }
                        collection.remove(i);
                        break;
                    }
                    ++i;
                }
            }
        }

        protected void removeProxy(EObject proxy, EObject context) {
            URI uri;
            List proxies;
            if (this.proxyMap != null && proxy.eIsProxy() && (proxies = (List)this.proxyMap.get(uri = this.normalizeURI(((InternalEObject)proxy).eProxyURI(), context))) != null) {
                proxies.remove(proxy);
                if (proxies.isEmpty()) {
                    this.proxyMap.remove(uri);
                }
            }
        }

        protected List removeProxies(URI uri) {
            return this.proxyMap != null ? (List)this.proxyMap.remove(uri) : null;
        }

        protected URI normalizeURI(URI uri, EObject objectContext) {
            ResourceSet resourceSetContext;
            Resource resourceContext;
            int index;
            int length;
            String fragment = uri.fragment();
            if (fragment != null && (length = fragment.length()) > 0 && fragment.charAt(0) != '/' && fragment.charAt(length - 1) == '?' && (index = fragment.lastIndexOf(63, length - 2)) > 0) {
                uri = uri.trimFragment().appendFragment(fragment.substring(0, index));
            }
            if ((resourceContext = objectContext.eResource()) != null && (resourceSetContext = resourceContext.getResourceSet()) != null) {
                return resourceSetContext.getURIConverter().normalize(uri);
            }
            return uri;
        }

        protected boolean resolve() {
            return ECrossReferenceAdapter.this.resolve();
        }

        static /* synthetic */ ECrossReferenceAdapter access$0(InverseCrossReferencer inverseCrossReferencer) {
            return inverseCrossReferencer.ECrossReferenceAdapter.this;
        }
    }
}

