/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.testing;

import com.darwinsys.testing.TestUtils;
import java.util.Calendar;
import java.util.Date;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class TestUtilsTest
extends TestCase {
    public void testEqualsObjectObject() {
        Calendar c = Calendar.getInstance();
        Mock m1 = new Mock();
        m1.i = 42;
        m1.j = "Hello";
        m1.d = c.getTime();
        Mock m2 = new Mock();
        m2.i = m1.i;
        m2.j = m1.j;
        m2.d = m1.d;
        System.out.println(m1);
        System.out.println(m2);
        TestUtilsTest.assertEquals((Object)m1, (Object)m2);
        TestUtilsTest.assertTrue((boolean)TestUtils.equals(m1, m2));
        TestUtilsTest.assertTrue((boolean)TestUtils.equals(m2, m1));
        TestUtilsTest.assertFalse((boolean)TestUtils.equals(m2, null));
        ++m2.i;
        TestUtilsTest.assertFalse((boolean)TestUtils.equals(m1, m2));
        --m2.i;
        TestUtilsTest.assertTrue((boolean)TestUtils.equals(m2, m1));
        c.set(1, c.get(1) - 1);
        m2.d = c.getTime();
        TestUtilsTest.assertFalse((boolean)TestUtils.equals(m1, m2));
    }

    public void testAssertNoDefaultProperties() throws Exception {
        Object o = new Object();
        TestUtils.assertNoDefaultProperties(o);
        Mock m = new Mock();
        try {
            TestUtils.assertNoDefaultProperties(m);
            TestUtilsTest.fail((String)"Didn't find null properties in blank Mock");
        }
        catch (AssertionFailedError e) {
            System.out.println("Caught expected " + (Object)((Object)e));
        }
        m.d = new Date();
        m.i = 1000;
        m.j = "mockme";
        TestUtils.assertNoDefaultProperties(m);
    }

    static class Mock {
        int i;
        String j;
        private Date d;

        Mock() {
        }

        public Date getDate() {
            return this.d;
        }

        public void setDate(Date d) {
            this.d = d;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != Mock.class) {
                return false;
            }
            Mock m = (Mock)o;
            return this.i == m.i && this.j == m.j && this.d.equals(m.d);
        }

        public int hashCode() {
            return this.i | this.j.hashCode() | this.d.hashCode();
        }
    }
}

