/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.swingui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ButtonExclusionGroup {
    List<AbstractButton> buttons = new ArrayList<AbstractButton>();
    AbstractButton enabled;
    private PropertyChangeListener listener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (!"enabled".equals(evt.getPropertyName())) {
                return;
            }
            AbstractButton source = (AbstractButton)evt.getSource();
            if (ButtonExclusionGroup.this.buttons.contains(source)) {
                throw new IllegalArgumentException("Button not in group");
            }
            ButtonExclusionGroup.this.enabled = source;
            for (AbstractButton b : ButtonExclusionGroup.this.buttons) {
                if (b == source) continue;
                b.setEnabled(false);
            }
        }
    };

    public ButtonExclusionGroup() {
    }

    public ButtonExclusionGroup(AbstractButton b1, AbstractButton b2) {
        this.add(b1);
        this.add(b2);
    }

    AbstractButton getEnabled() {
        return this.enabled;
    }

    boolean isSelected(AbstractButton b) {
        return b == this.enabled;
    }

    void setEnabled(AbstractButton b) {
        if (this.enabled != null) {
            this.enabled.setEnabled(false);
        }
        this.enabled = b;
        b.setEnabled(true);
    }

    void add(AbstractButton b) {
        this.buttons.add(b);
        b.addPropertyChangeListener(this.listener);
    }

    void remove(AbstractButton b) {
        b.removePropertyChangeListener(this.listener);
        this.buttons.remove(b);
    }

    int getButtonCount() {
        return this.buttons.size();
    }

    Iterator<AbstractButton> getElements() {
        return this.buttons.iterator();
    }
}

