/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.security;

import ca.sqlpower.security.EmailNotification;
import ca.sqlpower.security.PLGroup;
import ca.sqlpower.security.PLSecurityException;
import ca.sqlpower.security.PLUser;
import ca.sqlpower.sql.DBConnection;
import ca.sqlpower.sql.DatabaseObject;
import ca.sqlpower.sql.SQL;
import ca.sqlpower.util.UnknownFreqCodeException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;

public class PLSecurityManager
implements Serializable {
    private static final Logger logger = Logger.getLogger((Class)(class$ca$sqlpower$security$PLSecurityManager == null ? (class$ca$sqlpower$security$PLSecurityManager = PLSecurityManager.class$("ca.sqlpower.security.PLSecurityManager")) : class$ca$sqlpower$security$PLSecurityManager));
    public static final String MODIFY_PERMISSION = "permission.modify";
    public static final String DELETE_PERMISSION = "permission.delete";
    public static final String EXECUTE_PERMISSION = "permission.execute";
    public static final String GRANT_PERMISSION = "permission.grant";
    public static final String NOTIFY_PERMISSION = "permission.notify";
    public static final String LOGIN_PERMISSION = "permission.login";
    public static final String CREATE_PERMISSION = "permission.create";
    public static final String BAD_CREDENTIALS = "security.credentials";
    public static final String INVALID_MANAGER = "security.invalid";
    public static final String INSUFFICIENT_ACCESS = "security.insufficient";
    PLUser principal;
    static /* synthetic */ Class class$ca$sqlpower$security$PLSecurityManager;

    protected PLSecurityManager() {
    }

    public PLSecurityManager(Connection con, String username, String password) throws SQLException, PLSecurityException, UnknownFreqCodeException {
        this(con, username, password, true);
    }

    public PLSecurityManager(Connection con, String username, String password, boolean passwordRequired) throws SQLException, PLSecurityException, UnknownFreqCodeException {
        if (password == null) {
            throw new NullPointerException("null password not allowed");
        }
        if (!passwordRequired) {
            logger.error((Object)"WARNING: YOU ARE USING THE PL SECURITY MANAGER IN INSECURE MODE!!!");
        }
        this.principal = PLUser.findByPrimaryKeyDoNotUse(con, username, password, passwordRequired);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkModifiableObject(Connection con, PLUser p, DatabaseObject obj) throws SQLException {
        StringBuffer sql = new StringBuffer(500);
        sql.append("SELECT COUNT(object_name)");
        sql.append(" FROM have_i_the_right");
        sql.append(" WHERE user_id=").append(SQL.quote(p.getUserId()));
        sql.append(" AND object_type=").append(SQL.quote(obj.getObjectType()));
        sql.append(" AND modify_ind='Y'");
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(sql.toString());
            rs.next();
            int numResults = rs.getInt(1);
            if (numResults > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public void checkCreateAny(Connection con, String objectType) throws SQLException, PLSecurityException {
        if (this.principal == null) {
            throw new PLSecurityException(MODIFY_PERMISSION, INVALID_MANAGER, null);
        }
        PLSecurityManager.checkPermission(con, this.principal, PLSecurityManager.getSystemObject(objectType), CREATE_PERMISSION, true);
    }

    public boolean canCreateAny(Connection con, String objectType) throws SQLException {
        if (this.principal == null) {
            throw new PLSecurityException(MODIFY_PERMISSION, INVALID_MANAGER, null);
        }
        return PLSecurityManager.checkPermission(con, this.principal, PLSecurityManager.getSystemObject(objectType), CREATE_PERMISSION, false);
    }

    public void checkModify(Connection con, DatabaseObject obj) throws SQLException, PLSecurityException {
        if (this.principal == null) {
            throw new PLSecurityException(MODIFY_PERMISSION, INVALID_MANAGER, obj);
        }
        PLSecurityManager.checkPermission(con, this.principal, obj, MODIFY_PERMISSION, true);
    }

    public boolean canModify(Connection con, DatabaseObject obj) throws SQLException {
        if (this.principal == null) {
            throw new PLSecurityException(MODIFY_PERMISSION, INVALID_MANAGER, obj);
        }
        return PLSecurityManager.checkPermission(con, this.principal, obj, MODIFY_PERMISSION, false);
    }

    public boolean canModifyAny(Connection con, String objectType) throws SQLException {
        if (this.principal == null) {
            throw new PLSecurityException(MODIFY_PERMISSION, INVALID_MANAGER, null);
        }
        return PLSecurityManager.checkPermission(con, this.principal, PLSecurityManager.getSystemObject(objectType), MODIFY_PERMISSION, false);
    }

    public void checkDelete(Connection con, DatabaseObject obj) throws SQLException, PLSecurityException {
        if (this.principal == null) {
            throw new PLSecurityException(DELETE_PERMISSION, INVALID_MANAGER, obj);
        }
        PLSecurityManager.checkPermission(con, this.principal, obj, DELETE_PERMISSION, true);
    }

    public boolean canDelete(Connection con, DatabaseObject obj) throws SQLException {
        if (this.principal == null) {
            throw new PLSecurityException(DELETE_PERMISSION, INVALID_MANAGER, obj);
        }
        return PLSecurityManager.checkPermission(con, this.principal, obj, DELETE_PERMISSION, false);
    }

    public void checkExecute(Connection con, DatabaseObject obj) throws SQLException, PLSecurityException {
        if (this.principal == null) {
            throw new PLSecurityException(EXECUTE_PERMISSION, INVALID_MANAGER, obj);
        }
        PLSecurityManager.checkPermission(con, this.principal, obj, EXECUTE_PERMISSION, true);
    }

    public boolean canExecute(Connection con, DatabaseObject obj) throws SQLException, PLSecurityException {
        if (this.principal == null) {
            throw new PLSecurityException(EXECUTE_PERMISSION, INVALID_MANAGER, obj);
        }
        return PLSecurityManager.checkPermission(con, this.principal, obj, EXECUTE_PERMISSION, false);
    }

    public void checkGrant(Connection con, DatabaseObject obj) throws SQLException, PLSecurityException {
        if (this.principal == null) {
            throw new PLSecurityException(GRANT_PERMISSION, INVALID_MANAGER, obj);
        }
        PLSecurityManager.checkPermission(con, this.principal, obj, GRANT_PERMISSION, true);
    }

    public boolean canGrant(Connection con, DatabaseObject obj) throws SQLException, PLSecurityException {
        if (this.principal == null) {
            throw new PLSecurityException(GRANT_PERMISSION, INVALID_MANAGER, obj);
        }
        return PLSecurityManager.checkPermission(con, this.principal, obj, GRANT_PERMISSION, false);
    }

    public void checkNotify(Connection con, DatabaseObject obj) throws SQLException, PLSecurityException {
        if (this.principal == null) {
            throw new PLSecurityException(NOTIFY_PERMISSION, INVALID_MANAGER, obj);
        }
        PLSecurityManager.checkPermission(con, this.principal, obj, NOTIFY_PERMISSION, true);
    }

    public boolean canNotify(Connection con, DatabaseObject obj) throws SQLException {
        if (this.principal == null) {
            throw new PLSecurityException(NOTIFY_PERMISSION, INVALID_MANAGER, obj);
        }
        return PLSecurityManager.checkPermission(con, this.principal, obj, NOTIFY_PERMISSION, false);
    }

    public static boolean checkPermission(Connection con, PLUser p, DatabaseObject obj, String perm, boolean exceptionWhenDenied) throws SQLException, PLSecurityException {
        DatabaseObject sysObject = PLSecurityManager.getSystemObject(obj.getObjectType());
        if (PLSecurityManager.checkUserPermission(con, p, obj, perm) || PLSecurityManager.checkUserPermission(con, p, sysObject, perm)) {
            return true;
        }
        Iterator groups = p.getGroups(con).iterator();
        while (groups.hasNext()) {
            PLGroup g = (PLGroup)groups.next();
            if (!PLSecurityManager.checkGroupPermission(con, g, obj, perm) && !PLSecurityManager.checkGroupPermission(con, g, sysObject, perm)) continue;
            return true;
        }
        if (exceptionWhenDenied) {
            throw new PLSecurityException(perm, INSUFFICIENT_ACCESS, obj);
        }
        return false;
    }

    public static boolean checkPermission(Connection con, PLGroup g, DatabaseObject obj, String perm, boolean exceptionWhenDenied) throws SQLException, PLSecurityException {
        DatabaseObject sysObject = PLSecurityManager.getSystemObject(obj.getObjectType());
        if (PLSecurityManager.checkGroupPermission(con, g, obj, perm) || PLSecurityManager.checkGroupPermission(con, g, sysObject, perm)) {
            return true;
        }
        if (exceptionWhenDenied) {
            throw new PLSecurityException(perm, INSUFFICIENT_ACCESS, obj);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkUserPermission(Connection con, PLUser p, DatabaseObject obj, String perm) throws SQLException, PLSecurityException {
        if (perm.equals(CREATE_PERMISSION) && !(obj instanceof AllDatabaseObject)) {
            throw new IllegalArgumentException("CREATE_PERMISSION is only valid for AllDatabaseObject types.");
        }
        StringBuffer sql = new StringBuffer(500);
        if (obj instanceof AllDatabaseObject) {
            sql.append("SELECT create_any_ind, modify_any_ind, delete_any_ind,");
            sql.append(" execute_any_ind, grant_any_ind, notify_any_ind");
            sql.append(" FROM user_system_privs");
            sql.append(" WHERE user_id=").append(SQL.quote(p.getUserId()));
            sql.append(" AND object_type=").append(SQL.quote(obj.getObjectType()));
        } else {
            sql.append("SELECT modify_ind, delete_ind, execute_ind, grant_ind, notify_ind");
            sql.append(" FROM user_object_privs");
            sql.append(" WHERE user_id=").append(SQL.quote(p.getUserId()));
            sql.append(" AND object_type=").append(SQL.quote(obj.getObjectType()));
            sql.append(" AND object_name=").append(SQL.quote(obj.getObjectName()));
        }
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(sql.toString());
            if (rs.next()) {
                String ind = null;
                ind = obj instanceof AllDatabaseObject ? rs.getString(PLSecurityManager.sysPermToColName(perm)) : rs.getString(PLSecurityManager.permToColName(perm));
                if (ind != null && ind.equals("Y")) {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkGroupPermission(Connection con, PLGroup p, DatabaseObject obj, String perm) throws SQLException, PLSecurityException {
        if (perm.equals(CREATE_PERMISSION) && !(obj instanceof AllDatabaseObject)) {
            throw new IllegalArgumentException("CREATE_PERMISSION is only valid for AllDatabaseObject types");
        }
        StringBuffer sql = new StringBuffer(500);
        if (obj instanceof AllDatabaseObject) {
            sql.append("SELECT create_any_ind, modify_any_ind, delete_any_ind,");
            sql.append(" execute_any_ind, grant_any_ind, notify_any_ind");
            sql.append(" FROM group_system_privs");
            sql.append(" WHERE group_name=").append(SQL.quote(p.getGroupName()));
            sql.append(" AND object_type=").append(SQL.quote(obj.getObjectType()));
        } else {
            sql.append("SELECT modify_ind, delete_ind, execute_ind, grant_ind, notify_ind");
            sql.append(" FROM group_object_privs");
            sql.append(" WHERE group_name=").append(SQL.quote(p.getGroupName()));
            sql.append(" AND object_type=").append(SQL.quote(obj.getObjectType()));
            sql.append(" AND object_name=").append(SQL.quote(obj.getObjectName()));
        }
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery(sql.toString());
            if (rs.next()) {
                String ind = null;
                ind = obj instanceof AllDatabaseObject ? rs.getString(PLSecurityManager.sysPermToColName(perm)) : rs.getString(PLSecurityManager.permToColName(perm));
                if (ind != null && ind.equals("Y")) {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    public void grantExecute(Connection con, PLUser grantee, DatabaseObject obj, boolean givingPerm) throws SQLException, PLSecurityException {
        PLSecurityManager.grantUserPermission(con, this.principal, grantee, obj, "", "", "", givingPerm ? "'Y'" : "'N'", "");
    }

    public void grantExecute(Connection con, PLGroup grantee, DatabaseObject obj, boolean givingPerm) throws SQLException, PLSecurityException {
        PLSecurityManager.grantGroupPermission(con, this.principal, grantee, obj, "", "", "", givingPerm ? "'Y'" : "'N'", "");
    }

    public void grantDelete(Connection con, PLUser grantee, DatabaseObject obj, boolean givingPerm) throws SQLException, PLSecurityException {
        PLSecurityManager.grantUserPermission(con, this.principal, grantee, obj, "", givingPerm ? "'Y'" : "'N'", "", "", "");
    }

    public void grantDelete(Connection con, PLGroup grantee, DatabaseObject obj, boolean givingPerm) throws SQLException, PLSecurityException {
        PLSecurityManager.grantGroupPermission(con, this.principal, grantee, obj, "", givingPerm ? "'Y'" : "'N'", "", "", "");
    }

    public void grantModify(Connection con, PLUser grantee, DatabaseObject obj, boolean givingPerm) throws SQLException, PLSecurityException {
        PLSecurityManager.grantUserPermission(con, this.principal, grantee, obj, givingPerm ? "'Y'" : "'N'", "", "", "", "");
    }

    public void grantModify(Connection con, PLGroup grantee, DatabaseObject obj, boolean givingPerm) throws SQLException, PLSecurityException {
        PLSecurityManager.grantGroupPermission(con, this.principal, grantee, obj, givingPerm ? "'Y'" : "'N'", "", "", "", "");
    }

    public void grantGrant(Connection con, PLUser grantee, DatabaseObject obj, boolean givingPerm) throws SQLException, PLSecurityException {
        PLSecurityManager.grantUserPermission(con, this.principal, grantee, obj, "", "", "", "", givingPerm ? "'Y'" : "'N'");
    }

    public void grantGrant(Connection con, PLGroup grantee, DatabaseObject obj, boolean givingPerm) throws SQLException, PLSecurityException {
        PLSecurityManager.grantGroupPermission(con, this.principal, grantee, obj, "", "", "", "", givingPerm ? "'Y'" : "'N'");
    }

    public void grantAll(Connection con, PLUser grantee, DatabaseObject obj, boolean modify, boolean delete, boolean prevExecute, boolean execute, boolean grant) throws SQLException, PLSecurityException {
        PLSecurityManager.grantUserPermission(con, this.principal, grantee, obj, modify ? "'Y'" : "'N'", delete ? "'Y'" : "'N'", prevExecute ? "'Y'" : "'N'", execute ? "'Y'" : "'N'", grant ? "'Y'" : "'N'");
    }

    public void grantAll(Connection con, PLGroup grantee, DatabaseObject obj, boolean modify, boolean delete, boolean prevExecute, boolean execute, boolean grant) throws SQLException, PLSecurityException {
        PLSecurityManager.grantGroupPermission(con, this.principal, grantee, obj, modify ? "'Y'" : "'N'", delete ? "'Y'" : "'N'", prevExecute ? "'Y'" : "'N'", execute ? "'Y'" : "'N'", grant ? "'Y'" : "'N'");
    }

    public static void grantUserPermission(Connection con, PLUser principal, PLUser grantee, DatabaseObject obj, String modify, String delete, String prevExecute, String execute, String grant) throws PLSecurityException, SQLException {
        PLSecurityManager.grantPermission(con, principal, grantee.getUserId(), true, obj, modify, delete, prevExecute, execute, grant);
    }

    public static void grantGroupPermission(Connection con, PLUser principal, PLGroup grantee, DatabaseObject obj, String modify, String delete, String prevExecute, String execute, String grant) throws PLSecurityException, SQLException {
        PLSecurityManager.grantPermission(con, principal, grantee.getGroupName(), false, obj, modify, delete, prevExecute, execute, grant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void grantPermission(Connection con, PLUser principal, String granteeName, boolean granteeIsUser, DatabaseObject obj, String modify, String delete, String prevExecute, String execute, String grant) throws PLSecurityException, SQLException {
        block29: {
            PLSecurityManager.checkPermission(con, principal, obj, GRANT_PERMISSION, true);
            Statement stmt = null;
            try {
                stmt = con.createStatement();
                StringBuffer sql = new StringBuffer(500);
                if (granteeIsUser) {
                    sql.append("UPDATE user_object_privs SET ");
                } else {
                    sql.append("UPDATE group_object_privs SET ");
                }
                sql.append("last_update_date=").append(DBConnection.getSystemDate(con));
                sql.append(", last_update_user=").append(SQL.quote(principal.getUserId()));
                sql.append(", last_update_os_user='Power*Dashboard Web Facility'");
                if (modify != null && !modify.equals("")) {
                    sql.append(", modify_ind=").append(modify);
                }
                if (delete != null && !delete.equals("")) {
                    sql.append(", delete_ind=").append(delete);
                }
                if (execute != null && !execute.equals("")) {
                    sql.append(", execute_ind=").append(execute);
                }
                if (grant != null && !grant.equals("")) {
                    sql.append(", grant_ind=").append(grant);
                }
                if (granteeIsUser) {
                    sql.append(" WHERE user_id=").append(SQL.quote(granteeName));
                } else {
                    sql.append(" WHERE group_name=").append(SQL.quote(granteeName));
                }
                sql.append(" AND object_type=").append(SQL.quote(obj.getObjectType()));
                sql.append(" AND object_name=").append(SQL.quote(obj.getObjectName()));
                int updateCount = stmt.executeUpdate(sql.toString());
                if (updateCount > 1) {
                    throw new IllegalStateException("Updated " + updateCount + " rows (should have been 1 or 0)");
                }
                if (updateCount == 0) {
                    sql.setLength(0);
                    sql.setLength(500);
                    if (granteeIsUser) {
                        sql.append("INSERT INTO user_object_privs (");
                    } else {
                        sql.append("INSERT INTO group_object_privs (");
                    }
                    sql.append("modify_ind,delete_ind,execute_ind,grant_ind");
                    if (granteeIsUser) {
                        sql.append(",user_id");
                    } else {
                        sql.append(",group_name");
                    }
                    sql.append(", object_type, object_name");
                    sql.append(", last_update_user, last_update_os_user, last_update_date");
                    sql.append(") VALUES (").append(modify);
                    sql.append(", ").append(delete);
                    sql.append(", ").append(execute);
                    sql.append(", ").append(grant);
                    sql.append(", ").append(SQL.quote(granteeName));
                    sql.append(", ").append(SQL.quote(obj.getObjectType()));
                    sql.append(", ").append(SQL.quote(obj.getObjectName()));
                    sql.append(", ").append(SQL.quote(principal.getUserId()));
                    sql.append(", 'Power*Dashboard Web Facility'");
                    sql.append(", null");
                    sql.append(")");
                    try {
                        updateCount = stmt.executeUpdate(sql.toString());
                    }
                    catch (SQLException e) {
                        System.out.println("Caught " + e.getMessage());
                        System.out.println("Query: " + sql);
                        throw e;
                    }
                    catch (NoSuchElementException e) {
                        System.out.println("Caught " + e.getMessage());
                        System.out.println("Query: " + sql);
                        throw e;
                    }
                    if (updateCount > 1) {
                        throw new IllegalStateException("Updated " + updateCount + " rows (should have been 1 or 0)");
                    }
                    if (updateCount == 0) {
                        throw new IllegalStateException("Could not update or insert permission!");
                    }
                }
                if (!obj.getObjectType().equals("KPI") || !execute.equals("'Y'") || prevExecute.equals("'Y'")) break block29;
                sql.setLength(0);
                sql.append("INSERT INTO pl_user_notification(");
                sql.append("  user_id, object_type, object_name,");
                sql.append(" view_kpi_ind, email_red_ind, email_yellow_ind, email_green_ind)");
                if (granteeIsUser) {
                    sql.append(" VALUES(").append(SQL.quote(granteeName)).append(",");
                    sql.append(SQL.quote(obj.getObjectType())).append(",");
                    sql.append(SQL.quote(obj.getObjectName())).append(",");
                    sql.append("'N','N','N','N'").append(")");
                } else {
                    sql.append(" SELECT user_id,");
                    sql.append(SQL.quote(obj.getObjectType())).append(",");
                    sql.append(SQL.quote(obj.getObjectName())).append(",");
                    sql.append(" 'N','N','N','N'");
                    sql.append(" FROM user_group");
                    sql.append(" WHERE group_name=").append(SQL.quote(granteeName));
                }
                try {
                    updateCount = stmt.executeUpdate(sql.toString());
                }
                catch (SQLException e) {
                    // empty catch block
                }
                sql.setLength(0);
                sql.append("UPDATE pl_user_notification");
                sql.append(" SET view_kpi_ind='Y'");
                sql.append(" WHERE object_type=").append(SQL.quote(obj.getObjectType()));
                sql.append(" AND object_name=").append(SQL.quote(obj.getObjectName()));
                if (granteeIsUser) {
                    sql.append(" AND user_id=").append(SQL.quote(granteeName));
                } else {
                    sql.append(" AND user_id IN(");
                    sql.append("   SELECT user_id");
                    sql.append("   FROM user_group");
                    sql.append("   WHERE group_name=").append(SQL.quote(granteeName)).append(")");
                }
                updateCount = stmt.executeUpdate(sql.toString());
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    public static void createDatabaseObject(Connection con, PLSecurityManager sm, DatabaseObject obj) throws SQLException, PLSecurityException {
        sm.checkCreateAny(con, obj.getObjectType());
        StringBuffer sql = new StringBuffer(50);
        sql.append("INSERT INTO user_object_privs (user_id");
        sql.append(", object_type, object_name");
        sql.append(", last_update_user, last_update_os_user, last_update_date");
        sql.append(", execute_ind, modify_ind, delete_ind, grant_ind");
        sql.append(") VALUES (").append(SQL.quote(sm.principal.getUserId()));
        sql.append(", ").append(SQL.quote(obj.getObjectType()));
        sql.append(", ").append(SQL.quote(obj.getObjectName()));
        sql.append(", ").append(SQL.quote(sm.principal.getUserId()));
        sql.append(", 'Power*Dashboard Web Facility'");
        sql.append(", ").append(DBConnection.getSystemDate(con));
        sql.append(", 'Y', 'Y', 'Y', 'Y'");
        sql.append(")");
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.executeUpdate(sql.toString());
            if (obj.getObjectType().equals("KPI")) {
                EmailNotification.setPref(con, sm, sm.principal, obj, "Y", "", "", "", new Double(-1.0));
            }
        }
        catch (SQLException e) {
            System.out.println("PLSecurityManager.createDatabaseObject: Error in SQL Statement: " + e.getMessage());
            System.out.println("Query: " + sql);
            throw e;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteDatabaseObject(Connection con, PLSecurityManager sm, DatabaseObject obj) throws PLSecurityException, SQLException {
        sm.checkDelete(con, obj);
        Statement stmt = null;
        try {
            EmailNotification.deleteDatabaseObject(con, sm, obj);
            stmt = con.createStatement();
            StringBuffer sql = new StringBuffer();
            sql.append("DELETE FROM user_object_privs WHERE object_type=");
            sql.append(SQL.quote(obj.getObjectType()));
            sql.append(" AND object_name=").append(SQL.quote(obj.getObjectName()));
            stmt.executeUpdate(sql.toString());
            sql.setLength(0);
            sql.append("DELETE FROM group_object_privs WHERE object_type=");
            sql.append(SQL.quote(obj.getObjectType()));
            sql.append(" AND object_name=").append(SQL.quote(obj.getObjectName()));
            stmt.executeUpdate(sql.toString());
            if (obj.getObjectType().equals("TRANSACTION")) {
                sql.setLength(0);
                sql.append("DELETE FROM pl_transform_stats");
                sql.append(" WHERE trans_id=").append(SQL.quote(obj.getObjectName()));
                stmt.executeUpdate(sql.toString());
            }
            sql.setLength(0);
            sql.append("DELETE FROM pl_stats WHERE object_type=");
            sql.append(SQL.quote(obj.getObjectType()));
            sql.append(" AND object_name=").append(SQL.quote(obj.getObjectName()));
            stmt.executeUpdate(sql.toString());
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renameDatabaseObject(Connection con, PLSecurityManager sm, DatabaseObject obj, String newName) throws PLSecurityException, SQLException {
        sm.checkModify(con, obj);
        Statement stmt = null;
        try {
            EmailNotification.renameDatabaseObject(con, sm, obj, newName);
            stmt = con.createStatement();
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE user_object_privs SET object_name=").append(SQL.quote(newName));
            sql.append(" WHERE object_type=").append(SQL.quote(obj.getObjectType()));
            sql.append(" AND object_name=").append(SQL.quote(obj.getObjectName()));
            stmt.executeUpdate(sql.toString());
            sql.setLength(0);
            sql.append("UPDATE group_object_privs SET object_name=").append(SQL.quote(newName));
            sql.append(" WHERE object_type=").append(SQL.quote(obj.getObjectType()));
            sql.append(" AND object_name=").append(SQL.quote(obj.getObjectName()));
            stmt.executeUpdate(sql.toString());
            if (obj.getObjectType().equals("TRANSACTION")) {
                sql.setLength(0);
                sql.append("UPDATE pl_transform_stats SET trans_id=").append(SQL.quote(newName));
                sql.append(" WHERE trans_id=").append(SQL.quote(obj.getObjectName()));
                stmt.executeUpdate(sql.toString());
            }
            sql.setLength(0);
            sql.append("UPDATE pl_stats SET object_name=").append(SQL.quote(newName));
            sql.append(" WHERE object_type=").append(SQL.quote(obj.getObjectType()));
            sql.append(" AND object_name=").append(SQL.quote(obj.getObjectName()));
            stmt.executeUpdate(sql.toString());
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    protected static String permToColName(String perm) {
        if (perm.equals(MODIFY_PERMISSION)) {
            return "modify_ind";
        }
        if (perm.equals(DELETE_PERMISSION)) {
            return "delete_ind";
        }
        if (perm.equals(EXECUTE_PERMISSION)) {
            return "execute_ind";
        }
        if (perm.equals(GRANT_PERMISSION)) {
            return "grant_ind";
        }
        if (perm.equals(NOTIFY_PERMISSION)) {
            return "notify_ind";
        }
        throw new IllegalArgumentException("Unknown permission '" + perm + "'");
    }

    protected static String sysPermToColName(String perm) {
        if (perm.equals(CREATE_PERMISSION)) {
            return "create_any_ind";
        }
        if (perm.equals(MODIFY_PERMISSION)) {
            return "modify_any_ind";
        }
        if (perm.equals(DELETE_PERMISSION)) {
            return "delete_any_ind";
        }
        if (perm.equals(EXECUTE_PERMISSION)) {
            return "execute_any_ind";
        }
        if (perm.equals(GRANT_PERMISSION)) {
            return "grant_any_ind";
        }
        if (perm.equals(NOTIFY_PERMISSION)) {
            return "notify_any_ind";
        }
        throw new IllegalArgumentException("Unknown permission '" + perm + "'");
    }

    public PLUser getPrincipal() {
        return this.principal;
    }

    public void invalidate() {
        this.principal = null;
    }

    public static DatabaseObject getSystemObject(String type) {
        return new AllDatabaseObject(type);
    }

    public String toString() {
        return "PLSecurityManager for " + this.principal;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class AllDatabaseObject
    implements DatabaseObject {
        protected String type = null;

        public AllDatabaseObject(String type) {
            this.type = type;
        }

        public String getObjectName() {
            return "ALL";
        }

        public String getObjectType() {
            return this.type;
        }

        public boolean equals(Object other) {
            return other instanceof AllDatabaseObject && ((AllDatabaseObject)other).type.equals(this.type);
        }
    }
}

