/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.undo;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLRelationship;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.undo.SQLObjectChildren;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.log4j.Logger;

public class SQLObjectInsertChildren
extends SQLObjectChildren {
    private static final Logger logger = Logger.getLogger(SQLObjectInsertChildren.class);

    public void undo() throws CannotUndoException {
        this.removeChildren();
    }

    public void redo() throws CannotRedoException {
        try {
            this.addChildren();
        }
        catch (ArchitectException e) {
            logger.error((Object)"redo: caught exception", (Throwable)e);
            throw new CannotRedoException();
        }
    }

    public void createToolTip() {
        if (this.e.getChildren().length > 0) {
            if (this.e.getChildren()[0] instanceof SQLTable) {
                this.toolTip = "Add table";
            }
            if (this.e.getChildren()[0] instanceof SQLColumn) {
                this.toolTip = "Add column";
            }
            if (this.e.getChildren()[0] instanceof SQLRelationship) {
                this.toolTip = "Add relation";
            }
            if (this.e.getChildren().length > 1) {
                this.toolTip = String.valueOf(this.toolTip) + "s";
            }
        }
    }

    public String toString() {
        StringBuffer childList = new StringBuffer();
        childList.append("{");
        SQLObject[] sQLObjectArray = this.e.getChildren();
        int n = 0;
        int n2 = sQLObjectArray.length;
        while (n < n2) {
            SQLObject child = sQLObjectArray[n];
            childList.append(child).append(", ");
            ++n;
        }
        childList.append("}");
        return "Insert " + childList + " into " + this.e.getSource();
    }
}

