/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.table;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectRuntimeException;
import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.SQLCatalog;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLSchema;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.ddl.DDLGenerator;
import ca.sqlpower.architect.ddl.DDLUtils;
import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.architect.profile.ColumnValueCount;
import ca.sqlpower.architect.profile.ProfileChangeEvent;
import ca.sqlpower.architect.profile.ProfileChangeListener;
import ca.sqlpower.architect.profile.ProfileColumn;
import ca.sqlpower.architect.profile.ProfileManager;
import ca.sqlpower.architect.profile.ProfileResult;
import ca.sqlpower.architect.profile.TableProfileResult;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileTableModel
extends AbstractTableModel {
    static final int CPR_PSEUDO_COLUMN_INDEX = -1;
    static Logger logger = Logger.getLogger(ProfileTableModel.class);
    private ProfileManager profileManager;
    private List<ColumnProfileResult> resultList;
    private List<SQLObject> filters = new ArrayList<SQLObject>();

    public void removeAllFilters() {
        this.filters.clear();
    }

    public void removeFiltersByRegex(SQLObject sqo) {
        this.filters.remove(sqo);
    }

    public void addFilter(SQLObject sqo) {
        this.filters.add(sqo);
    }

    @Override
    public String getColumnName(int col) {
        return ProfileColumn.values()[col].getName();
    }

    @Override
    public int getRowCount() {
        return this.resultList.size();
    }

    @Override
    public int getColumnCount() {
        return ProfileColumn.values().length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ColumnProfileResult cpr = this.resultList.get(rowIndex);
        if (columnIndex == -1) {
            return cpr;
        }
        return ProfileTableModel.getColumnValueFromProfile(ProfileColumn.values()[columnIndex], cpr, this.profileManager);
    }

    private static Object getColumnValueFromProfile(ProfileColumn column, ColumnProfileResult columnProfile, ProfileManager profileManager) {
        SQLColumn col = (SQLColumn)columnProfile.getProfiledObject();
        int rowCount = ((TableProfileResult)profileManager.getResult(col.getParentTable())).getRowCount();
        switch (column) {
            case DATABASE: {
                return ArchitectUtils.getAncestor(col, SQLDatabase.class);
            }
            case CATALOG: {
                return ArchitectUtils.getAncestor(col, SQLCatalog.class);
            }
            case SCHEMA: {
                return ArchitectUtils.getAncestor(col, SQLSchema.class);
            }
            case TABLE: {
                return ArchitectUtils.getAncestor(col, SQLTable.class);
            }
            case COLUMN: {
                return col;
            }
            case RUNDATE: {
                return columnProfile.getCreateStartTime();
            }
            case RECORD_COUNT: {
                return rowCount;
            }
            case DATA_TYPE: {
                try {
                    DDLGenerator gddl = DDLUtils.createDDLGenerator(col.getParentTable().getParentDatabase().getDataSource());
                    return gddl.columnType(col);
                }
                catch (Exception e) {
                    throw new ArchitectRuntimeException(new ArchitectException("Unable to get DDL information.  Do we have a valid data source?", e));
                }
            }
            case NULL_COUNT: {
                return columnProfile.getNullCount();
            }
            case PERCENT_NULL: {
                return rowCount == 0 ? null : Double.valueOf((double)columnProfile.getNullCount() / (double)rowCount);
            }
            case UNIQUE_COUNT: {
                return columnProfile.getDistinctValueCount();
            }
            case PERCENT_UNIQUE: {
                return rowCount == 0 ? null : Double.valueOf((double)columnProfile.getDistinctValueCount() / (double)rowCount);
            }
            case MIN_LENGTH: {
                return columnProfile.getMinLength();
            }
            case MAX_LENGTH: {
                return columnProfile.getMaxLength();
            }
            case AVERAGE_LENGTH: {
                return columnProfile.getAvgLength();
            }
            case MIN_VALUE: {
                return columnProfile.getMinValue();
            }
            case MAX_VALUE: {
                return columnProfile.getMaxValue();
            }
            case AVERAGE_VALUE: {
                return columnProfile.getAvgValue();
            }
            case TOP_VALUE: {
                return columnProfile.getValueCount();
            }
        }
        throw new IllegalArgumentException(String.format("ProfileColumn enum value %s not handled", new Object[]{column}));
    }

    public List<ColumnValueCount> getTopNValueAt(int rowIndex) {
        return this.resultList.get(rowIndex).getValueCount();
    }

    public boolean isErrorColumnProfile(int row) {
        ColumnProfileResult columnProfile = this.resultList.get(row);
        return columnProfile.isError();
    }

    public ProfileManager getProfileManager() {
        return this.profileManager;
    }

    public void refresh() {
        this.resultList = new ArrayList<ColumnProfileResult>();
        for (ProfileResult pr : this.profileManager.getResults().values()) {
            if (!(pr instanceof ColumnProfileResult)) continue;
            if (this.filters.size() > 0) {
                if (!this.shouldNotBeFilteredOut((ColumnProfileResult)pr)) continue;
                this.resultList.add((ColumnProfileResult)pr);
                continue;
            }
            this.resultList.add((ColumnProfileResult)pr);
        }
        Collections.sort(this.resultList);
        this.fireTableDataChanged();
    }

    private boolean shouldNotBeFilteredOut(ColumnProfileResult result) {
        for (SQLObject sqo : this.filters) {
            ProfileColumn column;
            if (sqo instanceof SQLDatabase) {
                column = ProfileColumn.DATABASE;
            } else if (sqo instanceof SQLCatalog) {
                column = ProfileColumn.CATALOG;
            } else if (sqo instanceof SQLSchema) {
                column = ProfileColumn.SCHEMA;
            } else if (sqo instanceof SQLTable) {
                column = ProfileColumn.TABLE;
            } else {
                if (!(sqo instanceof SQLColumn)) continue;
                column = ProfileColumn.COLUMN;
            }
            if (!sqo.equals(ProfileTableModel.getColumnValueFromProfile(column, result, this.profileManager))) continue;
            return true;
        }
        return false;
    }

    public void setProfileManager(ProfileManager profileManager) {
        this.profileManager = profileManager;
        profileManager.addProfileChangeListener(new ProfileChangeListener(){

            public void profileRemoved(ProfileChangeEvent e) {
                ProfileTableModel.this.refresh();
            }

            public void profileAdded(ProfileChangeEvent e) {
                ProfileTableModel.this.refresh();
            }
        });
        this.refresh();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        ProfileColumn pc = ProfileColumn.values()[columnIndex];
        switch (pc) {
            case DATABASE: {
                return SQLDatabase.class;
            }
            case CATALOG: {
                return SQLCatalog.class;
            }
            case SCHEMA: {
                return SQLSchema.class;
            }
            case TABLE: {
                return SQLTable.class;
            }
            case COLUMN: {
                return SQLColumn.class;
            }
            case RUNDATE: {
                return Long.class;
            }
            case RECORD_COUNT: {
                return Integer.class;
            }
            case DATA_TYPE: {
                return String.class;
            }
            case NULL_COUNT: {
                return Integer.class;
            }
            case PERCENT_NULL: {
                return BigDecimal.class;
            }
            case UNIQUE_COUNT: {
                return Integer.class;
            }
            case PERCENT_UNIQUE: {
                return BigDecimal.class;
            }
            case MIN_LENGTH: {
                return Integer.class;
            }
            case MAX_LENGTH: {
                return Integer.class;
            }
            case AVERAGE_LENGTH: {
                return BigDecimal.class;
            }
            case MIN_VALUE: {
                return Object.class;
            }
            case MAX_VALUE: {
                return Object.class;
            }
            case AVERAGE_VALUE: {
                return Object.class;
            }
            case TOP_VALUE: {
                return Object.class;
            }
        }
        throw new IllegalArgumentException(String.format("ProfileColumn value %s unknown", new Object[]{pc}));
    }

    public List<ColumnProfileResult> getResultList() {
        return this.resultList;
    }
}

