/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.DBTree;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.Selectable;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.architect.swingui.event.SelectionEvent;
import ca.sqlpower.architect.swingui.event.SelectionListener;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class InsertColumnAction
extends AbstractAction
implements SelectionListener {
    private static final Logger logger = Logger.getLogger(InsertColumnAction.class);
    protected PlayPen pp;
    protected DBTree dbt;

    public InsertColumnAction() {
        super("New Column", ASUtils.createIcon("NewColumn", "New Column", ArchitectFrame.getMainInstance().getSprefs().getInt("SwingUserSettings.ICON_SIZE", 24)));
        this.putValue("ShortDescription", "New Column");
        this.putValue("ActionCommandKey", "PlayPen");
        this.setEnabled(false);
    }

    public void actionPerformed(ActionEvent evt) {
        block18: {
            try {
                if (evt.getActionCommand().equals("PlayPen")) {
                    List<PlayPenComponent> selection = this.pp.getSelectedItems();
                    if (selection.size() < 1) {
                        JOptionPane.showMessageDialog(this.pp, "Select a table (by clicking on it) and try again.");
                        break block18;
                    }
                    if (selection.size() > 1) {
                        JOptionPane.showMessageDialog(this.pp, "You have selected multiple items, but you can only edit one at a time.");
                        break block18;
                    }
                    if (selection.get(0) instanceof TablePane) {
                        TablePane tp = (TablePane)selection.get(0);
                        int idx = tp.getSelectedColumnIndex();
                        try {
                            if (idx < 0) {
                                idx = tp.getModel().getColumnsFolder().getChildCount();
                            }
                        }
                        catch (ArchitectException e) {
                            idx = 0;
                        }
                        tp.getModel().addColumn(idx, new SQLColumn());
                        break block18;
                    }
                    JOptionPane.showMessageDialog(this.pp, "The selected item type is not recognised");
                    break block18;
                }
                if (evt.getActionCommand().equals("DBTree")) {
                    TreePath[] selections = this.dbt.getSelectionPaths();
                    if (selections == null || selections.length != 1) {
                        JOptionPane.showMessageDialog(this.dbt, "To indicate where you would like to insert a column, please select a single item.");
                        break block18;
                    }
                    TreePath tp = selections[0];
                    SQLObject so = (SQLObject)tp.getLastPathComponent();
                    SQLTable st = null;
                    int idx = 0;
                    if (so instanceof SQLTable) {
                        logger.debug((Object)"user clicked on table, so we shall try to add a column to the end of the table.");
                        try {
                            st = (SQLTable)so;
                            idx = st.getColumnsFolder().getChildCount();
                        }
                        catch (ArchitectException ex) {
                            idx = 0;
                        }
                        logger.debug((Object)("SQLTable click -- idx set to: " + idx));
                    } else if (so instanceof SQLColumn) {
                        logger.debug((Object)"trying to determine insertion index for table.");
                        SQLColumn sc = (SQLColumn)so;
                        st = sc.getParentTable();
                        idx = st.getColumnIndex(sc);
                        if (idx == -1) {
                            logger.debug((Object)"did not find column, inserting at start of table.");
                            idx = 0;
                        }
                    } else {
                        idx = 0;
                    }
                    st.addColumn(idx, new SQLColumn());
                    break block18;
                }
                JOptionPane.showMessageDialog(null, "InsertColumnAction: Unknown Action Command \"" + evt.getActionCommand() + "\"", "Internal Architect Error", 0);
            }
            catch (ArchitectException ex) {
                JOptionPane.showMessageDialog(null, "Column could not be inserted:\n" + ex.getMessage() + "\n\nThere is more detail in the application log.", "Architect Error", 0);
            }
        }
    }

    public void setPlayPen(PlayPen pp) {
        if (this.pp != null) {
            this.pp.removeSelectionListener(this);
        }
        this.pp = pp;
        pp.addSelectionListener(this);
        this.setupAction(pp.getSelectedItems());
    }

    public void setDBTree(DBTree newDBT) {
        this.dbt = newDBT;
    }

    public void setupAction(List selectedItems) {
        if (selectedItems.size() == 0) {
            this.setEnabled(false);
            logger.debug((Object)"Disabling Insert Column Action");
            this.putValue("ShortDescription", "Insert Column");
        } else {
            Selectable item = (Selectable)selectedItems.get(0);
            if (item instanceof TablePane) {
                this.setEnabled(true);
            }
        }
    }

    public void itemSelected(SelectionEvent e) {
        this.setupAction(this.pp.getSelectedItems());
    }

    public void itemDeselected(SelectionEvent e) {
        this.setupAction(this.pp.getSelectedItems());
    }
}

