/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLObjectEvent;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.TablePane;
import java.awt.Color;
import java.util.ArrayList;
import junit.framework.TestCase;

public class TestTablePane
extends TestCase {
    private SQLTable t;
    private TablePane tp;
    private PlayPen pp;

    protected void setUp() throws Exception {
        super.setUp();
        this.t = new SQLTable(ArchitectFrame.getMainInstance().getProject().getTargetDatabase(), true);
        this.t.setName("Test Table");
        SQLColumn pk1 = new SQLColumn(this.t, "PKColumn1", 4, 10, 0);
        SQLColumn pk2 = new SQLColumn(this.t, "PKColumn2", 4, 10, 0);
        SQLColumn pk3 = new SQLColumn(this.t, "PKColumn3", 4, 10, 0);
        SQLColumn at1 = new SQLColumn(this.t, "AT1", 4, 10, 0);
        SQLColumn at2 = new SQLColumn(this.t, "AT2", 4, 10, 0);
        SQLColumn at3 = new SQLColumn(this.t, "AT3", 4, 10, 0);
        this.t.addColumn(0, pk1);
        this.t.addColumn(1, pk2);
        this.t.addColumn(2, pk3);
        this.t.addColumn(3, at1);
        this.t.addColumn(4, at2);
        this.t.addColumn(5, at3);
        this.pp = ArchitectFrame.getMainInstance().getProject().getPlayPen();
        this.tp = new TablePane(this.t, this.pp);
        pk1.setPrimaryKeySeq(1);
        pk2.setPrimaryKeySeq(2);
        pk3.setPrimaryKeySeq(3);
        TestTablePane.assertEquals((int)3, (int)this.t.getPkSize());
    }

    public void testInsertColumnAtTop() throws ArchitectException {
        SQLTable t2 = new SQLTable(this.t.getParentDatabase(), true);
        t2.setName("Another Test Table");
        SQLColumn newcol = new SQLColumn(t2, "newcol", 4, 10, 0);
        ArrayList<SQLObject> newcolList = new ArrayList<SQLObject>();
        newcolList.add(newcol);
        this.tp.insertObjects(newcolList, 0);
        TestTablePane.assertEquals((int)7, (int)this.t.getColumns().size());
        TestTablePane.assertEquals((int)4, (int)this.t.getPkSize());
    }

    public void testInsertColumnAtStartOfNonPK() throws ArchitectException {
        SQLColumn newcol = new SQLColumn(this.t, "newcol", 4, 10, 0);
        this.t.addColumn(0, newcol);
        TestTablePane.assertNotNull((String)"Column should start in primary key", (Object)newcol.getPrimaryKeySeq());
        ArrayList<SQLObject> movecolList = new ArrayList<SQLObject>();
        movecolList.add(newcol);
        this.tp.insertObjects(movecolList, -4);
        TestTablePane.assertEquals((int)3, (int)this.t.getColumnIndex(newcol));
        TestTablePane.assertNull((String)"Column should have moved out of primary key", (Object)newcol.getPrimaryKeySeq());
    }

    public void testInsertColumnAboveFirstNonPKColumn() throws ArchitectException {
        SQLColumn newcol = new SQLColumn(this.t, "newcol", 4, 10, 0);
        this.t.addColumn(0, newcol);
        TestTablePane.assertNotNull((String)"Column should start in primary key", (Object)newcol.getPrimaryKeySeq());
        ArrayList<SQLObject> movecolList = new ArrayList<SQLObject>();
        movecolList.add(newcol);
        this.tp.insertObjects(movecolList, 4);
        TestTablePane.assertEquals((int)3, (int)this.t.getColumnIndex(newcol));
        TestTablePane.assertNull((String)"Column should have moved out of primary key", (Object)newcol.getPrimaryKeySeq());
    }

    public void testInsertNewColumnAboveFirstNonPKColumn() throws ArchitectException {
        SQLTable t2 = new SQLTable(this.t.getParentDatabase(), true);
        t2.setName("Another Test Table");
        SQLColumn newcol = new SQLColumn(t2, "newcol", 4, 10, 0);
        t2.addColumn(0, newcol);
        newcol.setPrimaryKeySeq(1);
        TestTablePane.assertNotNull((String)"Column should start in primary key", (Object)newcol.getPrimaryKeySeq());
        ArrayList<SQLObject> movecolList = new ArrayList<SQLObject>();
        movecolList.add(newcol);
        this.tp.insertObjects(movecolList, 3);
        TestTablePane.assertEquals((int)3, (int)this.t.getColumnIndex(newcol));
        TestTablePane.assertNull((String)"Column should not be in primary key", (Object)newcol.getPrimaryKeySeq());
    }

    public void testInsertNewColumnAtEndOfPK() throws ArchitectException {
        SQLTable t2 = new SQLTable(this.t.getParentDatabase(), true);
        t2.setName("Another Test Table");
        SQLColumn newcol = new SQLColumn(t2, "newcol", 4, 10, 0);
        t2.addColumn(0, newcol);
        newcol.setPrimaryKeySeq(1);
        TestTablePane.assertNotNull((String)"Column should start in primary key", (Object)newcol.getPrimaryKeySeq());
        ArrayList<SQLObject> movecolList = new ArrayList<SQLObject>();
        movecolList.add(newcol);
        this.tp.insertObjects(movecolList, -3);
        TestTablePane.assertEquals((int)3, (int)this.t.getColumnIndex(newcol));
        TestTablePane.assertNotNull((String)"Column should be in primary key", (Object)newcol.getPrimaryKeySeq());
    }

    public void testDisallowImportTableFromPlaypen() throws ArchitectException {
        SQLTable t2 = new SQLTable(this.t.getParentDatabase(), true);
        t2.setName("Another Test Table");
        ArrayList<SQLObject> tableList = new ArrayList<SQLObject>();
        tableList.add(t2);
        TestTablePane.assertFalse((String)"Inserting a table from the playpen is not allowed", (boolean)this.tp.insertObjects(tableList, 0));
    }

    public void testListenerDoesntCleanUpEarly() throws ArchitectException {
        private class MySQLTable
        extends SQLTable {
            public MySQLTable(String name) throws ArchitectException {
                super(ArchitectFrame.getMainInstance().getProject().getTargetDatabase(), true);
                this.setName(name);
                this.children.set(0, new 1MySQLTable.MyFolder());
                this.columnsFolder = (SQLTable.Folder)this.children.get(0);
            }

            public void removeLastColumnNoEvent() {
                ((1MySQLTable.MyFolder)this.getColumnsFolder()).removeLastChildNoEvent();
            }

            class 1MySQLTable.MyFolder
            extends SQLTable.Folder {
                1MySQLTable.MyFolder() {
                    super(1, true);
                }

                public void removeLastChildNoEvent() {
                    this.children.remove(this.children.size() - 1);
                }
            }
        }
        MySQLTable t = new MySQLTable("table");
        SQLColumn c1 = new SQLColumn(t, "PK1", -7, 1, 0);
        t.addColumn(0, c1);
        TablePane tp = new TablePane(t, this.pp);
        TestTablePane.assertEquals((int)1, (int)t.getColumns().size());
        t.removeLastColumnNoEvent();
        TestTablePane.assertEquals((int)0, (int)t.getColumns().size());
        SQLColumn fakeSource = new SQLColumn();
        tp.columnListener.dbChildrenRemoved(new SQLObjectEvent(fakeSource, new int[]{6}, new SQLObject[]{fakeSource}));
        tp.columnListener.dbChildrenRemoved(new SQLObjectEvent(t.getColumnsFolder(), new int[1], new SQLObject[]{c1}));
    }

    public void testMultiHighlight() throws ArchitectException {
        SQLColumn col = this.tp.getModel().getColumn(0);
        this.tp.addColumnHighlight(col, Color.RED);
        this.tp.addColumnHighlight(col, Color.GREEN);
        TestTablePane.assertEquals((Object)new Color(128, 128, 0), (Object)this.tp.getColumnHighlight(col));
        this.tp.removeColumnHighlight(col, Color.RED);
        TestTablePane.assertEquals((Object)Color.GREEN, (Object)this.tp.getColumnHighlight(col));
        this.tp.removeColumnHighlight(col, Color.GREEN);
        TestTablePane.assertEquals((Object)this.tp.getForeground(), (Object)this.tp.getColumnHighlight(col));
    }
}

