/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectDataSource;
import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.DataSourceCollection;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.CompareDMPanel;
import ca.sqlpower.architect.swingui.SwingUIProject;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Robot;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.JFCTestHelper;
import junit.extensions.jfcunit.TestHelper;

public class TestCompareDMPanel
extends JFCTestCase {
    CompareDMPanel panel;
    Robot robot;
    JRadioButton sourcePlayPenRadio = null;
    JRadioButton sourcePhysicalRadio = null;
    JComboBox sourceDatabaseDropdown = null;
    JComboBox sourceCatalogDropdown = null;
    JComboBox sourceSchemaDropdown = null;
    JButton sourceNewConnButton = null;
    JRadioButton sourceLoadRadio = null;
    JTextField sourceLoadFilePath = null;
    JButton sourceLoadFileButton = null;
    JRadioButton targetPlayPenRadio = null;
    JRadioButton targetPhysicalRadio = null;
    JComboBox targetDatabaseDropdown = null;
    JComboBox targetCatalogDropdown = null;
    JComboBox targetSchemaDropdown = null;
    JButton targetNewConnButton = null;
    JRadioButton targetLoadRadio = null;
    JTextField targetLoadFilePath = null;
    JButton targetLoadFileButton = null;
    DataSourceCollection plDotIni = ArchitectFrame.getMainInstance().getUserSettings().getPlDotIni();

    protected void setUp() throws Exception {
        super.setUp();
        this.setHelper((TestHelper)new JFCTestHelper());
        this.panel = new CompareDMPanel(new SwingUIProject("test"));
        this.robot = new Robot();
        Component[] comps = ((Container)this.panel.getComponent(0)).getComponents();
        int i = 0;
        while (i < comps.length) {
            if ("sourcePlayPenRadio".equals(comps[i].getName())) {
                this.sourcePlayPenRadio = (JRadioButton)comps[i];
            } else if ("sourcePhysicalRadio".equals(comps[i].getName())) {
                this.sourcePhysicalRadio = (JRadioButton)comps[i];
            } else if ("sourceDatabaseDropdown".equals(comps[i].getName())) {
                this.sourceDatabaseDropdown = (JComboBox)comps[i];
            } else if ("sourceCatalogDropdown".equals(comps[i].getName())) {
                this.sourceCatalogDropdown = (JComboBox)comps[i];
            } else if ("sourceSchemaDropdown".equals(comps[i].getName())) {
                this.sourceSchemaDropdown = (JComboBox)comps[i];
            } else if ("sourceNewConnButton".equals(comps[i].getName())) {
                this.sourceNewConnButton = (JButton)comps[i];
            } else if ("sourceLoadRadio".equals(comps[i].getName())) {
                this.sourceLoadRadio = (JRadioButton)comps[i];
            } else if ("sourceLoadFilePath".equals(comps[i].getName())) {
                this.sourceLoadFilePath = (JTextField)comps[i];
            } else if ("sourceLoadFileButton".equals(comps[i].getName())) {
                this.sourceLoadFileButton = (JButton)comps[i];
            } else if ("targetPlayPenRadio".equals(comps[i].getName())) {
                this.targetPlayPenRadio = (JRadioButton)comps[i];
            } else if ("targetPhysicalRadio".equals(comps[i].getName())) {
                this.targetPhysicalRadio = (JRadioButton)comps[i];
            } else if ("targetDatabaseDropdown".equals(comps[i].getName())) {
                this.targetDatabaseDropdown = (JComboBox)comps[i];
            } else if ("targetCatalogDropdown".equals(comps[i].getName())) {
                this.targetCatalogDropdown = (JComboBox)comps[i];
            } else if ("targetSchemaDropdown".equals(comps[i].getName())) {
                this.targetSchemaDropdown = (JComboBox)comps[i];
            } else if ("targetNewConnButton".equals(comps[i].getName())) {
                this.targetNewConnButton = (JButton)comps[i];
            } else if ("targetLoadRadio".equals(comps[i].getName())) {
                this.targetLoadRadio = (JRadioButton)comps[i];
            } else if ("targetLoadFilePath".equals(comps[i].getName())) {
                this.targetLoadFilePath = (JTextField)comps[i];
            } else if ("targetLoadFileButton".equals(comps[i].getName())) {
                this.targetLoadFileButton = (JButton)comps[i];
            }
            ++i;
        }
    }

    protected void tearDown() throws Exception {
        TestHelper.cleanUp((JFCTestCase)this);
        super.tearDown();
    }

    public void testInitComponents() {
        TestCompareDMPanel.assertNotNull((String)"Missing component", (Object)this.sourcePlayPenRadio);
        TestCompareDMPanel.assertNotNull((String)"Missing component", (Object)this.sourcePhysicalRadio);
        TestCompareDMPanel.assertNotNull((String)"Missing component", (Object)this.sourceDatabaseDropdown);
        TestCompareDMPanel.assertNotNull((String)"Missing component", (Object)this.sourceCatalogDropdown);
        TestCompareDMPanel.assertNotNull((String)"Missing component", (Object)this.sourceSchemaDropdown);
        TestCompareDMPanel.assertNotNull((String)"Missing component", (Object)this.sourceNewConnButton);
        TestCompareDMPanel.assertNotNull((String)"Missing component", (Object)this.sourceLoadRadio);
        TestCompareDMPanel.assertNotNull((String)"Missing component", (Object)this.sourceLoadFilePath);
        TestCompareDMPanel.assertNotNull((String)"Missing component", (Object)this.sourceLoadFileButton);
        TestCompareDMPanel.assertNotNull((String)"Missing component", (Object)this.targetPlayPenRadio);
        TestCompareDMPanel.assertNotNull((String)"Missing component", (Object)this.targetPhysicalRadio);
        TestCompareDMPanel.assertNotNull((String)"Missing component", (Object)this.targetDatabaseDropdown);
        TestCompareDMPanel.assertNotNull((String)"Missing component", (Object)this.targetCatalogDropdown);
        TestCompareDMPanel.assertNotNull((String)"Missing component", (Object)this.targetSchemaDropdown);
        TestCompareDMPanel.assertNotNull((String)"Missing component", (Object)this.targetNewConnButton);
        TestCompareDMPanel.assertNotNull((String)"Missing component", (Object)this.targetLoadRadio);
        TestCompareDMPanel.assertNotNull((String)"Missing component", (Object)this.targetLoadFilePath);
        TestCompareDMPanel.assertNotNull((String)"Missing component", (Object)this.targetLoadFileButton);
    }

    public void testEnableSourceDatabaseComponents() throws Exception {
        JFrame frame = new JFrame();
        frame.setContentPane(this.panel);
        frame.pack();
        frame.setVisible(true);
        TestCompareDMPanel.assertFalse((boolean)this.sourceDatabaseDropdown.isEnabled());
        TestCompareDMPanel.assertFalse((boolean)this.sourceNewConnButton.isEnabled());
        TestCompareDMPanel.assertFalse((boolean)this.sourceCatalogDropdown.isEnabled());
        TestCompareDMPanel.assertFalse((boolean)this.sourceSchemaDropdown.isEnabled());
        this.flushAWT();
        Point p = this.sourcePhysicalRadio.getLocationOnScreen();
        this.robot.mouseMove(p.x, p.y);
        this.robot.mousePress(16);
        this.robot.mouseRelease(16);
        this.flushAWT();
        TestCompareDMPanel.assertTrue((boolean)this.sourceDatabaseDropdown.isEnabled());
        TestCompareDMPanel.assertTrue((boolean)this.sourceNewConnButton.isEnabled());
        TestCompareDMPanel.assertFalse((boolean)this.sourceCatalogDropdown.isEnabled());
        TestCompareDMPanel.assertFalse((boolean)this.sourceSchemaDropdown.isEnabled());
        frame.dispose();
    }

    public void testDisableSourceDatabaseComponents() {
        JFrame frame = new JFrame();
        frame.setContentPane(this.panel);
        frame.pack();
        frame.setVisible(true);
        TestCompareDMPanel.assertFalse((boolean)this.sourceDatabaseDropdown.isEnabled());
        TestCompareDMPanel.assertFalse((boolean)this.sourceNewConnButton.isEnabled());
        TestCompareDMPanel.assertFalse((boolean)this.sourceCatalogDropdown.isEnabled());
        TestCompareDMPanel.assertFalse((boolean)this.sourceSchemaDropdown.isEnabled());
        TestCompareDMPanel.assertFalse((boolean)this.sourceLoadFilePath.isEnabled());
        TestCompareDMPanel.assertFalse((boolean)this.sourceLoadFileButton.isEnabled());
        this.flushAWT();
        Point p = this.sourcePhysicalRadio.getLocationOnScreen();
        this.robot.mouseMove(p.x, p.y);
        this.robot.mousePress(16);
        this.robot.mouseRelease(16);
        this.flushAWT();
        TestCompareDMPanel.assertTrue((boolean)this.sourceDatabaseDropdown.isEnabled());
        TestCompareDMPanel.assertTrue((boolean)this.sourceNewConnButton.isEnabled());
        TestCompareDMPanel.assertFalse((boolean)this.sourceCatalogDropdown.isEnabled());
        TestCompareDMPanel.assertFalse((boolean)this.sourceSchemaDropdown.isEnabled());
        p = this.sourcePlayPenRadio.getLocationOnScreen();
        this.robot.mouseMove(p.x, p.y);
        this.robot.mousePress(16);
        this.robot.mouseRelease(16);
        this.flushAWT();
        TestCompareDMPanel.assertFalse((boolean)this.sourceDatabaseDropdown.isEnabled());
        TestCompareDMPanel.assertFalse((boolean)this.sourceNewConnButton.isEnabled());
        TestCompareDMPanel.assertFalse((boolean)this.sourceCatalogDropdown.isEnabled());
        TestCompareDMPanel.assertFalse((boolean)this.sourceSchemaDropdown.isEnabled());
        frame.dispose();
    }

    public void testNewSourceConnectionButton() throws Exception {
        JFrame frame = new JFrame();
        frame.setContentPane(this.panel);
        frame.pack();
        frame.setVisible(true);
        Point p = this.sourcePhysicalRadio.getLocationOnScreen();
        this.robot.mouseMove(p.x + 2, p.y + 2);
        this.robot.mousePress(16);
        this.robot.mouseRelease(16);
        p = this.sourceNewConnButton.getLocationOnScreen();
        this.robot.mouseMove(p.x + 2, p.y + 2);
        this.robot.mousePress(16);
        this.robot.mouseRelease(16);
        this.flushAWT();
        JDialog d = this.panel.getSourceStuff().getNewConnectionDialog();
        TestCompareDMPanel.assertNotNull((String)"New source connection button didn't create dialog", (Object)d);
        TestCompareDMPanel.assertTrue((String)"Dialog isn't visible!", (boolean)d.isVisible());
        frame.dispose();
    }

    public void testNewTargetConnectionButton() throws Exception {
        JFrame frame = new JFrame();
        frame.setContentPane(this.panel);
        frame.pack();
        frame.setVisible(true);
        Point p = this.targetNewConnButton.getLocationOnScreen();
        this.robot.mouseMove(p.x + 2, p.y + 2);
        this.robot.mousePress(16);
        this.robot.mouseRelease(16);
        this.flushAWT();
        JDialog d = this.panel.getTargetStuff().getNewConnectionDialog();
        TestCompareDMPanel.assertNotNull((String)"New target connection button didn't create dialog", (Object)d);
        TestCompareDMPanel.assertTrue((String)"Dialog isn't visible!", (boolean)d.isVisible());
        frame.dispose();
    }

    public void testSourceDropDownsWithOnlyCatalog() {
        ArchitectDataSource ds = new ArchitectDataSource();
        ds.setDisplayName("testSourceDropDownsWithOnlyCatalog");
        ds.setDriverClass("ca.sqlpower.architect.MockJDBCDriver");
        ds.setUser("fake");
        ds.setPass("fake");
        ds.setUrl("jdbc:mock:dbmd.catalogTerm=Catalog&catalogs=cat1,cat2,cat3&tables.cat1=tab1&tables.cat2=tab2&tables.cat3=tab3");
        this.sourcePhysicalRadio.setSelected(true);
        if (this.plDotIni.getDataSource(ds.getName()) != null) {
            this.plDotIni.removeDataSource(ds);
        }
        this.plDotIni.addDataSource(ds);
        this.sourceDatabaseDropdown.setSelectedItem(ds);
        this.flushAWT();
        TestCompareDMPanel.assertFalse((boolean)this.sourceSchemaDropdown.isEnabled());
        TestCompareDMPanel.assertTrue((boolean)this.sourceCatalogDropdown.isEnabled());
    }

    public void testSourceDropDownsWithSchemaAndCatalog() {
        ArchitectDataSource ds = new ArchitectDataSource();
        ds.setDisplayName("testSourceDropDownsWithSchemaAndCatalog");
        ds.setDriverClass("ca.sqlpower.architect.MockJDBCDriver");
        ds.setUser("fake");
        ds.setPass("fake");
        ds.setUrl("jdbc:mock:dbmd.catalogTerm=Catalog&dbmd.schemaTerm=Schema&catalogs=cow_catalog&schemas.cow_catalog=moo_schema,quack_schema&tables.cow_catalog.moo_schema=braaaap,pffft&tables.cow_catalog.quack_schema=duck,goose");
        this.sourcePhysicalRadio.setSelected(true);
        if (this.plDotIni.getDataSource(ds.getName()) != null) {
            this.plDotIni.removeDataSource(ds);
        }
        this.plDotIni.addDataSource(ds);
        this.sourceDatabaseDropdown.setSelectedItem(ds);
        this.flushAWT();
        TestCompareDMPanel.assertTrue((boolean)this.sourceCatalogDropdown.isEnabled());
        TestCompareDMPanel.assertTrue((boolean)this.sourceSchemaDropdown.isEnabled());
    }

    public void testSourceDropDownsWithOnlySchema() {
        ArchitectDataSource ds = new ArchitectDataSource();
        ds.setDisplayName("testSourceDropDownsWithOnlySchema");
        ds.setDriverClass("ca.sqlpower.architect.MockJDBCDriver");
        ds.setUser("fake");
        ds.setPass("fake");
        ds.setUrl("jdbc:mock:dbmd.schemaTerm=Schema&schemas=scheme1,scheme2,scheme3");
        this.sourcePhysicalRadio.setSelected(true);
        if (this.plDotIni.getDataSource(ds.getName()) != null) {
            this.plDotIni.removeDataSource(ds);
        }
        this.plDotIni.addDataSource(ds);
        this.sourceDatabaseDropdown.setSelectedItem(ds);
        this.flushAWT();
        TestCompareDMPanel.assertTrue((boolean)this.sourceSchemaDropdown.isEnabled());
        TestCompareDMPanel.assertFalse((boolean)this.sourceCatalogDropdown.isEnabled());
    }

    public void testTargetDropDownsWithOnlyCatalog() {
        ArchitectDataSource ds = new ArchitectDataSource();
        ds.setDisplayName("testTargetDropDownsWithOnlyCatalog");
        ds.setDriverClass("ca.sqlpower.architect.MockJDBCDriver");
        ds.setUser("fake");
        ds.setPass("fake");
        ds.setUrl("jdbc:mock:dbmd.catalogTerm=Catalog&catalogs=cat1,cat2,cat3&tables.cat1=tab1&tables.cat2=tab2&tables.cat3=tab3");
        if (this.plDotIni.getDataSource(ds.getName()) != null) {
            this.plDotIni.removeDataSource(ds);
        }
        this.plDotIni.addDataSource(ds);
        this.targetDatabaseDropdown.setSelectedItem(ds);
        this.flushAWT();
        TestCompareDMPanel.assertFalse((boolean)this.targetSchemaDropdown.isEnabled());
        TestCompareDMPanel.assertTrue((boolean)this.targetCatalogDropdown.isEnabled());
    }

    public void testTargetDropDownsWithSchemaAndCatalog() {
        ArchitectDataSource ds = new ArchitectDataSource();
        ds.setDisplayName("testTargetDropDownsWithSchemaAndCatalog");
        ds.setDriverClass("ca.sqlpower.architect.MockJDBCDriver");
        ds.setUser("fake");
        ds.setPass("fake");
        ds.setUrl("jdbc:mock:dbmd.catalogTerm=Catalog&dbmd.schemaTerm=Schema&catalogs=cow_catalog&schemas.cow_catalog=moo_schema,quack_schema&tables.cow_catalog.moo_schema=braaaap,pffft&tables.cow_catalog.quack_schema=duck,goose");
        if (this.plDotIni.getDataSource(ds.getName()) != null) {
            this.plDotIni.removeDataSource(ds);
        }
        this.plDotIni.addDataSource(ds);
        this.targetDatabaseDropdown.setSelectedItem(ds);
        this.flushAWT();
        TestCompareDMPanel.assertTrue((boolean)this.targetSchemaDropdown.isEnabled());
        TestCompareDMPanel.assertTrue((boolean)this.targetCatalogDropdown.isEnabled());
        this.targetDatabaseDropdown.setSelectedItem(ds);
        this.flushAWT();
        TestCompareDMPanel.assertTrue((boolean)this.targetSchemaDropdown.isEnabled());
        TestCompareDMPanel.assertTrue((boolean)this.targetCatalogDropdown.isEnabled());
    }

    public void testTargetDropDownsWithOnlySchema() {
        ArchitectDataSource ds = new ArchitectDataSource();
        ds.setDisplayName("testTargetDropDownsWithOnlySchema");
        ds.setDriverClass("ca.sqlpower.architect.MockJDBCDriver");
        ds.setUser("fake");
        ds.setPass("fake");
        ds.setUrl("jdbc:mock:dbmd.schemaTerm=Schema&schemas=scheme1,scheme2,scheme3");
        if (this.plDotIni.getDataSource(ds.getName()) != null) {
            this.plDotIni.removeDataSource(ds);
        }
        this.plDotIni.addDataSource(ds);
        this.targetDatabaseDropdown.setSelectedItem(ds);
        this.flushAWT();
        TestCompareDMPanel.assertTrue((boolean)this.targetSchemaDropdown.isEnabled());
        TestCompareDMPanel.assertFalse((boolean)this.targetCatalogDropdown.isEnabled());
    }

    public void testTargetSchemaUpdateByCatalogChange() {
        ArchitectDataSource ds = new ArchitectDataSource();
        ds.setDisplayName("testTargetSchemaUpdateByCatalogChange");
        ds.setDriverClass("ca.sqlpower.architect.MockJDBCDriver");
        ds.setUser("fake");
        ds.setPass("fake");
        ds.setUrl("jdbc:mock:dbmd.catalogTerm=Catalog&dbmd.schemaTerm=Schema&catalogs=farm,zoo,backyard&schemas.farm=birds,mammals&tables.farm.birds=chicken,turkey,hen&tables.farm.mammals=cow,horse,buffalo?&schemas.zoo=birds2,mammals2&tables.zoo.birds2=penguin,flamingo&tables.zoo.mammals2=elephant&schemas.backyard=mammals3&tables.backyard.mammals3=mouse,rat,cat,dog,raccoon");
        if (this.plDotIni.getDataSource(ds.getName()) != null) {
            this.plDotIni.removeDataSource(ds);
        }
        this.plDotIni.addDataSource(ds);
        this.targetDatabaseDropdown.setSelectedItem(ds);
        this.flushAWT();
        TestCompareDMPanel.assertTrue((boolean)this.targetCatalogDropdown.isEnabled());
        TestCompareDMPanel.assertTrue((boolean)this.targetSchemaDropdown.isEnabled());
        this.flushAWT();
        SQLObject temp = (SQLObject)this.targetCatalogDropdown.getSelectedItem();
        try {
            TestCompareDMPanel.assertTrue((boolean)"birds".equals(temp.getChild(0).getPhysicalName()));
        }
        catch (ArchitectException e) {
            System.out.println("We did not get a schema from the catalog!");
        }
        this.flushAWT();
        this.targetCatalogDropdown.setSelectedIndex(1);
        temp = (SQLObject)this.targetCatalogDropdown.getSelectedItem();
        try {
            TestCompareDMPanel.assertTrue((boolean)"birds2".equals(temp.getChild(0).getPhysicalName()));
        }
        catch (ArchitectException e) {
            System.out.println("We did not get a schema from the catalog!");
        }
    }
}

