/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.SQLColumn;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.ddl.GenericTypeDescriptor;
import ca.sqlpower.architect.swingui.CompareSchemaWorker;
import ca.sqlpower.architect.swingui.SQLObjectCompare;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import junit.framework.TestCase;

public class CompareSchemaWorkerTest
extends TestCase {
    CompareSchemaWorker csw;
    DefaultStyledDocument r;
    DefaultStyledDocument l;
    TreeSet<SQLTable> rTableContainer;
    SQLTable r1;
    SQLTable r2;
    TreeSet<SQLTable> lTableContainer;
    SQLTable l1;
    SQLTable l2;
    private Map<Integer, GenericTypeDescriptor> typeMap;

    protected void setUp() throws Exception {
        super.setUp();
        this.rTableContainer = new TreeSet(new SQLObjectCompare());
        this.r1 = new SQLTable(null, "a", "actually r1", SQLTable.class.toString(), true);
        this.r2 = new SQLTable(null, "b", "actually r2", SQLTable.class.toString(), true);
        this.rTableContainer.add(this.r1);
        this.rTableContainer.add(this.r2);
        this.lTableContainer = new TreeSet(new SQLObjectCompare());
        this.l1 = new SQLTable(null, "c", "actually l1", SQLTable.class.toString(), true);
        this.l2 = new SQLTable(null, "b", "actually l2", SQLTable.class.toString(), true);
        this.lTableContainer.add(this.l1);
        this.lTableContainer.add(this.l2);
        this.typeMap = new HashMap<Integer, GenericTypeDescriptor>();
        this.typeMap.put(new Integer(0), new GenericTypeDescriptor("MockInteger", 0, 1L, "prefix", "suffix", 0, false, false));
        this.typeMap.put(new Integer(1), new GenericTypeDescriptor("Precision", 1, 1L, "prefix", "suffix", 0, true, false));
        this.r = new DefaultStyledDocument();
        this.l = new DefaultStyledDocument();
        this.csw = new CompareSchemaWorker(this.rTableContainer, this.lTableContainer, (AbstractDocument)this.r, this.l, this.typeMap, this.typeMap);
        this.csw.run();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetJobSize() {
        CompareSchemaWorkerTest.assertEquals((int)4, (int)this.csw.getJobSize());
    }

    public void testGetProgress() {
    }

    public void testGenerateDiffWithNoColunmns() throws BadLocationException {
        DefaultStyledDocument rDoc = new DefaultStyledDocument();
        DefaultStyledDocument lDoc = new DefaultStyledDocument();
        TreeSet<SQLTable> ltree = new TreeSet<SQLTable>(new SQLObjectCompare());
        TreeSet<SQLTable> rtree = new TreeSet<SQLTable>(new SQLObjectCompare());
        CompareSchemaWorker emptyWorker = new CompareSchemaWorker(ltree, rtree, (AbstractDocument)lDoc, rDoc, this.typeMap, this.typeMap);
        emptyWorker.run();
        CompareSchemaWorkerTest.assertEquals((int)0, (int)rDoc.getLength());
        CompareSchemaWorkerTest.assertEquals((int)0, (int)lDoc.getLength());
        CompareSchemaWorker worker1 = new CompareSchemaWorker(ltree, this.rTableContainer, (AbstractDocument)lDoc, rDoc, this.typeMap, this.typeMap);
        worker1.run();
        CompareSchemaWorkerTest.assertEquals((String)"Missing table: a\nMissing table: b\n", (String)lDoc.getText(0, lDoc.getLength()));
        CompareSchemaWorkerTest.assertEquals((String)"Extra table: a\nExtra table: b\n", (String)rDoc.getText(0, rDoc.getLength()));
        DefaultStyledDocument rDoc2 = new DefaultStyledDocument();
        DefaultStyledDocument lDoc2 = new DefaultStyledDocument();
        CompareSchemaWorker worker2 = new CompareSchemaWorker(this.lTableContainer, rtree, (AbstractDocument)lDoc2, rDoc2, this.typeMap, this.typeMap);
        worker2.run();
        CompareSchemaWorkerTest.assertEquals((String)"Extra table: b\nExtra table: c\n", (String)lDoc2.getText(0, lDoc2.getLength()));
        CompareSchemaWorkerTest.assertEquals((String)"Missing table: b\nMissing table: c\n", (String)rDoc2.getText(0, rDoc2.getLength()));
        CompareSchemaWorkerTest.assertEquals((String)"Missing table: a\nSame table: b\nExtra table: c\n", (String)this.l.getText(0, this.l.getLength()));
        CompareSchemaWorkerTest.assertEquals((String)"Extra table: a\nSame table: b\nMissing table: c\n", (String)this.r.getText(0, this.r.getLength()));
    }

    public void testGenerateDiffWithColumns() throws ArchitectException, BadLocationException {
        TreeSet<SQLTable> tree1 = new TreeSet<SQLTable>(new SQLObjectCompare());
        TreeSet<SQLTable> tree2 = new TreeSet<SQLTable>(new SQLObjectCompare());
        DefaultStyledDocument rDoc = new DefaultStyledDocument();
        DefaultStyledDocument lDoc = new DefaultStyledDocument();
        SQLTable table1 = new SQLTable(null, "a", "actually r1", SQLTable.class.toString(), true);
        SQLColumn c1 = new SQLColumn(table1, "Column1", 0, 2, 3);
        SQLColumn c2 = new SQLColumn(table1, "Column2", 0, 2, 3);
        table1.addColumn(c1);
        table1.addColumn(c2);
        SQLTable table2 = new SQLTable(null, "b", "actually r2", SQLTable.class.toString(), true);
        SQLColumn c3 = new SQLColumn(table2, "Column3", 0, 2, 3);
        SQLColumn c4 = new SQLColumn(table2, "Column3a", 0, 2, 3);
        table2.addColumn(c3);
        table2.addColumn(c4);
        SQLTable table3 = new SQLTable(null, "b", "actually r2", SQLTable.class.toString(), true);
        SQLColumn c5 = new SQLColumn(table3, "Column3", 0, 2, 3);
        SQLColumn c6 = new SQLColumn(table3, "Column3b", 0, 2, 3);
        table3.addColumn(c5);
        table3.addColumn(c6);
        SQLTable table4 = new SQLTable(null, "c", "actually l3", SQLTable.class.toString(), true);
        SQLColumn c7 = new SQLColumn(table4, "Column4", 0, 2, 3);
        table4.addColumn(c7);
        tree1.add(table1);
        CompareSchemaWorker workerNoColAndCols = new CompareSchemaWorker(tree2, tree1, (AbstractDocument)lDoc, rDoc, this.typeMap, this.typeMap);
        workerNoColAndCols.run();
        CompareSchemaWorkerTest.assertEquals((String)"Missing table: a\n\tMissing column: Column1: MockInteger\n\tMissing column: Column2: MockInteger\n", (String)lDoc.getText(0, lDoc.getLength()));
        CompareSchemaWorkerTest.assertEquals((String)"Extra table: a\n\tExtra column: Column1: MockInteger\n\tExtra column: Column2: MockInteger\n", (String)rDoc.getText(0, rDoc.getLength()));
        DefaultStyledDocument rDocTest2 = new DefaultStyledDocument();
        DefaultStyledDocument lDocTest2 = new DefaultStyledDocument();
        CompareSchemaWorker workerColAndNoCols = new CompareSchemaWorker(tree1, tree2, (AbstractDocument)lDocTest2, rDocTest2, this.typeMap, this.typeMap);
        workerColAndNoCols.run();
        CompareSchemaWorkerTest.assertEquals((String)"Missing table: a\n\tMissing column: Column1: MockInteger\n\tMissing column: Column2: MockInteger\n", (String)rDocTest2.getText(0, rDocTest2.getLength()));
        CompareSchemaWorkerTest.assertEquals((String)"Extra table: a\n\tExtra column: Column1: MockInteger\n\tExtra column: Column2: MockInteger\n", (String)lDocTest2.getText(0, lDocTest2.getLength()));
        tree1.add(table2);
        tree2.add(table3);
        tree2.add(table4);
        DefaultStyledDocument rDoc3 = new DefaultStyledDocument();
        DefaultStyledDocument lDoc3 = new DefaultStyledDocument();
        CompareSchemaWorker workerColAndCol = new CompareSchemaWorker(tree1, tree2, (AbstractDocument)lDoc3, rDoc3, this.typeMap, this.typeMap);
        workerColAndCol.run();
        CompareSchemaWorkerTest.assertEquals((String)"Extra table: a\n\tExtra column: Column1: MockInteger\n\tExtra column: Column2: MockInteger\nSame table: b\n\tSame column: Column3: MockInteger\n\tExtra column: Column3a: MockInteger\n\tMissing column: Column3b: MockInteger\nMissing table: c\n\tMissing column: Column4: MockInteger\n", (String)lDoc3.getText(0, lDoc3.getLength()));
        CompareSchemaWorkerTest.assertEquals((String)"Missing table: a\n\tMissing column: Column1: MockInteger\n\tMissing column: Column2: MockInteger\nSame table: b\n\tSame column: Column3: MockInteger\n\tMissing column: Column3a: MockInteger\n\tExtra column: Column3b: MockInteger\nExtra table: c\n\tExtra column: Column4: MockInteger\n", (String)rDoc3.getText(0, rDoc3.getLength()));
        TreeSet<SQLTable> tree3 = new TreeSet<SQLTable>(new SQLObjectCompare());
        TreeSet<SQLTable> tree4 = new TreeSet<SQLTable>(new SQLObjectCompare());
        DefaultStyledDocument rTest = new DefaultStyledDocument();
        DefaultStyledDocument lTest = new DefaultStyledDocument();
        SQLTable t1 = new SQLTable(null, "x", "test x", SQLTable.class.toString(), true);
        SQLColumn col = new SQLColumn(t1, "test", 0, 2, 3);
        t1.addColumn(col);
        SQLTable t2 = new SQLTable(null, "x", "test x", SQLTable.class.toString(), true);
        SQLColumn col2 = new SQLColumn(t2, "test", 1, 3, 3);
        t2.addColumn(col2);
        SQLTable t3 = new SQLTable(null, "z", "test x", SQLTable.class.toString(), true);
        SQLColumn col3 = new SQLColumn(t3, "test 1", 0, 2, 3);
        t3.addColumn(col3);
        tree3.add(t1);
        tree4.add(t2);
        tree4.add(t3);
        CompareSchemaWorker testDiffColProp = new CompareSchemaWorker(tree3, tree4, (AbstractDocument)lTest, rTest, this.typeMap, this.typeMap);
        testDiffColProp.run();
        CompareSchemaWorkerTest.assertEquals((String)"Same table: x\n\tModify column test from type: MockInteger to type: Precision(3)\nMissing table: z\n\tMissing column: test 1: MockInteger\n", (String)lTest.getText(0, lTest.getLength()));
        CompareSchemaWorkerTest.assertEquals((String)"Same table: x\n\tModify column test from type: Precision(3) to type: MockInteger\nExtra table: z\n\tExtra column: test 1: MockInteger\n", (String)rTest.getText(0, rTest.getLength()));
    }

    public void testIsFinished() {
    }

    public void testSetLeftDiff() {
    }

    public void testSetRightDiff() {
    }
}

