/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLSchema;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.SQLTestCase;
import ca.sqlpower.architect.TestSQLColumn;

public class TestSQLSchema
extends SQLTestCase {
    private SQLSchema s;

    public TestSQLSchema(String name) throws Exception {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.s = new SQLSchema(true);
    }

    protected SQLObject getSQLObjectUnderTest() {
        return this.s;
    }

    public void testGetName() {
        TestSQLSchema.assertNull((Object)this.s.getName());
        SQLSchema s2 = new SQLSchema(this.s, "xxx", true);
        TestSQLSchema.assertEquals((String)"xxx", (String)s2.getName());
    }

    public void testGetParent() {
        TestSQLSchema.assertNull((Object)this.s.getParent());
        SQLSchema s2 = new SQLSchema(this.s, "xxx", true);
        TestSQLSchema.assertEquals((Object)this.s, (Object)s2.getParent());
    }

    public void testPopulate() throws Exception {
        TestSQLSchema.assertEquals((boolean)this.s.isPopulated(), (boolean)true);
        this.s.populate();
        TestSQLSchema.assertEquals((boolean)this.s.isPopulated(), (boolean)true);
        this.s.setPopulated(false);
        TestSQLSchema.assertEquals((boolean)this.s.isPopulated(), (boolean)false);
        this.s.setPopulated(true);
        TestSQLSchema.assertEquals((boolean)this.s.isPopulated(), (boolean)true);
        SQLSchema s2 = new SQLSchema(new SQLDatabase(this.db.getDataSource()), "xx", false);
        TestSQLSchema.assertEquals((boolean)s2.isPopulated(), (boolean)false);
        s2.populate();
        TestSQLSchema.assertEquals((boolean)s2.isPopulated(), (boolean)true);
        s2.setPopulated(false);
        TestSQLSchema.assertEquals((boolean)s2.isPopulated(), (boolean)false);
        s2.setPopulated(true);
        TestSQLSchema.assertEquals((boolean)s2.isPopulated(), (boolean)true);
    }

    public void testAllowsChildren() throws Exception {
        TestSQLSchema.assertEquals((boolean)this.s.allowsChildren(), (boolean)true);
        SQLSchema s2 = new SQLSchema(new SQLDatabase(this.db.getDataSource()), "xx", false);
        TestSQLSchema.assertEquals((boolean)s2.allowsChildren(), (boolean)true);
    }

    public void testGetTableByName() throws Exception {
        SQLTable t1 = this.s.getTableByName("REGRESSION_TEST1");
        TestSQLSchema.assertNull((Object)t1);
        t1 = new SQLTable();
        t1.setName("xx1");
        this.s.addChild(t1);
        t1 = new SQLTable();
        t1.setName("xx2");
        this.s.addChild(t1);
        t1 = new SQLTable();
        t1.setName("xx3");
        this.s.addChild(t1);
        t1 = new SQLTable();
        t1.setName("xx2");
        this.s.addChild(t1);
        t1 = this.s.getTableByName("xx1");
        TestSQLSchema.assertNotNull((Object)t1);
        TestSQLSchema.assertEquals((String)t1.getName(), (String)"xx1");
        t1 = this.s.getTableByName("xx2");
        TestSQLSchema.assertNotNull((Object)t1);
        TestSQLSchema.assertEquals((String)t1.getName(), (String)"xx2");
        t1 = this.s.getTableByName("xx3");
        TestSQLSchema.assertNotNull((Object)t1);
        TestSQLSchema.assertEquals((String)t1.getName(), (String)"xx3");
    }

    public void testIsParentTypeDatabase() {
        TestSQLSchema.assertEquals((boolean)this.s.isParentTypeDatabase(), (boolean)false);
        SQLSchema s2 = new SQLSchema(new SQLDatabase(this.db.getDataSource()), "xx", false);
        TestSQLSchema.assertEquals((boolean)s2.isParentTypeDatabase(), (boolean)true);
    }

    public void testSetSchemaName() {
        TestSQLSchema.assertNull((Object)this.s.getName());
        this.s.setName("xx23");
        TestSQLSchema.assertEquals((String)this.s.getName(), (String)"xx23");
        SQLSchema s2 = new SQLSchema(this.s, "xxx", true);
        s2.setName("xx23");
        TestSQLSchema.assertEquals((String)s2.getName(), (String)"xx23");
    }

    public void testGetNativeTerm() {
        TestSQLSchema.assertEquals((String)this.s.getNativeTerm(), (String)"schema");
        this.s.setNativeTerm(null);
        TestSQLSchema.assertNull((Object)this.s.getNativeTerm());
        this.s.setNativeTerm("AAA");
        TestSQLSchema.assertEquals((String)this.s.getNativeTerm(), (String)"aaa");
        SQLSchema s2 = new SQLSchema(this.s, "xxx", true);
        TestSQLSchema.assertEquals((String)s2.getNativeTerm(), (String)"schema");
        s2.setNativeTerm(null);
        TestSQLSchema.assertNull((Object)s2.getNativeTerm());
        s2.setNativeTerm("AAA");
        TestSQLSchema.assertEquals((String)s2.getNativeTerm(), (String)"aaa");
    }

    public void testGetChildren() throws Exception {
        int cnt = 0;
        TestSQLSchema.assertEquals((int)0, (int)this.s.getChildren().size());
        TestSQLSchema.assertEquals((int)cnt, (int)this.s.getChildCount());
        this.s.addChild(new SQLTable(this.s, "", "", "TABLE", true));
        TestSQLSchema.assertEquals((int)(++cnt), (int)this.s.getChildren().size());
        TestSQLSchema.assertEquals((int)cnt, (int)this.s.getChildCount());
        this.s.addChild(new SQLTable(this.s, "", "", "TABLE", true));
        TestSQLSchema.assertEquals((int)(++cnt), (int)this.s.getChildren().size());
        TestSQLSchema.assertEquals((int)cnt, (int)this.s.getChildCount());
        this.s.addChild(new SQLTable(this.s, "", "", "TABLE", true));
        TestSQLSchema.assertEquals((int)(++cnt), (int)this.s.getChildren().size());
        TestSQLSchema.assertEquals((int)cnt, (int)this.s.getChildCount());
        this.s.addChild(new SQLTable(this.s, "", "", "TABLE", true));
        TestSQLSchema.assertEquals((int)(++cnt), (int)this.s.getChildren().size());
        TestSQLSchema.assertEquals((int)cnt, (int)this.s.getChildCount());
        this.s.addChild(new SQLTable(this.s, "", "", "TABLE", true));
        TestSQLSchema.assertEquals((int)(++cnt), (int)this.s.getChildren().size());
        TestSQLSchema.assertEquals((int)cnt, (int)this.s.getChildCount());
        this.s.removeChild(0);
        TestSQLSchema.assertEquals((int)(--cnt), (int)this.s.getChildren().size());
        TestSQLSchema.assertEquals((int)cnt, (int)this.s.getChildCount());
        this.s.removeChild(0);
        TestSQLSchema.assertEquals((int)(--cnt), (int)this.s.getChildren().size());
        TestSQLSchema.assertEquals((int)cnt, (int)this.s.getChildCount());
        this.s.removeChild(0);
        TestSQLSchema.assertEquals((int)(--cnt), (int)this.s.getChildren().size());
        TestSQLSchema.assertEquals((int)cnt, (int)this.s.getChildCount());
        this.s.removeChild(0);
        TestSQLSchema.assertEquals((int)(--cnt), (int)this.s.getChildren().size());
        TestSQLSchema.assertEquals((int)cnt, (int)this.s.getChildCount());
    }

    public void testGetChild() throws Exception {
        int i = 0;
        while (i < 5) {
            this.s.addChild(new SQLTable(this.s, "", "", "TABLE", true));
            ++i;
        }
        TestSQLSchema.assertEquals((int)5, (int)this.s.getChildren().size());
        TestSQLSchema.assertEquals((int)5, (int)this.s.getChildCount());
        SQLTable t = (SQLTable)this.s.getChild(1);
        TestSQLSchema.assertNotNull((Object)t);
        TestSQLSchema.assertTrue((boolean)(t instanceof SQLTable));
        TestSQLSchema.assertEquals((String)t.getName(), (String)"");
    }

    public void testAddChildIntSQLObject() throws Exception {
        int i = 0;
        while (i < 5) {
            this.s.addChild(i, new SQLTable(this.s, "", "", "TABLE", true));
            TestSQLSchema.assertEquals((int)(i + 1), (int)this.s.getChildren().size());
            TestSQLSchema.assertEquals((int)(i + 1), (int)this.s.getChildCount());
            ++i;
        }
        SQLTable t = new SQLTable(this.s, "xxx", "", "TABLE", true);
        this.s.addChild(0, t);
        TestSQLSchema.assertEquals((int)6, (int)this.s.getChildren().size());
        TestSQLSchema.assertEquals((int)6, (int)this.s.getChildCount());
        this.s.removeChild(t);
        TestSQLSchema.assertEquals((int)5, (int)this.s.getChildren().size());
        TestSQLSchema.assertEquals((int)5, (int)this.s.getChildCount());
        int i2 = 4;
        while (i2 >= 0) {
            this.s.removeChild(0);
            TestSQLSchema.assertEquals((int)i2, (int)this.s.getChildren().size());
            TestSQLSchema.assertEquals((int)i2, (int)this.s.getChildCount());
            --i2;
        }
    }

    public void testAddChildSQLObject() throws Exception {
        int i = 0;
        while (i < 5) {
            this.s.addChild(new SQLTable(this.s, "", "", "TABLE", true));
            TestSQLSchema.assertEquals((int)(i + 1), (int)this.s.getChildren().size());
            TestSQLSchema.assertEquals((int)(i + 1), (int)this.s.getChildCount());
            ++i;
        }
        SQLTable t = new SQLTable(this.s, "xxx", "", "TABLE", true);
        this.s.addChild(t);
        int i2 = 5;
        while (i2 > 0) {
            this.s.removeChild(0);
            TestSQLSchema.assertEquals((int)i2, (int)this.s.getChildren().size());
            TestSQLSchema.assertEquals((int)i2, (int)this.s.getChildCount());
            --i2;
        }
        this.s.removeChild(t);
        TestSQLSchema.assertEquals((int)0, (int)this.s.getChildren().size());
        TestSQLSchema.assertEquals((int)0, (int)this.s.getChildCount());
    }

    public void testGetSQLObjectListeners() throws Exception {
        TestSQLColumn.TestSQLObjectListener test1 = new TestSQLColumn.TestSQLObjectListener();
        TestSQLColumn.TestSQLObjectListener test2 = new TestSQLColumn.TestSQLObjectListener();
        this.s.addSQLObjectListener(test1);
        this.s.addSQLObjectListener(test2);
        TestSQLSchema.assertEquals((Object)this.s.getSQLObjectListeners().get(0), (Object)test1);
        TestSQLSchema.assertEquals((Object)this.s.getSQLObjectListeners().get(1), (Object)test2);
        int i = 0;
        while (i < 5) {
            this.s.addChild(new SQLTable(this.s, "", "", "TABLE", true));
            ++i;
        }
        TestSQLSchema.assertEquals((int)test1.getInsertedCount(), (int)5);
        TestSQLSchema.assertEquals((int)test1.getRemovedCount(), (int)0);
        TestSQLSchema.assertEquals((int)test1.getChangedCount(), (int)0);
        TestSQLSchema.assertEquals((int)test1.getStructureChangedCount(), (int)0);
        TestSQLSchema.assertEquals((int)test2.getInsertedCount(), (int)5);
        TestSQLSchema.assertEquals((int)test2.getRemovedCount(), (int)0);
        TestSQLSchema.assertEquals((int)test2.getChangedCount(), (int)0);
        TestSQLSchema.assertEquals((int)test2.getStructureChangedCount(), (int)0);
        this.s.removeSQLObjectListener(test2);
        i = 0;
        while (i < 5) {
            this.s.removeChild(0);
            ++i;
        }
        TestSQLSchema.assertEquals((int)test1.getInsertedCount(), (int)5);
        TestSQLSchema.assertEquals((int)test1.getRemovedCount(), (int)5);
        TestSQLSchema.assertEquals((int)test1.getChangedCount(), (int)0);
        TestSQLSchema.assertEquals((int)test1.getStructureChangedCount(), (int)0);
        TestSQLSchema.assertEquals((int)test2.getInsertedCount(), (int)5);
        TestSQLSchema.assertEquals((int)test2.getRemovedCount(), (int)0);
        TestSQLSchema.assertEquals((int)test2.getChangedCount(), (int)0);
        TestSQLSchema.assertEquals((int)test2.getStructureChangedCount(), (int)0);
        TestSQLSchema.assertEquals((int)this.s.getSQLObjectListeners().size(), (int)1);
    }
}

