/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.MockJDBCConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;
import org.apache.log4j.Logger;

public class MockJDBCDriver
implements Driver {
    private static final Logger logger = Logger.getLogger(MockJDBCDriver.class);

    public Connection connect(String url, Properties info) throws SQLException {
        String params = url.substring("jdbc:mock:".length());
        String[] keyValuePairs = params.split("&");
        for (String keyvalue : Arrays.asList(keyValuePairs)) {
            String[] kv = keyvalue.split("=");
            logger.debug((Object)("Found URL property '" + kv[0] + "' = '" + kv[1] + "'"));
            info.put(kv[0], kv[1]);
        }
        return new MockJDBCConnection(url, info);
    }

    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith("jdbc:mock");
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return 0;
    }

    public int getMinorVersion() {
        return 0;
    }

    public boolean jdbcCompliant() {
        return false;
    }
}

