/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectException;
import ca.sqlpower.architect.ArchitectUtils;
import ca.sqlpower.architect.CountingSQLObjectListener;
import ca.sqlpower.architect.SQLCatalog;
import ca.sqlpower.architect.SQLDatabase;
import ca.sqlpower.architect.SQLObject;
import ca.sqlpower.architect.SQLObjectListener;
import ca.sqlpower.architect.SQLSchema;
import ca.sqlpower.architect.SQLTable;
import ca.sqlpower.architect.undo.UndoCompoundEvent;
import ca.sqlpower.architect.undo.UndoCompoundEventListener;
import junit.framework.TestCase;

public class ArchitectUtilsTest
extends TestCase {
    SQLObject sqlo;
    private static String[][] sanitizeData = new String[][]{{"a<b", "a&lt;b"}, {"a>b", "a&gt;b"}, {"a\"b", "a&quot;b"}, {"a'b", "a&apos;b"}, {"a&b", "a&amp;b"}, {"a<>b", "a&lt;&gt;b"}, {"a&&b", "a&amp;&amp;b"}, {"abc", "abc"}, {"<source-databases/>", "&lt;source-databases/&gt;"}, {"", ""}};

    public void setUp() {
        this.sqlo = new SQLObject(){

            @Override
            public String getName() {
                return null;
            }

            @Override
            public SQLObject getParent() {
                return null;
            }

            @Override
            protected void setParent(SQLObject parent) {
            }

            @Override
            protected void populate() throws ArchitectException {
            }

            @Override
            public String getShortDisplayName() {
                return null;
            }

            @Override
            public boolean allowsChildren() {
                return false;
            }

            @Override
            public Class<? extends SQLObject> getChildType() {
                return null;
            }
        };
    }

    public void testListenToHierarchySQLObjectListenerSQLObject() throws ArchitectException {
        CountingSQLObjectListener listener = new CountingSQLObjectListener();
        ArchitectUtils.listenToHierarchy((SQLObjectListener)listener, this.sqlo);
        ArchitectUtils.listenToHierarchy((SQLObjectListener)listener, this.sqlo);
        ArchitectUtilsTest.assertEquals((String)"There are the wrong number of listeners", (int)1, (int)this.sqlo.getSQLObjectListeners().size());
        ArchitectUtilsTest.assertTrue((String)"The wrong listener is listening", (boolean)this.sqlo.getSQLObjectListeners().contains(listener));
    }

    public void testListenToHierarchySQLObjectListenerSQLObjectArray() {
    }

    public void testAddUndoListenerToHierarchy() throws ArchitectException {
        UndoCompoundEventListener listener = new UndoCompoundEventListener(){

            public void compoundEditStart(UndoCompoundEvent e) {
            }

            public void compoundEditEnd(UndoCompoundEvent e) {
            }
        };
        ArchitectUtils.addUndoListenerToHierarchy(listener, this.sqlo);
        ArchitectUtils.addUndoListenerToHierarchy(listener, this.sqlo);
        ArchitectUtilsTest.assertEquals((String)"There are the wrong number of listeners", (int)1, (int)this.sqlo.getUndoEventListeners().size());
        ArchitectUtilsTest.assertTrue((String)"The wrong listener is listening", (boolean)this.sqlo.getUndoEventListeners().contains(listener));
    }

    public void testUnlistenToHierarchySQLObjectListenerSQLObject() throws ArchitectException {
        CountingSQLObjectListener listener = new CountingSQLObjectListener();
        ArchitectUtils.listenToHierarchy((SQLObjectListener)listener, this.sqlo);
        ArchitectUtils.listenToHierarchy((SQLObjectListener)listener, this.sqlo);
        ArchitectUtilsTest.assertEquals((String)"There are the wrong number of listeners", (int)1, (int)this.sqlo.getSQLObjectListeners().size());
        ArchitectUtilsTest.assertTrue((String)"The wrong listener is listening", (boolean)this.sqlo.getSQLObjectListeners().contains(listener));
        ArchitectUtils.unlistenToHierarchy((SQLObjectListener)listener, this.sqlo);
        ArchitectUtilsTest.assertEquals((String)"There are the wrong number of listeners", (int)0, (int)this.sqlo.getSQLObjectListeners().size());
    }

    public void testUndoUnlistenToHierarchy() throws ArchitectException {
        UndoCompoundEventListener listener = new UndoCompoundEventListener(){

            public void compoundEditStart(UndoCompoundEvent e) {
            }

            public void compoundEditEnd(UndoCompoundEvent e) {
            }
        };
        ArchitectUtils.addUndoListenerToHierarchy(listener, this.sqlo);
        ArchitectUtils.addUndoListenerToHierarchy(listener, this.sqlo);
        ArchitectUtilsTest.assertEquals((String)"There are the wrong number of listeners", (int)1, (int)this.sqlo.getUndoEventListeners().size());
        ArchitectUtilsTest.assertTrue((String)"The wrong listener is listening", (boolean)this.sqlo.getUndoEventListeners().contains(listener));
        ArchitectUtils.undoUnlistenToHierarchy(listener, this.sqlo);
        ArchitectUtilsTest.assertEquals((String)"There are the wrong number of listeners", (int)0, (int)this.sqlo.getUndoEventListeners().size());
    }

    public void testUnlistenToHierarchySQLObjectListenerSQLObjectArray() {
    }

    public void testAreEqual() {
    }

    public void testFindColumnsSourcedFromDatabase() {
    }

    public void testPokeDatabase() {
    }

    public void testCountTablesSnapshot() {
    }

    public void testFindDescendentsByClass() {
    }

    public void testTruncateString() {
    }

    public void testCountTables() {
    }

    public void testGetDriverTemplateMap() {
    }

    public void testGetDriverTyprMap() {
    }

    public void testGetDriverDDLGeneratorMap() {
    }

    public void testEscapeXML() throws Exception {
        String[][] stringArray = sanitizeData;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String[] td = stringArray[n];
            ArchitectUtilsTest.assertEquals((String)td[1], (String)ArchitectUtils.escapeXML(td[0]));
            ++n;
        }
    }

    public void testGetAncestor() throws ArchitectException {
        SQLDatabase parentdb = new SQLDatabase();
        SQLSchema sch = new SQLSchema(true);
        SQLTable t = new SQLTable(sch, "cows", "remarkable cows", "TABLE", true);
        parentdb.addChild(sch);
        sch.addChild(t);
        ArchitectUtilsTest.assertEquals((Object)parentdb, (Object)ArchitectUtils.getAncestor(t.getColumnsFolder(), SQLDatabase.class));
        ArchitectUtilsTest.assertEquals((Object)sch, (Object)ArchitectUtils.getAncestor(t.getColumnsFolder(), SQLSchema.class));
        ArchitectUtilsTest.assertEquals((Object)t, (Object)ArchitectUtils.getAncestor(t.getColumnsFolder(), SQLTable.class));
        ArchitectUtilsTest.assertEquals(t.getColumnsFolder(), (Object)ArchitectUtils.getAncestor(t.getColumnsFolder(), SQLTable.Folder.class));
        ArchitectUtilsTest.assertNull((Object)ArchitectUtils.getAncestor(t.getColumnsFolder(), SQLCatalog.class));
        parentdb.removeChild(sch);
        ArchitectUtilsTest.assertNull((Object)ArchitectUtils.getAncestor(t.getColumnsFolder(), SQLDatabase.class));
    }

    public void testCreateTableWhenExisting() throws Exception {
        SQLDatabase db = new SQLDatabase();
        SQLCatalog cat = new SQLCatalog(db, "cat", true);
        db.addChild(cat);
        SQLSchema schem = new SQLSchema(cat, "schem", true);
        cat.addChild(schem);
        SQLTable tab = new SQLTable(schem, "tab", null, "TABLE", true);
        schem.addChild(tab);
        try {
            ArchitectUtils.addSimulatedTable(db, "cat", "schem", "tab");
            ArchitectUtilsTest.fail((String)"Should not have been allowed because table exists");
        }
        catch (ArchitectException architectException) {
            // empty catch block
        }
    }
}

