/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.ArchitectSession;
import ca.sqlpower.architect.CoreUserSettings;
import ca.sqlpower.architect.JDBCClassLoader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchitectSessionImpl
implements ArchitectSession {
    protected static ArchitectSession instance;
    protected CoreUserSettings userSettings;
    protected JDBCClassLoader jdbcClassLoader;
    protected List<String> driverJarList = new LinkedList<String>();

    public ArchitectSessionImpl() {
        this.jdbcClassLoader = new JDBCClassLoader(this);
    }

    public static synchronized ArchitectSession getInstance() {
        if (instance == null) {
            instance = new ArchitectSessionImpl();
        }
        return instance;
    }

    @Override
    public CoreUserSettings getUserSettings() {
        return this.userSettings;
    }

    @Override
    public void setUserSettings(CoreUserSettings argUserSettings) {
        this.userSettings = argUserSettings;
    }

    @Override
    public List<String> getDriverJarList() {
        return Collections.unmodifiableList(this.driverJarList);
    }

    @Override
    public boolean addDriverJar(String fullPath) {
        return this.driverJarList.add(fullPath);
    }

    @Override
    public boolean removeDriverJar(String fullPath) {
        return this.driverJarList.remove(fullPath);
    }

    @Override
    public void removeAllDriverJars() {
        this.driverJarList.clear();
    }

    @Override
    public void clearDriverJarList() {
        this.driverJarList.clear();
    }

    @Override
    public JDBCClassLoader getJDBCClassLoader() {
        return this.jdbcClassLoader;
    }
}

