require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&CR0_PE)) {
    sub CR0_PE () {	0x1;}
}
unless(defined(&CR0_MP)) {
    sub CR0_MP () {	0x2;}
}
unless(defined(&CR0_EM)) {
    sub CR0_EM () {	0x4;}
}
unless(defined(&CR0_TS)) {
    sub CR0_TS () {	0x8;}
}
unless(defined(&CR0_ET)) {
    sub CR0_ET () {	0x10;}
}
unless(defined(&CR0_PG)) {
    sub CR0_PG () {	0x80000000;}
}
unless(defined(&CR0_NE)) {
    sub CR0_NE () {	0x20;}
}
unless(defined(&CR0_WP)) {
    sub CR0_WP () {	0x10000;}
}
unless(defined(&CR0_AM)) {
    sub CR0_AM () {	0x40000;}
}
unless(defined(&CR0_NW)) {
    sub CR0_NW () {	0x20000000;}
}
unless(defined(&CR0_CD)) {
    sub CR0_CD () {	0x40000000;}
}
unless(defined(&CCR0)) {
    sub CCR0 () {	0xc0;}
}
unless(defined(&CCR0_NC0)) {
    sub CCR0_NC0 () {	0x1;}
}
unless(defined(&CCR0_NC1)) {
    sub CCR0_NC1 () {	0x2;}
}
unless(defined(&CCR0_A20M)) {
    sub CCR0_A20M () {	0x4;}
}
unless(defined(&CCR0_KEN)) {
    sub CCR0_KEN () {	0x8;}
}
unless(defined(&CCR0_FLUSH)) {
    sub CCR0_FLUSH () {	0x10;}
}
unless(defined(&CCR0_BARB)) {
    sub CCR0_BARB () {	0x20;}
}
unless(defined(&CCR0_CO)) {
    sub CCR0_CO () {	0x40;}
}
unless(defined(&CCR0_SUSPEND)) {
    sub CCR0_SUSPEND () {	0x80;}
}
unless(defined(&CCR1)) {
    sub CCR1 () {	0xc1;}
}
unless(defined(&CCR1_RPL)) {
    sub CCR1_RPL () {	0x1;}
}
unless(defined(&CR4_VME)) {
    sub CR4_VME () {	0x1;}
}
unless(defined(&CR4_PVI)) {
    sub CR4_PVI () {	0x2;}
}
unless(defined(&CR4_TSD)) {
    sub CR4_TSD () {	0x4;}
}
unless(defined(&CR4_DE)) {
    sub CR4_DE () {	0x8;}
}
unless(defined(&CR4_PSE)) {
    sub CR4_PSE () {	0x10;}
}
unless(defined(&CR4_PAE)) {
    sub CR4_PAE () {	0x20;}
}
unless(defined(&CR4_MCE)) {
    sub CR4_MCE () {	0x40;}
}
unless(defined(&CR4_PGE)) {
    sub CR4_PGE () {	0x80;}
}
unless(defined(&CR4_PCE)) {
    sub CR4_PCE () {	0x100;}
}
unless(defined(&CR4_OSFXSR)) {
    sub CR4_OSFXSR () {	0x200;}
}
unless(defined(&CR4_OSXMMEXCPT)) {
    sub CR4_OSXMMEXCPT () {	0x400;}
}
unless(defined(&CPUID_FPU)) {
    sub CPUID_FPU () {	0x1;}
}
unless(defined(&CPUID_VME)) {
    sub CPUID_VME () {	0x2;}
}
unless(defined(&CPUID_DE)) {
    sub CPUID_DE () {	0x4;}
}
unless(defined(&CPUID_PSE)) {
    sub CPUID_PSE () {	0x8;}
}
unless(defined(&CPUID_TSC)) {
    sub CPUID_TSC () {	0x10;}
}
unless(defined(&CPUID_MSR)) {
    sub CPUID_MSR () {	0x20;}
}
unless(defined(&CPUID_PAE)) {
    sub CPUID_PAE () {	0x40;}
}
unless(defined(&CPUID_MCE)) {
    sub CPUID_MCE () {	0x80;}
}
unless(defined(&CPUID_CX8)) {
    sub CPUID_CX8 () {	0x100;}
}
unless(defined(&CPUID_APIC)) {
    sub CPUID_APIC () {	0x200;}
}
unless(defined(&CPUID_SYS1)) {
    sub CPUID_SYS1 () {	0x400;}
}
unless(defined(&CPUID_SEP)) {
    sub CPUID_SEP () {	0x800;}
}
unless(defined(&CPUID_MTRR)) {
    sub CPUID_MTRR () {	0x1000;}
}
unless(defined(&CPUID_PGE)) {
    sub CPUID_PGE () {	0x2000;}
}
unless(defined(&CPUID_MCA)) {
    sub CPUID_MCA () {	0x4000;}
}
unless(defined(&CPUID_CMOV)) {
    sub CPUID_CMOV () {	0x8000;}
}
unless(defined(&CPUID_PAT)) {
    sub CPUID_PAT () {	0x10000;}
}
unless(defined(&CPUID_PSE36)) {
    sub CPUID_PSE36 () {	0x20000;}
}
unless(defined(&CPUID_SER)) {
    sub CPUID_SER () {	0x40000;}
}
unless(defined(&CPUID_CFLUSH)) {
    sub CPUID_CFLUSH () {	0x80000;}
}
unless(defined(&CPUID_B20)) {
    sub CPUID_B20 () {	0x100000;}
}
unless(defined(&CPUID_DS)) {
    sub CPUID_DS () {	0x200000;}
}
unless(defined(&CPUID_ACPI)) {
    sub CPUID_ACPI () {	0x400000;}
}
unless(defined(&CPUID_MMX)) {
    sub CPUID_MMX () {	0x800000;}
}
unless(defined(&CPUID_FXSR)) {
    sub CPUID_FXSR () {	0x1000000;}
}
unless(defined(&CPUID_EMMX)) {
    sub CPUID_EMMX () {	0x1000000;}
}
unless(defined(&CPUID_SSE)) {
    sub CPUID_SSE () {	0x2000000;}
}
unless(defined(&CPUID_SSE2)) {
    sub CPUID_SSE2 () {	0x4000000;}
}
unless(defined(&CPUID_SS)) {
    sub CPUID_SS () {	0x8000000;}
}
unless(defined(&CPUID_HTT)) {
    sub CPUID_HTT () {	0x10000000;}
}
unless(defined(&CPUID_TM)) {
    sub CPUID_TM () {	0x20000000;}
}
unless(defined(&CPUID_B30)) {
    sub CPUID_B30 () {	0x40000000;}
}
unless(defined(&CPUID_SBF)) {
    sub CPUID_SBF () {	0x80000000;}
}
unless(defined(&CPUID_3DNOW)) {
    sub CPUID_3DNOW () {	0x40000000;}
}
unless(defined(&CPUID_LONG)) {
    sub CPUID_LONG () {	0x20000000;}
}
unless(defined(&CPUIDECX_SSE3)) {
    sub CPUIDECX_SSE3 () {	0x1;}
}
unless(defined(&CPUIDECX_MWAIT)) {
    sub CPUIDECX_MWAIT () {	0x8;}
}
unless(defined(&CPUIDECX_DSCPL)) {
    sub CPUIDECX_DSCPL () {	0x10;}
}
unless(defined(&CPUIDECX_VMX)) {
    sub CPUIDECX_VMX () {	0x20;}
}
unless(defined(&CPUIDECX_EST)) {
    sub CPUIDECX_EST () {	0x80;}
}
unless(defined(&CPUIDECX_TM2)) {
    sub CPUIDECX_TM2 () {	0x100;}
}
unless(defined(&CPUIDECX_CNXTID)) {
    sub CPUIDECX_CNXTID () {	0x400;}
}
unless(defined(&CPUIDECX_CX16)) {
    sub CPUIDECX_CX16 () {	0x2000;}
}
unless(defined(&CPUIDECX_XTPR)) {
    sub CPUIDECX_XTPR () {	0x4000;}
}
unless(defined(&MSR_P5_MC_ADDR)) {
    sub MSR_P5_MC_ADDR () {	0x;}
}
unless(defined(&MSR_P5_MC_TYPE)) {
    sub MSR_P5_MC_TYPE () {	0x1;}
}
unless(defined(&MSR_TSC)) {
    sub MSR_TSC () {	0x10;}
}
unless(defined(&P5MSR_CTRSEL)) {
    sub P5MSR_CTRSEL () {	0x11;}
}
unless(defined(&P5MSR_CTR0)) {
    sub P5MSR_CTR0 () {	0x12;}
}
unless(defined(&P5MSR_CTR1)) {
    sub P5MSR_CTR1 () {	0x13;}
}
unless(defined(&MSR_APICBASE)) {
    sub MSR_APICBASE () {	0x1b;}
}
unless(defined(&MSR_EBL_CR_POWERON)) {
    sub MSR_EBL_CR_POWERON () {	0x2a;}
}
unless(defined(&MSR_EBC_FREQUENCY_ID)) {
    sub MSR_EBC_FREQUENCY_ID () {	0x2c;}
}
unless(defined(&MSR_TEST_CTL)) {
    sub MSR_TEST_CTL () {	0x33;}
}
unless(defined(&MSR_BIOS_UPDT_TRIG)) {
    sub MSR_BIOS_UPDT_TRIG () {	0x79;}
}
unless(defined(&MSR_BBL_CR_D0)) {
    sub MSR_BBL_CR_D0 () {	0x88;}
}
unless(defined(&MSR_BBL_CR_D1)) {
    sub MSR_BBL_CR_D1 () {	0x89;}
}
unless(defined(&MSR_BBL_CR_D2)) {
    sub MSR_BBL_CR_D2 () {	0x8a;}
}
unless(defined(&MSR_BIOS_SIGN)) {
    sub MSR_BIOS_SIGN () {	0x8b;}
}
unless(defined(&P6MSR_CTR0)) {
    sub P6MSR_CTR0 () {	0xc1;}
}
unless(defined(&P6MSR_CTR1)) {
    sub P6MSR_CTR1 () {	0xc2;}
}
unless(defined(&MSR_FSB_FREQ)) {
    sub MSR_FSB_FREQ () {	0xcd;}
}
unless(defined(&MSR_MTRRcap)) {
    sub MSR_MTRRcap () {	0xfe;}
}
unless(defined(&MSR_BBL_CR_ADDR)) {
    sub MSR_BBL_CR_ADDR () {	0x116;}
}
unless(defined(&MSR_BBL_CR_DECC)) {
    sub MSR_BBL_CR_DECC () {	0x118;}
}
unless(defined(&MSR_BBL_CR_CTL)) {
    sub MSR_BBL_CR_CTL () {	0x119;}
}
unless(defined(&MSR_BBL_CR_TRIG)) {
    sub MSR_BBL_CR_TRIG () {	0x11a;}
}
unless(defined(&MSR_BBL_CR_BUSY)) {
    sub MSR_BBL_CR_BUSY () {	0x11b;}
}
unless(defined(&MSR_BBL_CR_CTR3)) {
    sub MSR_BBL_CR_CTR3 () {	0x11e;}
}
unless(defined(&MSR_SYSENTER_CS)) {
    sub MSR_SYSENTER_CS () {	0x174;}
}
unless(defined(&MSR_SYSENTER_ESP)) {
    sub MSR_SYSENTER_ESP () {	0x175;}
}
unless(defined(&MSR_SYSENTER_EIP)) {
    sub MSR_SYSENTER_EIP () {	0x176;}
}
unless(defined(&MSR_MCG_CAP)) {
    sub MSR_MCG_CAP () {	0x179;}
}
unless(defined(&MSR_MCG_STATUS)) {
    sub MSR_MCG_STATUS () {	0x17a;}
}
unless(defined(&MSR_MCG_CTL)) {
    sub MSR_MCG_CTL () {	0x17b;}
}
unless(defined(&P6MSR_CTRSEL0)) {
    sub P6MSR_CTRSEL0 () {	0x186;}
}
unless(defined(&P6MSR_CTRSEL1)) {
    sub P6MSR_CTRSEL1 () {	0x187;}
}
unless(defined(&MSR_PERF_STATUS)) {
    sub MSR_PERF_STATUS () {	0x198;}
}
unless(defined(&MSR_PERF_CTL)) {
    sub MSR_PERF_CTL () {	0x199;}
}
unless(defined(&MSR_THERM_CONTROL)) {
    sub MSR_THERM_CONTROL () {	0x19a;}
}
unless(defined(&MSR_THERM_INTERRUPT)) {
    sub MSR_THERM_INTERRUPT () {	0x19b;}
}
unless(defined(&MSR_THERM_STATUS)) {
    sub MSR_THERM_STATUS () {	0x19c;}
}
unless(defined(&MSR_THERM2_CTL)) {
    sub MSR_THERM2_CTL () {	0x19d;}
}
unless(defined(&MSR_MISC_ENABLE)) {
    sub MSR_MISC_ENABLE () {	0x1a0;}
}
unless(defined(&MSR_DEBUGCTLMSR)) {
    sub MSR_DEBUGCTLMSR () {	0x1d9;}
}
unless(defined(&MSR_LASTBRANCHFROMIP)) {
    sub MSR_LASTBRANCHFROMIP () {	0x1db;}
}
unless(defined(&MSR_LASTBRANCHTOIP)) {
    sub MSR_LASTBRANCHTOIP () {	0x1dc;}
}
unless(defined(&MSR_LASTINTFROMIP)) {
    sub MSR_LASTINTFROMIP () {	0x1dd;}
}
unless(defined(&MSR_LASTINTTOIP)) {
    sub MSR_LASTINTTOIP () {	0x1de;}
}
unless(defined(&MSR_ROB_CR_BKUPTMPDR6)) {
    sub MSR_ROB_CR_BKUPTMPDR6 () {	0x1e0;}
}
unless(defined(&MSR_MTRRVarBase)) {
    sub MSR_MTRRVarBase () {	0x200;}
}
unless(defined(&MSR_MTRRphysMask0)) {
    sub MSR_MTRRphysMask0 () {	0x201;}
}
unless(defined(&MSR_MTRRphysBase1)) {
    sub MSR_MTRRphysBase1 () {	0x202;}
}
unless(defined(&MSR_MTRRphysMask1)) {
    sub MSR_MTRRphysMask1 () {	0x203;}
}
unless(defined(&MSR_MTRRphysBase2)) {
    sub MSR_MTRRphysBase2 () {	0x204;}
}
unless(defined(&MSR_MTRRphysMask2)) {
    sub MSR_MTRRphysMask2 () {	0x205;}
}
unless(defined(&MSR_MTRRphysBase3)) {
    sub MSR_MTRRphysBase3 () {	0x206;}
}
unless(defined(&MSR_MTRRphysMask3)) {
    sub MSR_MTRRphysMask3 () {	0x207;}
}
unless(defined(&MSR_MTRRphysBase4)) {
    sub MSR_MTRRphysBase4 () {	0x208;}
}
unless(defined(&MSR_MTRRphysMask4)) {
    sub MSR_MTRRphysMask4 () {	0x209;}
}
unless(defined(&MSR_MTRRphysBase5)) {
    sub MSR_MTRRphysBase5 () {	0x20a;}
}
unless(defined(&MSR_MTRRphysMask5)) {
    sub MSR_MTRRphysMask5 () {	0x20b;}
}
unless(defined(&MSR_MTRRphysBase6)) {
    sub MSR_MTRRphysBase6 () {	0x20c;}
}
unless(defined(&MSR_MTRRphysMask6)) {
    sub MSR_MTRRphysMask6 () {	0x20d;}
}
unless(defined(&MSR_MTRRphysBase7)) {
    sub MSR_MTRRphysBase7 () {	0x20e;}
}
unless(defined(&MSR_MTRRphysMask7)) {
    sub MSR_MTRRphysMask7 () {	0x20f;}
}
unless(defined(&MSR_MTRR64kBase)) {
    sub MSR_MTRR64kBase () {	0x250;}
}
unless(defined(&MSR_MTRR16kBase)) {
    sub MSR_MTRR16kBase () {	0x258;}
}
unless(defined(&MSR_MTRRfix16K_A0000)) {
    sub MSR_MTRRfix16K_A0000 () {	0x259;}
}
unless(defined(&MSR_MTRR4kBase)) {
    sub MSR_MTRR4kBase () {	0x268;}
}
unless(defined(&MSR_MTRRfix4K_C8000)) {
    sub MSR_MTRRfix4K_C8000 () {	0x269;}
}
unless(defined(&MSR_MTRRfix4K_D0000)) {
    sub MSR_MTRRfix4K_D0000 () {	0x26a;}
}
unless(defined(&MSR_MTRRfix4K_D8000)) {
    sub MSR_MTRRfix4K_D8000 () {	0x26b;}
}
unless(defined(&MSR_MTRRfix4K_E0000)) {
    sub MSR_MTRRfix4K_E0000 () {	0x26c;}
}
unless(defined(&MSR_MTRRfix4K_E8000)) {
    sub MSR_MTRRfix4K_E8000 () {	0x26d;}
}
unless(defined(&MSR_MTRRfix4K_F0000)) {
    sub MSR_MTRRfix4K_F0000 () {	0x26e;}
}
unless(defined(&MSR_MTRRfix4K_F8000)) {
    sub MSR_MTRRfix4K_F8000 () {	0x26f;}
}
unless(defined(&MSR_MTRRdefType)) {
    sub MSR_MTRRdefType () {	0x2ff;}
}
unless(defined(&MSR_MC0_CTL)) {
    sub MSR_MC0_CTL () {	0x400;}
}
unless(defined(&MSR_MC0_STATUS)) {
    sub MSR_MC0_STATUS () {	0x401;}
}
unless(defined(&MSR_MC0_ADDR)) {
    sub MSR_MC0_ADDR () {	0x402;}
}
unless(defined(&MSR_MC0_MISC)) {
    sub MSR_MC0_MISC () {	0x403;}
}
unless(defined(&MSR_MC1_CTL)) {
    sub MSR_MC1_CTL () {	0x404;}
}
unless(defined(&MSR_MC1_STATUS)) {
    sub MSR_MC1_STATUS () {	0x405;}
}
unless(defined(&MSR_MC1_ADDR)) {
    sub MSR_MC1_ADDR () {	0x406;}
}
unless(defined(&MSR_MC1_MISC)) {
    sub MSR_MC1_MISC () {	0x407;}
}
unless(defined(&MSR_MC2_CTL)) {
    sub MSR_MC2_CTL () {	0x408;}
}
unless(defined(&MSR_MC2_STATUS)) {
    sub MSR_MC2_STATUS () {	0x409;}
}
unless(defined(&MSR_MC2_ADDR)) {
    sub MSR_MC2_ADDR () {	0x40a;}
}
unless(defined(&MSR_MC2_MISC)) {
    sub MSR_MC2_MISC () {	0x40b;}
}
unless(defined(&MSR_MC4_CTL)) {
    sub MSR_MC4_CTL () {	0x40c;}
}
unless(defined(&MSR_MC4_STATUS)) {
    sub MSR_MC4_STATUS () {	0x40d;}
}
unless(defined(&MSR_MC4_ADDR)) {
    sub MSR_MC4_ADDR () {	0x40e;}
}
unless(defined(&MSR_MC4_MISC)) {
    sub MSR_MC4_MISC () {	0x40f;}
}
unless(defined(&MSR_MC3_CTL)) {
    sub MSR_MC3_CTL () {	0x410;}
}
unless(defined(&MSR_MC3_STATUS)) {
    sub MSR_MC3_STATUS () {	0x411;}
}
unless(defined(&MSR_MC3_ADDR)) {
    sub MSR_MC3_ADDR () {	0x412;}
}
unless(defined(&MSR_MC3_MISC)) {
    sub MSR_MC3_MISC () {	0x413;}
}
unless(defined(&MSR_K6_EPMR)) {
    sub MSR_K6_EPMR () {	0xc0000086;}
}
unless(defined(&MSR_SYSCFG)) {
    sub MSR_SYSCFG () {	0xc0000010;}
}
unless(defined(&MSR_EFER)) {
    sub MSR_EFER () {	0xc0000080;}
}
unless(defined(&EFER_SCE)) {
    sub EFER_SCE () {	0x1;}
}
unless(defined(&EFER_LME)) {
    sub EFER_LME () {	0x100;}
}
unless(defined(&EFER_LMA)) {
    sub EFER_LMA () {	0x400;}
}
unless(defined(&EFER_NXE)) {
    sub EFER_NXE () {	0x800;}
}
unless(defined(&MSR_STAR)) {
    sub MSR_STAR () {	0xc0000081;}
}
unless(defined(&MSR_LSTAR)) {
    sub MSR_LSTAR () {	0xc0000082;}
}
unless(defined(&MSR_CSTAR)) {
    sub MSR_CSTAR () {	0xc0000083;}
}
unless(defined(&MSR_SFMASK)) {
    sub MSR_SFMASK () {	0xc0000084;}
}
unless(defined(&MSR_FSBASE)) {
    sub MSR_FSBASE () {	0xc0000100;}
}
unless(defined(&MSR_GSBASE)) {
    sub MSR_GSBASE () {	0xc0000101;}
}
unless(defined(&MSR_KERNELGSBASE)) {
    sub MSR_KERNELGSBASE () {	0xc0000102;}
}
unless(defined(&MSR_HWCR)) {
    sub MSR_HWCR () {	0xc0010015;}
}
unless(defined(&HWCR_FFDIS)) {
    sub HWCR_FFDIS () {	0x40;}
}
unless(defined(&MSR_NB_CFG)) {
    sub MSR_NB_CFG () {	0xc001001f;}
}
unless(defined(&NB_CFG_DISIOREQLOCK)) {
    sub NB_CFG_DISIOREQLOCK () {	0x4;}
}
unless(defined(&NB_CFG_DISDATMSK)) {
    sub NB_CFG_DISDATMSK () {	68719476736;}
}
unless(defined(&MSR_LS_CFG)) {
    sub MSR_LS_CFG () {	0xc0011020;}
}
unless(defined(&LS_CFG_DIS_LS2_SQUISH)) {
    sub LS_CFG_DIS_LS2_SQUISH () {	0x2000000;}
}
unless(defined(&MSR_IC_CFG)) {
    sub MSR_IC_CFG () {	0xc0011021;}
}
unless(defined(&IC_CFG_DIS_SEQ_PREFETCH)) {
    sub IC_CFG_DIS_SEQ_PREFETCH () {	0x800;}
}
unless(defined(&MSR_DC_CFG)) {
    sub MSR_DC_CFG () {	0xc0011022;}
}
unless(defined(&DC_CFG_DIS_CNV_WC_SSO)) {
    sub DC_CFG_DIS_CNV_WC_SSO () {	0x4;}
}
unless(defined(&DC_CFG_DIS_SMC_CHK_BUF)) {
    sub DC_CFG_DIS_SMC_CHK_BUF () {	0x400;}
}
unless(defined(&MSR_BU_CFG)) {
    sub MSR_BU_CFG () {	0xc0011023;}
}
unless(defined(&BU_CFG_THRL2IDXCMPDIS)) {
    sub BU_CFG_THRL2IDXCMPDIS () {	8796093022208;}
}
unless(defined(&BU_CFG_WBPFSMCCHKDIS)) {
    sub BU_CFG_WBPFSMCCHKDIS () {	35184372088832;}
}
unless(defined(&BU_CFG_WBENHWSBDIS)) {
    sub BU_CFG_WBENHWSBDIS () {	281474976710656;}
}
unless(defined(&MTRR_N64K)) {
    sub MTRR_N64K () {	8;}
}
unless(defined(&MTRR_N16K)) {
    sub MTRR_N16K () {	16;}
}
unless(defined(&MTRR_N4K)) {
    sub MTRR_N4K () {	64;}
}
unless(defined(&NCR1)) {
    sub NCR1 () {	0xc4;}
}
unless(defined(&NCR2)) {
    sub NCR2 () {	0xc7;}
}
unless(defined(&NCR3)) {
    sub NCR3 () {	0xca;}
}
unless(defined(&NCR4)) {
    sub NCR4 () {	0xcd;}
}
unless(defined(&NCR_SIZE_0K)) {
    sub NCR_SIZE_0K () {	0;}
}
unless(defined(&NCR_SIZE_4K)) {
    sub NCR_SIZE_4K () {	1;}
}
unless(defined(&NCR_SIZE_8K)) {
    sub NCR_SIZE_8K () {	2;}
}
unless(defined(&NCR_SIZE_16K)) {
    sub NCR_SIZE_16K () {	3;}
}
unless(defined(&NCR_SIZE_32K)) {
    sub NCR_SIZE_32K () {	4;}
}
unless(defined(&NCR_SIZE_64K)) {
    sub NCR_SIZE_64K () {	5;}
}
unless(defined(&NCR_SIZE_128K)) {
    sub NCR_SIZE_128K () {	6;}
}
unless(defined(&NCR_SIZE_256K)) {
    sub NCR_SIZE_256K () {	7;}
}
unless(defined(&NCR_SIZE_512K)) {
    sub NCR_SIZE_512K () {	8;}
}
unless(defined(&NCR_SIZE_1M)) {
    sub NCR_SIZE_1M () {	9;}
}
unless(defined(&NCR_SIZE_2M)) {
    sub NCR_SIZE_2M () {	10;}
}
unless(defined(&NCR_SIZE_4M)) {
    sub NCR_SIZE_4M () {	11;}
}
unless(defined(&NCR_SIZE_8M)) {
    sub NCR_SIZE_8M () {	12;}
}
unless(defined(&NCR_SIZE_16M)) {
    sub NCR_SIZE_16M () {	13;}
}
unless(defined(&NCR_SIZE_32M)) {
    sub NCR_SIZE_32M () {	14;}
}
unless(defined(&NCR_SIZE_4G)) {
    sub NCR_SIZE_4G () {	15;}
}
unless(defined(&PMC5_CESR_EVENT)) {
    sub PMC5_CESR_EVENT () {	0x3f;}
}
unless(defined(&PMC5_CESR_OS)) {
    sub PMC5_CESR_OS () {	0x40;}
}
unless(defined(&PMC5_CESR_USR)) {
    sub PMC5_CESR_USR () {	0x80;}
}
unless(defined(&PMC5_CESR_E)) {
    sub PMC5_CESR_E () {	0x100;}
}
unless(defined(&PMC5_CESR_P)) {
    sub PMC5_CESR_P () {	0x200;}
}
unless(defined(&PMC6_EVTSEL_EVENT)) {
    sub PMC6_EVTSEL_EVENT () {	0xff;}
}
unless(defined(&PMC6_EVTSEL_UNIT)) {
    sub PMC6_EVTSEL_UNIT () {	0xff00;}
}
unless(defined(&PMC6_EVTSEL_UNIT_SHIFT)) {
    sub PMC6_EVTSEL_UNIT_SHIFT () {	8;}
}
unless(defined(&PMC6_EVTSEL_USR)) {
    sub PMC6_EVTSEL_USR () {	(1<< 16);}
}
unless(defined(&PMC6_EVTSEL_OS)) {
    sub PMC6_EVTSEL_OS () {	(1<< 17);}
}
unless(defined(&PMC6_EVTSEL_E)) {
    sub PMC6_EVTSEL_E () {	(1<< 18);}
}
unless(defined(&PMC6_EVTSEL_PC)) {
    sub PMC6_EVTSEL_PC () {	(1<< 19);}
}
unless(defined(&PMC6_EVTSEL_INT)) {
    sub PMC6_EVTSEL_INT () {	(1<< 20);}
}
unless(defined(&PMC6_EVTSEL_EN)) {
    sub PMC6_EVTSEL_EN () {	(1<< 22);}
}
unless(defined(&PMC6_EVTSEL_INV)) {
    sub PMC6_EVTSEL_INV () {	(1<< 23);}
}
unless(defined(&PMC6_EVTSEL_COUNTER_MASK)) {
    sub PMC6_EVTSEL_COUNTER_MASK () {	0xff000000;}
}
unless(defined(&PMC6_EVTSEL_COUNTER_MASK_SHIFT)) {
    sub PMC6_EVTSEL_COUNTER_MASK_SHIFT () {	24;}
}
unless(defined(&PMC6_DATA_MEM_REFS)) {
    sub PMC6_DATA_MEM_REFS () {	0x43;}
}
unless(defined(&PMC6_DCU_LINES_IN)) {
    sub PMC6_DCU_LINES_IN () {	0x45;}
}
unless(defined(&PMC6_DCU_M_LINES_IN)) {
    sub PMC6_DCU_M_LINES_IN () {	0x46;}
}
unless(defined(&PMC6_DCU_M_LINES_OUT)) {
    sub PMC6_DCU_M_LINES_OUT () {	0x47;}
}
unless(defined(&PMC6_DCU_MISS_OUTSTANDING)) {
    sub PMC6_DCU_MISS_OUTSTANDING () {	0x48;}
}
unless(defined(&PMC6_IFU_IFETCH)) {
    sub PMC6_IFU_IFETCH () {	0x80;}
}
unless(defined(&PMC6_IFU_IFETCH_MISS)) {
    sub PMC6_IFU_IFETCH_MISS () {	0x81;}
}
unless(defined(&PMC6_ITLB_MISS)) {
    sub PMC6_ITLB_MISS () {	0x85;}
}
unless(defined(&PMC6_IFU_MEM_STALL)) {
    sub PMC6_IFU_MEM_STALL () {	0x86;}
}
unless(defined(&PMC6_ILD_STALL)) {
    sub PMC6_ILD_STALL () {	0x87;}
}
unless(defined(&PMC6_L2_IFETCH)) {
    sub PMC6_L2_IFETCH () {	0x28;}
}
unless(defined(&PMC6_L2_LD)) {
    sub PMC6_L2_LD () {	0x29;}
}
unless(defined(&PMC6_L2_ST)) {
    sub PMC6_L2_ST () {	0x2a;}
}
unless(defined(&PMC6_L2_LINES_IN)) {
    sub PMC6_L2_LINES_IN () {	0x24;}
}
unless(defined(&PMC6_L2_LINES_OUT)) {
    sub PMC6_L2_LINES_OUT () {	0x26;}
}
unless(defined(&PMC6_L2_M_LINES_INM)) {
    sub PMC6_L2_M_LINES_INM () {	0x25;}
}
unless(defined(&PMC6_L2_M_LINES_OUTM)) {
    sub PMC6_L2_M_LINES_OUTM () {	0x27;}
}
unless(defined(&PMC6_L2_RQSTS)) {
    sub PMC6_L2_RQSTS () {	0x2e;}
}
unless(defined(&PMC6_L2_ADS)) {
    sub PMC6_L2_ADS () {	0x21;}
}
unless(defined(&PMC6_L2_DBUS_BUSY)) {
    sub PMC6_L2_DBUS_BUSY () {	0x22;}
}
unless(defined(&PMC6_L2_DBUS_BUSY_RD)) {
    sub PMC6_L2_DBUS_BUSY_RD () {	0x23;}
}
unless(defined(&PMC6_BUS_DRDY_CLOCKS)) {
    sub PMC6_BUS_DRDY_CLOCKS () {	0x62;}
}
unless(defined(&PMC6_BUS_LOCK_CLOCKS)) {
    sub PMC6_BUS_LOCK_CLOCKS () {	0x63;}
}
unless(defined(&PMC6_BUS_REQ_OUTSTANDING)) {
    sub PMC6_BUS_REQ_OUTSTANDING () {	0x60;}
}
unless(defined(&PMC6_BUS_TRAN_BRD)) {
    sub PMC6_BUS_TRAN_BRD () {	0x65;}
}
unless(defined(&PMC6_BUS_TRAN_RFO)) {
    sub PMC6_BUS_TRAN_RFO () {	0x66;}
}
unless(defined(&PMC6_BUS_TRANS_WB)) {
    sub PMC6_BUS_TRANS_WB () {	0x67;}
}
unless(defined(&PMC6_BUS_TRAN_IFETCH)) {
    sub PMC6_BUS_TRAN_IFETCH () {	0x68;}
}
unless(defined(&PMC6_BUS_TRAN_INVAL)) {
    sub PMC6_BUS_TRAN_INVAL () {	0x69;}
}
unless(defined(&PMC6_BUS_TRAN_PWR)) {
    sub PMC6_BUS_TRAN_PWR () {	0x6a;}
}
unless(defined(&PMC6_BUS_TRANS_P)) {
    sub PMC6_BUS_TRANS_P () {	0x6b;}
}
unless(defined(&PMC6_BUS_TRANS_IO)) {
    sub PMC6_BUS_TRANS_IO () {	0x6c;}
}
unless(defined(&PMC6_BUS_TRAN_DEF)) {
    sub PMC6_BUS_TRAN_DEF () {	0x6d;}
}
unless(defined(&PMC6_BUS_TRAN_BURST)) {
    sub PMC6_BUS_TRAN_BURST () {	0x6e;}
}
unless(defined(&PMC6_BUS_TRAN_ANY)) {
    sub PMC6_BUS_TRAN_ANY () {	0x70;}
}
unless(defined(&PMC6_BUS_TRAN_MEM)) {
    sub PMC6_BUS_TRAN_MEM () {	0x6f;}
}
unless(defined(&PMC6_BUS_DATA_RCV)) {
    sub PMC6_BUS_DATA_RCV () {	0x64;}
}
unless(defined(&PMC6_BUS_BNR_DRV)) {
    sub PMC6_BUS_BNR_DRV () {	0x61;}
}
unless(defined(&PMC6_BUS_HIT_DRV)) {
    sub PMC6_BUS_HIT_DRV () {	0x7a;}
}
unless(defined(&PMC6_BUS_HITM_DRDV)) {
    sub PMC6_BUS_HITM_DRDV () {	0x7b;}
}
unless(defined(&PMC6_BUS_SNOOP_STALL)) {
    sub PMC6_BUS_SNOOP_STALL () {	0x7e;}
}
unless(defined(&PMC6_FLOPS)) {
    sub PMC6_FLOPS () {	0xc1;}
}
unless(defined(&PMC6_FP_COMP_OPS_EXE)) {
    sub PMC6_FP_COMP_OPS_EXE () {	0x10;}
}
unless(defined(&PMC6_FP_ASSIST)) {
    sub PMC6_FP_ASSIST () {	0x11;}
}
unless(defined(&PMC6_MUL)) {
    sub PMC6_MUL () {	0x12;}
}
unless(defined(&PMC6_DIV)) {
    sub PMC6_DIV () {	0x12;}
}
unless(defined(&PMC6_CYCLES_DIV_BUSY)) {
    sub PMC6_CYCLES_DIV_BUSY () {	0x14;}
}
unless(defined(&PMC6_LD_BLOCKS)) {
    sub PMC6_LD_BLOCKS () {	0x3;}
}
unless(defined(&PMC6_SB_DRAINS)) {
    sub PMC6_SB_DRAINS () {	0x4;}
}
unless(defined(&PMC6_MISALIGN_MEM_REF)) {
    sub PMC6_MISALIGN_MEM_REF () {	0x5;}
}
unless(defined(&PMC6_EMON_KNI_PREF_DISPATCHED)) {
    sub PMC6_EMON_KNI_PREF_DISPATCHED () {	0x7;}
}
unless(defined(&PMC6_EMON_KNI_PREF_MISS)) {
    sub PMC6_EMON_KNI_PREF_MISS () {	0x4b;}
}
unless(defined(&PMC6_INST_RETIRED)) {
    sub PMC6_INST_RETIRED () {	0xc0;}
}
unless(defined(&PMC6_UOPS_RETIRED)) {
    sub PMC6_UOPS_RETIRED () {	0xc2;}
}
unless(defined(&PMC6_INST_DECODED)) {
    sub PMC6_INST_DECODED () {	0xd0;}
}
unless(defined(&PMC6_EMON_KNI_INST_RETIRED)) {
    sub PMC6_EMON_KNI_INST_RETIRED () {	0xd8;}
}
unless(defined(&PMC6_EMON_KNI_COMP_INST_RET)) {
    sub PMC6_EMON_KNI_COMP_INST_RET () {	0xd9;}
}
unless(defined(&PMC6_HW_INT_RX)) {
    sub PMC6_HW_INT_RX () {	0xc8;}
}
unless(defined(&PMC6_CYCLES_INT_MASKED)) {
    sub PMC6_CYCLES_INT_MASKED () {	0xc6;}
}
unless(defined(&PMC6_CYCLES_INT_PENDING_AND_MASKED)) {
    sub PMC6_CYCLES_INT_PENDING_AND_MASKED () {	0xc7;}
}
unless(defined(&PMC6_BR_INST_RETIRED)) {
    sub PMC6_BR_INST_RETIRED () {	0xc4;}
}
unless(defined(&PMC6_BR_MISS_PRED_RETIRED)) {
    sub PMC6_BR_MISS_PRED_RETIRED () {	0xc5;}
}
unless(defined(&PMC6_BR_TAKEN_RETIRED)) {
    sub PMC6_BR_TAKEN_RETIRED () {	0xc9;}
}
unless(defined(&PMC6_BR_MISS_PRED_TAKEN_RET)) {
    sub PMC6_BR_MISS_PRED_TAKEN_RET () {	0xca;}
}
unless(defined(&PMC6_BR_INST_DECODED)) {
    sub PMC6_BR_INST_DECODED () {	0xe0;}
}
unless(defined(&PMC6_BTB_MISSES)) {
    sub PMC6_BTB_MISSES () {	0xe2;}
}
unless(defined(&PMC6_BR_BOGUS)) {
    sub PMC6_BR_BOGUS () {	0xe4;}
}
unless(defined(&PMC6_BACLEARS)) {
    sub PMC6_BACLEARS () {	0xe6;}
}
unless(defined(&PMC6_RESOURCE_STALLS)) {
    sub PMC6_RESOURCE_STALLS () {	0xa2;}
}
unless(defined(&PMC6_PARTIAL_RAT_STALLS)) {
    sub PMC6_PARTIAL_RAT_STALLS () {	0xd2;}
}
unless(defined(&PMC6_SEGMENT_REG_LOADS)) {
    sub PMC6_SEGMENT_REG_LOADS () {	0x6;}
}
unless(defined(&PMC6_CPU_CLK_UNHALTED)) {
    sub PMC6_CPU_CLK_UNHALTED () {	0x79;}
}
unless(defined(&PMC6_MMX_INSTR_EXEC)) {
    sub PMC6_MMX_INSTR_EXEC () {	0xb0;}
}
unless(defined(&PMC6_MMX_SAT_INSTR_EXEC)) {
    sub PMC6_MMX_SAT_INSTR_EXEC () {	0xb1;}
}
unless(defined(&PMC6_MMX_UOPS_EXEC)) {
    sub PMC6_MMX_UOPS_EXEC () {	0xb2;}
}
unless(defined(&PMC6_MMX_INSTR_TYPE_EXEC)) {
    sub PMC6_MMX_INSTR_TYPE_EXEC () {	0xb3;}
}
unless(defined(&PMC6_FP_MMX_TRANS)) {
    sub PMC6_FP_MMX_TRANS () {	0xcc;}
}
unless(defined(&PMC6_MMX_ASSIST)) {
    sub PMC6_MMX_ASSIST () {	0xcd;}
}
unless(defined(&PMC6_MMX_INSTR_RET)) {
    sub PMC6_MMX_INSTR_RET () {	0xc3;}
}
unless(defined(&PMC6_SEG_RENAME_STALLS)) {
    sub PMC6_SEG_RENAME_STALLS () {	0xd4;}
}
unless(defined(&PMC6_SEG_REG_RENAMES)) {
    sub PMC6_SEG_REG_RENAMES () {	0xd5;}
}
unless(defined(&PMC6_RET_SEG_RENAMES)) {
    sub PMC6_RET_SEG_RENAMES () {	0xd6;}
}
unless(defined(&C3_HAS_AES)) {
    sub C3_HAS_AES () {	1;}
}
unless(defined(&C3_HAS_SHA)) {
    sub C3_HAS_SHA () {	2;}
}
unless(defined(&C3_HAS_MM)) {
    sub C3_HAS_MM () {	4;}
}
unless(defined(&C3_HAS_AESCTR)) {
    sub C3_HAS_AESCTR () {	8;}
}
unless(defined(&C3_CPUID_HAS_RNG)) {
    sub C3_CPUID_HAS_RNG () {	0x4;}
}
unless(defined(&C3_CPUID_DO_RNG)) {
    sub C3_CPUID_DO_RNG () {	0x8;}
}
unless(defined(&C3_CPUID_HAS_ACE)) {
    sub C3_CPUID_HAS_ACE () {	0x40;}
}
unless(defined(&C3_CPUID_DO_ACE)) {
    sub C3_CPUID_DO_ACE () {	0x80;}
}
unless(defined(&C3_CPUID_HAS_ACE2)) {
    sub C3_CPUID_HAS_ACE2 () {	0x100;}
}
unless(defined(&C3_CPUID_DO_ACE2)) {
    sub C3_CPUID_DO_ACE2 () {	0x200;}
}
unless(defined(&C3_CPUID_HAS_PHE)) {
    sub C3_CPUID_HAS_PHE () {	0x400;}
}
unless(defined(&C3_CPUID_DO_PHE)) {
    sub C3_CPUID_DO_PHE () {	0x800;}
}
unless(defined(&C3_CPUID_HAS_PMM)) {
    sub C3_CPUID_HAS_PMM () {	0x1000;}
}
unless(defined(&C3_CPUID_DO_PMM)) {
    sub C3_CPUID_DO_PMM () {	0x2000;}
}
unless(defined(&C3_CRYPT_CWLO_ROUND_M)) {
    sub C3_CRYPT_CWLO_ROUND_M () {	0xf;}
}
unless(defined(&C3_CRYPT_CWLO_ALG_M)) {
    sub C3_CRYPT_CWLO_ALG_M () {	0x70;}
}
unless(defined(&C3_CRYPT_CWLO_ALG_AES)) {
    sub C3_CRYPT_CWLO_ALG_AES () {	0x;}
}
unless(defined(&C3_CRYPT_CWLO_KEYGEN_M)) {
    sub C3_CRYPT_CWLO_KEYGEN_M () {	0x80;}
}
unless(defined(&C3_CRYPT_CWLO_KEYGEN_HW)) {
    sub C3_CRYPT_CWLO_KEYGEN_HW () {	0x;}
}
unless(defined(&C3_CRYPT_CWLO_KEYGEN_SW)) {
    sub C3_CRYPT_CWLO_KEYGEN_SW () {	0x80;}
}
unless(defined(&C3_CRYPT_CWLO_NORMAL)) {
    sub C3_CRYPT_CWLO_NORMAL () {	0x;}
}
unless(defined(&C3_CRYPT_CWLO_INTERMEDIATE)) {
    sub C3_CRYPT_CWLO_INTERMEDIATE () {	0x100;}
}
unless(defined(&C3_CRYPT_CWLO_ENCRYPT)) {
    sub C3_CRYPT_CWLO_ENCRYPT () {	0x;}
}
unless(defined(&C3_CRYPT_CWLO_DECRYPT)) {
    sub C3_CRYPT_CWLO_DECRYPT () {	0x200;}
}
unless(defined(&C3_CRYPT_CWLO_KEY128)) {
    sub C3_CRYPT_CWLO_KEY128 () {	0xa;}
}
unless(defined(&C3_CRYPT_CWLO_KEY192)) {
    sub C3_CRYPT_CWLO_KEY192 () {	0x40c;}
}
unless(defined(&C3_CRYPT_CWLO_KEY256)) {
    sub C3_CRYPT_CWLO_KEY256 () {	0x80e;}
}
1;
