require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_I386_DB_MACHDEP_H_)) {
    eval 'sub _I386_DB_MACHDEP_H_ () {1;}' unless defined(&_I386_DB_MACHDEP_H_);
    require 'sys/param.ph';
    require 'uvm/uvm_extern.ph';
    require 'machine/trap.ph';
    eval 'sub DDB_REGS () {( &ddb_regs);}' unless defined(&DDB_REGS);
    eval 'sub PC_REGS {
        my($regs) = @_;
	    eval q((( &db_addr_t)($regs)-> &tf_eip));
    }' unless defined(&PC_REGS);
    eval 'sub SET_PC_REGS {
        my($regs, $value) = @_;
	    eval q(-> &tf_eip = ($value));
    }' unless defined(&SET_PC_REGS);
    eval 'sub BKPT_INST () {0xcc;}' unless defined(&BKPT_INST);
    eval 'sub BKPT_SIZE () {(1);}' unless defined(&BKPT_SIZE);
    eval 'sub BKPT_SET {
        my($inst) = @_;
	    eval q(( &BKPT_INST));
    }' unless defined(&BKPT_SET);
    eval 'sub FIXUP_PC_AFTER_BREAK {
        my($regs) = @_;
	    eval q((($regs)-> &tf_eip -=  &BKPT_SIZE));
    }' unless defined(&FIXUP_PC_AFTER_BREAK);
    eval 'sub db_clear_single_step {
        my($regs) = @_;
	    eval q((($regs)-> &tf_eflags &= ~ &PSL_T));
    }' unless defined(&db_clear_single_step);
    eval 'sub db_set_single_step {
        my($regs) = @_;
	    eval q((($regs)-> &tf_eflags |=  &PSL_T));
    }' unless defined(&db_set_single_step);
    eval 'sub IS_BREAKPOINT_TRAP {
        my($type, $code) = @_;
	    eval q((($type) ==  &T_BPTFLT));
    }' unless defined(&IS_BREAKPOINT_TRAP);
    eval 'sub IS_WATCHPOINT_TRAP {
        my($type, $code) = @_;
	    eval q((($type) ==  &T_TRCTRAP  && ($code) & 15));
    }' unless defined(&IS_WATCHPOINT_TRAP);
    eval 'sub I_CALL () {0xe8;}' unless defined(&I_CALL);
    eval 'sub I_CALLI () {0xff;}' unless defined(&I_CALLI);
    eval 'sub I_RET () {0xc3;}' unless defined(&I_RET);
    eval 'sub I_IRET () {0xcf;}' unless defined(&I_IRET);
    eval 'sub inst_trap_return {
        my($ins) = @_;
	    eval q(((($ins)&0xff) ==  &I_IRET));
    }' unless defined(&inst_trap_return);
    eval 'sub inst_return {
        my($ins) = @_;
	    eval q(((($ins)&0xff) ==  &I_RET));
    }' unless defined(&inst_return);
    eval 'sub inst_call {
        my($ins) = @_;
	    eval q(((($ins)&0xff) ==  &I_CALL || ((($ins)&0xff) ==  &I_CALLI  && (($ins)&0x3800) == 0x1000)));
    }' unless defined(&inst_call);
    eval 'sub inst_load {
        my($ins) = @_;
	    eval q(0);
    }' unless defined(&inst_load);
    eval 'sub inst_store {
        my($ins) = @_;
	    eval q(0);
    }' unless defined(&inst_store);
    eval 'sub DB_MACHINE_COMMANDS () {1;}' unless defined(&DB_MACHINE_COMMANDS);
    eval 'sub DB_TASK_NAME {
        my($task) = @_;
	    eval q( &db_task_name($task));
    }' unless defined(&DB_TASK_NAME);
    eval 'sub DB_TASK_NAME_TITLE () {"COMMAND		";}' unless defined(&DB_TASK_NAME_TITLE);
    eval 'sub DB_TASK_NAME_LEN () {23;}' unless defined(&DB_TASK_NAME_LEN);
    eval 'sub DB_NULL_TASK_NAME () {"?		      ";}' unless defined(&DB_NULL_TASK_NAME);
    eval 'sub DB_ELF_SYMBOLS () {1;}' unless defined(&DB_ELF_SYMBOLS);
    eval 'sub DB_ELFSIZE () {32;}' unless defined(&DB_ELFSIZE);
    eval 'sub KGDB_NUMREGS () {16;}' unless defined(&KGDB_NUMREGS);
    eval 'sub KGDB_BUFLEN () {512;}' unless defined(&KGDB_BUFLEN);
    eval 'sub KGDB_ENTER () { &breakpoint();}' unless defined(&KGDB_ENTER);
    if(0) {
    }
    eval 'sub db_thread_fp_used {
        my($thread) = @_;
	    eval q((($thread)-> ($pcb->{ims}->{ifps}) != 0));
    }' unless defined(&db_thread_fp_used);
    eval 'sub DDB_STATE_NOT_RUNNING () {0;}' unless defined(&DDB_STATE_NOT_RUNNING);
    eval 'sub DDB_STATE_RUNNING () {1;}' unless defined(&DDB_STATE_RUNNING);
    eval 'sub DDB_STATE_EXITING () {2;}' unless defined(&DDB_STATE_EXITING);
}
1;
