require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_IF_ACXVAR_H)) {
    eval 'sub _IF_ACXVAR_H () {1;}' unless defined(&_IF_ACXVAR_H);
    if(defined(&ACX_DEBUG)) {
	eval 'sub DPRINTF {
	    my($x) = @_;
    	    eval q( &do {  &if ( &acxdebug)  &printf $x; }  &while (0));
	}' unless defined(&DPRINTF);
	eval 'sub DPRINTFN {
	    my($n,$x) = @_;
    	    eval q( &do {  &if ( &acxdebug >= ($n))  &printf $x; }  &while (0));
	}' unless defined(&DPRINTFN);
    } else {
	eval 'sub DPRINTF {
	    my($x) = @_;
    	    eval q();
	}' unless defined(&DPRINTF);
	eval 'sub DPRINTFN {
	    my($n,$x) = @_;
    	    eval q();
	}' unless defined(&DPRINTFN);
    }
    eval 'sub ACX_FRAME_HDRLEN () {$sizeof{\'struct ieee80211_frame\'};}' unless defined(&ACX_FRAME_HDRLEN);
    eval 'sub ACX_MEMBLOCK_SIZE () {256;}' unless defined(&ACX_MEMBLOCK_SIZE);
    eval 'sub ACX_TX_DESC_CNT () {16;}' unless defined(&ACX_TX_DESC_CNT);
    eval 'sub ACX_RX_DESC_CNT () {16;}' unless defined(&ACX_RX_DESC_CNT);
    eval 'sub ACX_TX_RING_SIZE () {(2*  &ACX_TX_DESC_CNT * $sizeof{\'struct acx_host_desc\'});}' unless defined(&ACX_TX_RING_SIZE);
    eval 'sub ACX_RX_RING_SIZE () {( &ACX_RX_DESC_CNT * $sizeof{\'struct acx_host_desc\'});}' unless defined(&ACX_RX_RING_SIZE);
    eval 'sub CSR_READ_1 {
        my($sc, $reg) = @_;
	    eval q( &bus_space_read_1(($sc)-> &sc_mem1_bt, ($sc)-> &sc_mem1_bh, ($sc)-> $chip_ioreg[($reg)]));
    }' unless defined(&CSR_READ_1);
    eval 'sub CSR_READ_2 {
        my($sc, $reg) = @_;
	    eval q( &bus_space_read_2(($sc)-> &sc_mem1_bt, ($sc)-> &sc_mem1_bh, ($sc)-> $chip_ioreg[($reg)]));
    }' unless defined(&CSR_READ_2);
    eval 'sub CSR_READ_4 {
        my($sc, $reg) = @_;
	    eval q( &bus_space_read_4(($sc)-> &sc_mem1_bt, ($sc)-> &sc_mem1_bh, ($sc)-> $chip_ioreg[($reg)]));
    }' unless defined(&CSR_READ_4);
    eval 'sub CSR_WRITE_2 {
        my($sc, $reg, $val) = @_;
	    eval q( &bus_space_write_2(($sc)-> &sc_mem1_bt, ($sc)-> &sc_mem1_bh, ($sc)-> $chip_ioreg[($reg)], $val));
    }' unless defined(&CSR_WRITE_2);
    eval 'sub CSR_WRITE_4 {
        my($sc, $reg, $val) = @_;
	    eval q( &bus_space_write_4(($sc)-> &sc_mem1_bt, ($sc)-> &sc_mem1_bh, ($sc)-> $chip_ioreg[($reg)], $val));
    }' unless defined(&CSR_WRITE_4);
    eval 'sub CSR_SETB_2 {
        my($sc, $reg, $b) = @_;
	    eval q( &CSR_WRITE_2(($sc), ($reg),  &CSR_READ_2(($sc), ($reg)) | ($b)));
    }' unless defined(&CSR_SETB_2);
    eval 'sub CSR_CLRB_2 {
        my($sc, $reg, $b) = @_;
	    eval q( &CSR_WRITE_2(($sc), ($reg),  &CSR_READ_2(($sc), ($reg)) & (~($b))));
    }' unless defined(&CSR_CLRB_2);
    eval 'sub DESC_READ_1 {
        my($sc, $off) = @_;
	    eval q( &bus_space_read_1(($sc)-> &sc_mem2_bt, ($sc)-> &sc_mem2_bh, ($off)));
    }' unless defined(&DESC_READ_1);
    eval 'sub DESC_READ_4 {
        my($sc, $off) = @_;
	    eval q( &bus_space_read_4(($sc)-> &sc_mem2_bt, ($sc)-> &sc_mem2_bh, ($off)));
    }' unless defined(&DESC_READ_4);
    eval 'sub DESC_WRITE_1 {
        my($sc, $off, $val) = @_;
	    eval q( &bus_space_write_1(($sc)-> &sc_mem2_bt, ($sc)-> &sc_mem2_bh, ($off), ($val)));
    }' unless defined(&DESC_WRITE_1);
    eval 'sub DESC_WRITE_2 {
        my($sc, $off, $val) = @_;
	    eval q( &bus_space_write_2(($sc)-> &sc_mem2_bt, ($sc)-> &sc_mem2_bh, ($off), ($val)));
    }' unless defined(&DESC_WRITE_2);
    eval 'sub DESC_WRITE_4 {
        my($sc, $off, $val) = @_;
	    eval q( &bus_space_write_4(($sc)-> &sc_mem2_bt, ($sc)-> &sc_mem2_bh, ($off), ($val)));
    }' unless defined(&DESC_WRITE_4);
    eval 'sub DESC_WRITE_REGION_1 {
        my($sc, $off, $d, $dlen) = @_;
	    eval q( &bus_space_write_region_1(($sc)-> &sc_mem2_bt, ($sc)-> &sc_mem2_bh, ($off), ( &const  &uint8_t *)($d), ($dlen)));
    }' unless defined(&DESC_WRITE_REGION_1);
    eval 'sub FW_TXDESC_SETFIELD {
        my($sc, $mb, $field, $val, $sz) = @_;
	    eval q( &DESC_WRITE_$sz(($sc), ($mb)-> &tb_fwdesc_ofs +  &offsetof(\'struct acx_fw_txdesc\', $field), ($val)));
    }' unless defined(&FW_TXDESC_SETFIELD);
    eval 'sub FW_TXDESC_GETFIELD {
        my($sc, $mb, $field, $sz) = @_;
	    eval q( &DESC_READ_$sz(($sc), ($mb)-> &tb_fwdesc_ofs +  &offsetof(\'struct acx_fw_txdesc\', $field)));
    }' unless defined(&FW_TXDESC_GETFIELD);
    eval 'sub FW_TXDESC_SETFIELD_1 {
        my($sc, $mb, $field, $val) = @_;
	    eval q( &FW_TXDESC_SETFIELD($sc, $mb, $field, $val, 1));
    }' unless defined(&FW_TXDESC_SETFIELD_1);
    eval 'sub FW_TXDESC_SETFIELD_2 {
        my($sc, $mb, $field, $val) = @_;
	    eval q( &FW_TXDESC_SETFIELD($sc, $mb, $field,  &htole16($val), 2));
    }' unless defined(&FW_TXDESC_SETFIELD_2);
    eval 'sub FW_TXDESC_SETFIELD_4 {
        my($sc, $mb, $field, $val) = @_;
	    eval q( &FW_TXDESC_SETFIELD($sc, $mb, $field,  &htole32($val), 4));
    }' unless defined(&FW_TXDESC_SETFIELD_4);
    eval 'sub FW_TXDESC_GETFIELD_1 {
        my($sc, $mb, $field) = @_;
	    eval q( &FW_TXDESC_GETFIELD($sc, $mb, $field, 1));
    }' unless defined(&FW_TXDESC_GETFIELD_1);
    eval 'sub FW_TXDESC_GETFIELD_4 {
        my($sc, $mb, $field) = @_;
	    eval q( &letoh32( &FW_TXDESC_GETFIELD($sc, $mb, $field, 4)));
    }' unless defined(&FW_TXDESC_GETFIELD_4);
    eval 'sub f_tx_rate100 () { ($u->{r1}->{rate100});}' unless defined(&f_tx_rate100);
    eval 'sub f_tx_queue_ctrl () { ($u->{r1}->{queue_ctrl});}' unless defined(&f_tx_queue_ctrl);
    eval 'sub f_tx_rate111 () { ($u->{r2}->{rate111});}' unless defined(&f_tx_rate111);
    eval 'sub DESC_STATUS_FULL () {0x80000000;}' unless defined(&DESC_STATUS_FULL);
    eval 'sub DESC_CTRL_SHORT_PREAMBLE () {0x1;}' unless defined(&DESC_CTRL_SHORT_PREAMBLE);
    eval 'sub DESC_CTRL_FIRST_FRAG () {0x2;}' unless defined(&DESC_CTRL_FIRST_FRAG);
    eval 'sub DESC_CTRL_AUTODMA () {0x4;}' unless defined(&DESC_CTRL_AUTODMA);
    eval 'sub DESC_CTRL_RECLAIM () {0x8;}' unless defined(&DESC_CTRL_RECLAIM);
    eval 'sub DESC_CTRL_HOSTDONE () {0x20;}' unless defined(&DESC_CTRL_HOSTDONE);
    eval 'sub DESC_CTRL_ACXDONE () {0x40;}' unless defined(&DESC_CTRL_ACXDONE);
    eval 'sub DESC_CTRL_HOSTOWN () {0x80;}' unless defined(&DESC_CTRL_HOSTOWN);
    eval 'sub DESC_ERR_OTHER_FRAG () {0x1;}' unless defined(&DESC_ERR_OTHER_FRAG);
    eval 'sub DESC_ERR_ABORT () {0x2;}' unless defined(&DESC_ERR_ABORT);
    eval 'sub DESC_ERR_PARAM () {0x4;}' unless defined(&DESC_ERR_PARAM);
    eval 'sub DESC_ERR_NO_WEPKEY () {0x8;}' unless defined(&DESC_ERR_NO_WEPKEY);
    eval 'sub DESC_ERR_MSDU_TIMEOUT () {0x10;}' unless defined(&DESC_ERR_MSDU_TIMEOUT);
    eval 'sub DESC_ERR_EXCESSIVE_RETRY () {0x20;}' unless defined(&DESC_ERR_EXCESSIVE_RETRY);
    eval 'sub DESC_ERR_BUF_OVERFLOW () {0x40;}' unless defined(&DESC_ERR_BUF_OVERFLOW);
    eval 'sub DESC_ERR_DMA () {0x80;}' unless defined(&DESC_ERR_DMA);
    eval 'sub ACX_RXBUF_LEN_MASK () {0xfff;}' unless defined(&ACX_RXBUF_LEN_MASK);
    eval 'sub ACX_RXBUF_STAT_LNA () {0x80;}' unless defined(&ACX_RXBUF_STAT_LNA);
    eval 'sub ACX_RX_RADIOTAP_PRESENT () {((1<<  &IEEE80211_RADIOTAP_FLAGS) | (1<<  &IEEE80211_RADIOTAP_CHANNEL) | (1<<  &IEEE80211_RADIOTAP_RSSI));}' unless defined(&ACX_RX_RADIOTAP_PRESENT);
    eval 'sub ACX_TX_RADIOTAP_PRESENT () {((1<<  &IEEE80211_RADIOTAP_FLAGS) | (1<<  &IEEE80211_RADIOTAP_RATE) | (1<<  &IEEE80211_RADIOTAP_CHANNEL));}' unless defined(&ACX_TX_RADIOTAP_PRESENT);
    if((defined(&NBPFILTER) ? &NBPFILTER : 0) > 0) {
	eval 'sub sc_rxtap () { ($sc_rxtapu->{th});}' unless defined(&sc_rxtap);
	eval 'sub sc_txtap () { ($sc_txtapu->{th});}' unless defined(&sc_txtap);
    }
    eval 'sub ACX_FLAG_FW_LOADED () {0x1;}' unless defined(&ACX_FLAG_FW_LOADED);
    eval 'sub ACX_FLAG_ACX111 () {0x2;}' unless defined(&ACX_FLAG_ACX111);
    eval 'sub ACX_RADIO_TYPE_MAXIM () {0xd;}' unless defined(&ACX_RADIO_TYPE_MAXIM);
    eval 'sub ACX_RADIO_TYPE_RFMD () {0x11;}' unless defined(&ACX_RADIO_TYPE_RFMD);
    eval 'sub ACX_RADIO_TYPE_RALINK () {0x15;}' unless defined(&ACX_RADIO_TYPE_RALINK);
    eval 'sub ACX_RADIO_TYPE_RADIA () {0x16;}' unless defined(&ACX_RADIO_TYPE_RADIA);
    eval 'sub ACX_RADIO_TYPE_UNKN17 () {0x17;}' unless defined(&ACX_RADIO_TYPE_UNKN17);
    eval 'sub ACX_RADIO_TYPE_UNKN19 () {0x19;}' unless defined(&ACX_RADIO_TYPE_UNKN19);
    eval 'sub ACX_RADIO_RSSI_MAXIM () {120;}' unless defined(&ACX_RADIO_RSSI_MAXIM);
    eval 'sub ACX_RADIO_RSSI_RFMD () {215;}' unless defined(&ACX_RADIO_RSSI_RFMD);
    eval 'sub ACX_RADIO_RSSI_RALINK () {0;}' unless defined(&ACX_RADIO_RSSI_RALINK);
    eval 'sub ACX_RADIO_RSSI_RADIA () {78;}' unless defined(&ACX_RADIO_RSSI_RADIA);
    eval 'sub ACX_RADIO_RSSI_UNKN () {0;}' unless defined(&ACX_RADIO_RSSI_UNKN);
}
1;
