require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_SPARC64_PARAM_H_)) {
    eval 'sub _SPARC64_PARAM_H_ () {1;}' unless defined(&_SPARC64_PARAM_H_);
    eval 'sub _MACHINE () { &sparc64;}' unless defined(&_MACHINE);
    eval 'sub MACHINE () {"sparc64";}' unless defined(&MACHINE);
    eval 'sub _MACHINE_ARCH () { &sparc64;}' unless defined(&_MACHINE_ARCH);
    eval 'sub MACHINE_ARCH () {"sparc64";}' unless defined(&MACHINE_ARCH);
    eval 'sub MID_MACHINE () { &MID_SPARC64;}' unless defined(&MID_MACHINE);
    if(defined(&_KERNEL)) {
	unless(defined(&_LOCORE)) {
	    require 'machine/cpu.ph';
	}
    }
    eval 'sub ALIGNBYTES () {0xf;}' unless defined(&ALIGNBYTES);
    eval 'sub ALIGN {
        my($p) = @_;
	    eval q(((($p) +  &ALIGNBYTES) & ~ &ALIGNBYTES));
    }' unless defined(&ALIGN);
    eval 'sub ALIGN32 {
        my($p) = @_;
	    eval q(((($p) +  &ALIGNBYTES32) & ~ &ALIGNBYTES32));
    }' unless defined(&ALIGN32);
    eval 'sub ALIGNED_POINTER {
        my($p,$t) = @_;
	    eval q((((($p)) & ($sizeof{$t}-1)) == 0));
    }' unless defined(&ALIGNED_POINTER);
    if((defined( &_KERNEL) || defined( &_STANDALONE))  && !defined( &_LOCORE)) {
    }
    eval 'sub DEV_BSHIFT () {9;}' unless defined(&DEV_BSHIFT);
    eval 'sub DEV_BSIZE () {(1<<  &DEV_BSHIFT);}' unless defined(&DEV_BSIZE);
    eval 'sub BLKDEV_IOSIZE () {2048;}' unless defined(&BLKDEV_IOSIZE);
    eval 'sub MAXPHYS () {(64* 1024);}' unless defined(&MAXPHYS);
    eval 'sub UPAGES () {2;}' unless defined(&UPAGES);
    eval 'sub USPACE () {( &UPAGES*8192);}' unless defined(&USPACE);
    eval 'sub USPACE_ALIGN () {(0);}' unless defined(&USPACE_ALIGN);
    eval 'sub KERNBASE () {0x1000000;}' unless defined(&KERNBASE);
    eval 'sub KERNEND () {0xe0000000;}' unless defined(&KERNEND);
    eval 'sub VM_MAX_KERNEL_BUF () {(( &KERNEND- &KERNBASE)/4);}' unless defined(&VM_MAX_KERNEL_BUF);
    eval 'sub _MAXNBPG () {8192;}' unless defined(&_MAXNBPG);
    eval 'sub AUXREG_VA () {(  &KERNEND +  &_MAXNBPG);}' unless defined(&AUXREG_VA);
    eval 'sub TMPMAP_VA () {(  &AUXREG_VA +  &_MAXNBPG);}' unless defined(&TMPMAP_VA);
    eval 'sub MSGBUF_VA () {(  &TMPMAP_VA +  &_MAXNBPG);}' unless defined(&MSGBUF_VA);
    eval 'sub INTSTACK () {(  &KERNEND + 8* &_MAXNBPG);}' unless defined(&INTSTACK);
    eval 'sub EINTSTACK () {(  &INTSTACK + 2* &USPACE);}' unless defined(&EINTSTACK);
    eval 'sub CPUINFO_VA () {(  &EINTSTACK);}' unless defined(&CPUINFO_VA);
    eval 'sub IODEV_BASE () {(  &CPUINFO_VA + 8* &_MAXNBPG);}' unless defined(&IODEV_BASE);
    eval 'sub IODEV_END () {0xf0000000;}' unless defined(&IODEV_END);
    eval 'sub MSIZE () {256;}' unless defined(&MSIZE);
    eval 'sub MCLSHIFT () {11;}' unless defined(&MCLSHIFT);
    eval 'sub MCLBYTES () {(1<<  &MCLSHIFT);}' unless defined(&MCLBYTES);
    eval 'sub MCLOFSET () {( &MCLBYTES - 1);}' unless defined(&MCLOFSET);
    eval 'sub NMBCLUSTERS () {4096;}' unless defined(&NMBCLUSTERS);
    eval 'sub MSGBUFSIZE () { &NBPG;}' unless defined(&MSGBUFSIZE);
    eval 'sub NKMEMPAGES_MIN_DEFAULT () {((8* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MIN_DEFAULT);
    eval 'sub NKMEMPAGES_MAX_DEFAULT () {((128* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MAX_DEFAULT);
    eval 'sub ctod {
        my($x) = @_;
	    eval q((($x) << ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&ctod);
    eval 'sub dtoc {
        my($x) = @_;
	    eval q((($x) >> ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&dtoc);
    eval 'sub ctob {
        my($x) = @_;
	    eval q((($x) <<  &PGSHIFT));
    }' unless defined(&ctob);
    eval 'sub btoc {
        my($x) = @_;
	    eval q(((( &vsize_t)($x) +  &PGOFSET) >>  &PGSHIFT));
    }' unless defined(&btoc);
    eval 'sub btodb {
        my($x) = @_;
	    eval q((($x) >>  &DEV_BSHIFT));
    }' unless defined(&btodb);
    eval 'sub dbtob {
        my($x) = @_;
	    eval q((($x) <<  &DEV_BSHIFT));
    }' unless defined(&dbtob);
    if(defined(&_KERNEL)) {
	unless(defined(&_LOCORE)) {
	    eval 'sub DELAY {
	        my($n) = @_;
    		eval q( &delay($n));
	    }' unless defined(&DELAY);
	}
    }
    eval 'sub CPU_SUN4 () {0;}' unless defined(&CPU_SUN4);
    eval 'sub CPU_SUN4C () {1;}' unless defined(&CPU_SUN4C);
    eval 'sub CPU_SUN4M () {2;}' unless defined(&CPU_SUN4M);
    eval 'sub CPU_SUN4U () {3;}' unless defined(&CPU_SUN4U);
    eval 'sub CPU_ISSUN4U () {(1);}' unless defined(&CPU_ISSUN4U);
    eval 'sub CPU_ISSUN4MOR4U () {(1);}' unless defined(&CPU_ISSUN4MOR4U);
    eval 'sub CPU_ISSUN4M () {(0);}' unless defined(&CPU_ISSUN4M);
    eval 'sub CPU_ISSUN4C () {(0);}' unless defined(&CPU_ISSUN4C);
    eval 'sub CPU_ISSUN4 () {(0);}' unless defined(&CPU_ISSUN4);
    eval 'sub CPU_ISSUN4OR4C () {(0);}' unless defined(&CPU_ISSUN4OR4C);
    eval 'sub CPU_ISSUN4COR4M () {(0);}' unless defined(&CPU_ISSUN4COR4M);
    eval 'sub NBPG () {8192;}' unless defined(&NBPG);
    eval 'sub PGOFSET () {( &NBPG-1);}' unless defined(&PGOFSET);
    eval 'sub PGSHIFT () {13;}' unless defined(&PGSHIFT);
    eval 'sub PAGE_SHIFT () {13;}' unless defined(&PAGE_SHIFT);
    eval 'sub PAGE_SIZE () {(1<<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
}
1;
