require '_h2ph_pre.ph';

no warnings 'redefine';

require 'dev/ic/ramdac.ph';
require 'dev/pci/tgareg.ph';
require 'dev/wscons/wsconsio.ph';
require 'dev/wscons/wscons_raster.ph';
require 'dev/wscons/wsdisplayvar.ph';
require 'dev/rasops/rasops.ph';
unless(defined(&TGA_TYPE_T8_01)) {
    sub TGA_TYPE_T8_01 () {	0;}
}
unless(defined(&TGA_TYPE_T8_02)) {
    sub TGA_TYPE_T8_02 () {	1;}
}
unless(defined(&TGA_TYPE_T8_22)) {
    sub TGA_TYPE_T8_22 () {	2;}
}
unless(defined(&TGA_TYPE_T8_44)) {
    sub TGA_TYPE_T8_44 () {	3;}
}
unless(defined(&TGA_TYPE_T32_04)) {
    sub TGA_TYPE_T32_04 () {	4;}
}
unless(defined(&TGA_TYPE_T32_08)) {
    sub TGA_TYPE_T32_08 () {	5;}
}
unless(defined(&TGA_TYPE_T32_88)) {
    sub TGA_TYPE_T32_88 () {	6;}
}
unless(defined(&TGA_TYPE_POWERSTORM_4D20)) {
    sub TGA_TYPE_POWERSTORM_4D20 () {	7;}
}
unless(defined(&TGA_TYPE_UNKNOWN)) {
    sub TGA_TYPE_UNKNOWN () {	8;}
}
unless(defined(&DEVICE_IS_TGA)) {
    sub DEVICE_IS_TGA {
	my($class, $id) = @_;
	eval q(((( &PCI_VENDOR($id) ==  &PCI_VENDOR_DEC  &&  &PCI_PRODUCT($id) ==  &PCI_PRODUCT_DEC_21030) ||  &PCI_PRODUCT($id) ==  &PCI_PRODUCT_DEC_PBXGB) ? 10: 0));
    }
}
unless(defined(&TGARREG)) {
    sub TGARREG {
	my($dc,$reg) = @_;
	eval q(( &bus_space_read_4(($dc)-> &dc_memt, ($dc)-> &dc_regs, ($reg) << 2)));
    }
}
unless(defined(&TGAWREG)) {
    sub TGAWREG {
	my($dc,$reg,$val) = @_;
	eval q( &bus_space_write_4(($dc)-> &dc_memt, ($dc)-> &dc_regs, ($reg) << 2, ($val)));
    }
}
unless(defined(&TGAWALREG)) {
    sub TGAWALREG {
	my($dc,$reg,$alias,$val) = @_;
	eval q( &bus_space_write_4( ($dc)-> &dc_memt, ($dc)-> &dc_regs, (($alias) *  &TGA_CREGS_ALIAS) + (($reg) << 2), ($val)));
    }
}
unless(defined(&TGAREGWB)) {
    sub TGAREGWB {
	my($dc,$reg, $nregs) = @_;
	eval q( &bus_space_barrier( ($dc)-> &dc_memt, ($dc)-> &dc_regs, (($reg) << 2), 4* ($nregs),  &BUS_SPACE_BARRIER_WRITE));
    }
}
unless(defined(&TGAREGRB)) {
    sub TGAREGRB {
	my($dc,$reg, $nregs) = @_;
	eval q( &bus_space_barrier( ($dc)-> &dc_memt, ($dc)-> &dc_regs, (($reg) << 2), 4* ($nregs),  &BUS_SPACE_BARRIER_READ));
    }
}
unless(defined(&TGAREGRWB)) {
    sub TGAREGRWB {
	my($dc,$reg, $nregs) = @_;
	eval q( &bus_space_barrier( ($dc)-> &dc_memt, ($dc)-> &dc_regs, (($reg) << 2), 4* ($nregs),  &BUS_SPACE_BARRIER_READ |  &BUS_SPACE_BARRIER_WRITE));
    }
}
1;
