/*
    ParaGUI - crossplatform widgetset
    Copyright (C) 2000,2001  Alexander Pipelka
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.
 
    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.
 
    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
    Alexander Pipelka
    pipelka@teleweb.at
 
    Last Update:      $Author: pipelka $
    Update Date:      $Date: 2001/04/24 16:51:08 $
    Source File:      $Source: /usr/local/CVSROOT/linux/paragui/include/Attic/pgcheckbutton.h,v $
    CVS/RCS Revision: $Revision: 1.1.2.1 $
    Status:           $State: Exp $
*/

#ifndef PG_CHECKBUTTON_H
#define PG_CHECKBUTTON_H

#ifdef SWIG
%include "swigcommon.h"
%module pgcheckbutton
%{
#include "pgcheckbutton.h"
%}
#endif

#include "pgradiobutton.h"

/**
	@author Alexander Pipelka

	@short A single check button.
*/

class DECLSPEC PG_CheckButton : public PG_RadioButton {
public:

	/** */
	PG_CheckButton(PG_Widget* parent, int id, const PG_Rect& r, char* text, const char* style="CheckButton");

	/** */
	~PG_CheckButton();

	/** */
	void SetUnpressed();

protected:

	/** */
	bool eventMouseButtonUp(const SDL_MouseButtonEvent* my_widgetButton);

	/** */
	bool eventButtonClick(int id, PG_Widget* widget);
};

#endif // PG_CHECKBUTTON_H
