/*

Copyright (C) 2000, 2001 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_snap_h
#define __nd_snap_h

#include <protocols/snap/libnd_snap.h>

#include <nd.h>

#include <net/if.h>
#include <netinet/if_ether.h>

extern ND_MenuData snap_menu_type_data[]; /* See nd_snap.c */

/* These are the implementations for Ethernet of ND_Protocol's callbacks: */
GtkWidget *nd_snap_create_gui(LND_Trace *trace, LND_ProtoInfo *pinf);
void       nd_snap_set_gui(const LND_Packet *packet, LND_ProtoInfo *pinf);

/* Generic accessor function for the Ethernet Protocol implementation: */
LND_Protocol *nd_snap_get(void);
ND_Protocol  *nd_snap_get_gui(void);

/* Helper functions to set a trace's Ethernet GUI table to a packet's content: */
void       nd_snap_set_gui_ssap(LND_ProtoInfo *pinf, struct lnd_snap_header *sh);
void       nd_snap_set_gui_dsap(LND_ProtoInfo *pinf, struct lnd_snap_header *sh);
void       nd_snap_set_gui_ctrl(LND_ProtoInfo *pinf, struct lnd_snap_header *sh);
void       nd_snap_set_gui_oui(LND_ProtoInfo *pinf, struct lnd_snap_header *sh);
void       nd_snap_set_gui_proto(LND_ProtoInfo *pinf, struct lnd_snap_header *sh);

#endif
