#ifdef __cplusplus
extern "C" {
#endif

/*
    This software may only be used by you under license from AT&T Corp.
    ("AT&T").  A copy of AT&T's Source Code Agreement is available at
    AT&T's Internet website having the URL:
    <http://www.research.att.com/sw/tools/graphviz/license/source.html>
    If you received this software without first entering into a license
    with AT&T, you have an infringing copy of this software and cannot use
    it without violating AT&T's intellectual property rights.
*/


#ifndef _DEFS_H_
#define _DEFS_H_

#include "neato.h"

#ifdef __cplusplus
enum Style{regular, invisible};
struct vtx_data {
	int nedges;
	int *edges;
	float *ewgts;
	Style *styles;
};

typedef int DistType; /* must be signed!! */

inline double max(double x, double y) {
	if (x>=y)
		return x;
	else
		return y;
}

inline double min(double x, double y) {
	if (x<=y)
		return x;
	else
		return y;
}

inline int max(int x, int y) {
	if (x>=y)
		return x;
	else
		return y;
}

inline int min(int x, int y) {
	if (x<=y)
		return x;
	else
		return y;
}

struct Point {
	double x;
	double y;
	int operator==(Point other) { return x==other.x && y==other.y; }
};
#else
#define inline 
#define NOTUSED(var)      (void) var

#include <macros.h>
extern void*		gmalloc(size_t);
typedef unsigned char bool;
#define true TRUE
#define false FALSE

#ifdef USE_STYLES
typedef enum {regular, invisible}Style;
#endif
typedef struct {
	int      nedges;  /* no. of neighbors, including self */
	int*     edges;   /* edges[0..(nedges-1)] are neighbors; edges[0] is self */
	float*   ewgts;   /* preferred edge lengths */
	float*   eweights; /* edge weights */
	node_t*  np;      /* original node */
#ifdef USE_STYLES
	Style* styles;
#endif
}vtx_data ;

typedef int DistType; /* must be signed!! */

#ifdef UNUSED
typedef struct {
	double x;
	double y;
}Point ;
#endif

#endif

#endif

#ifdef __cplusplus
}
#endif
