<?php

require_once TURBA_BASE . '/lib/AbstractObject.php';

/**
 * The Turba_Object:: class provides a set of methods for dealing with
 * individual Turba objects - whether those are people, restaurants, etc.
 *
 * $Horde: turba/lib/Object.php,v 1.17.10.1 2005/04/21 11:27:04 selsky Exp $
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @author  Jon Parise <jon@csh.rit.edu>
 * @since   Turba 0.0.1
 * @package Turba
 */
class Turba_Object extends Turba_AbstractObject {

    /**
     * Constructs a new Turba_Object() object.
     *
     * @param Turba_Driver $driver  Hash describing the object Driver.
     * @param array $attributes     Hash of attributes for this object.
     */
    function Turba_Object(&$driver, $attributes = array())
    {
        parent::Turba_AbstractObject($driver, $attributes);
        $this->attributes['__type'] = 'Object';
    }

}
