/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.valve;

import javax.servlet.http.HttpServletRequest;
import org.apache.regexp.RE;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.webapp.admin.valve.ValveForm;
import org.apache.webapp.admin.valve.ValveUtil;

public final class RemoteHostValveForm
extends ValveForm {
    private String allow = "";
    private String deny = "";
    private RE[] allows = new RE[0];
    private RE[] denies = new RE[0];

    public String getAllow() {
        return this.allow;
    }

    public void setAllow(String allow) {
        this.allow = allow;
    }

    public String getDeny() {
        return this.deny;
    }

    public void setDeny(String deny) {
        this.deny = deny;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        super.reset(mapping, request);
        this.allow = null;
        this.deny = null;
        this.allows = null;
        this.denies = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("RemoteHostValveForm[adminAction=");
        sb.append(this.getAdminAction());
        sb.append("',valveType=");
        sb.append(this.getValveType());
        sb.append(",allow=");
        sb.append(this.allow);
        sb.append(",deny=");
        sb.append(this.deny);
        sb.append("',objectName='");
        sb.append(this.getObjectName());
        sb.append("]");
        return sb.toString();
    }

    public ActionErrors validate(ActionMapping mapping, HttpServletRequest request) {
        ActionErrors errors = new ActionErrors();
        String submit = request.getParameter("submit");
        if (!(this.allow != null && this.allow.length() >= 1 || this.deny != null && this.deny.length() >= 1)) {
            errors.add("allow", new ActionError("error.allow.deny.required"));
        }
        try {
            this.allows = ValveUtil.precalculate(this.allow);
        }
        catch (IllegalArgumentException e) {
            errors.add("allow", new ActionError("error.syntax"));
            return errors;
        }
        try {
            this.denies = ValveUtil.precalculate(this.deny);
        }
        catch (IllegalArgumentException e) {
            errors.add("allow", new ActionError("error.syntax"));
            return errors;
        }
        String host = request.getRemoteHost();
        String ip = request.getRemoteAddr();
        if (host == null) {
            return errors;
        }
        for (int i = 0; i < this.denies.length; ++i) {
            int j;
            if (this.denies[i].match(host)) {
                if (this.allows.length < 1) {
                    errors.add("deny", new ActionError("error.denyHost"));
                }
                for (j = 0; j < this.allows.length; ++j) {
                    if (this.allows[j].match(host)) continue;
                    errors.add("deny", new ActionError("error.denyHost"));
                }
                continue;
            }
            if (!this.denies[i].match(ip)) continue;
            if (this.allows.length < 1) {
                errors.add("deny", new ActionError("error.denyHost"));
            }
            for (j = 0; j < this.allows.length; ++j) {
                if (this.allows[j].match(ip)) continue;
                errors.add("deny", new ActionError("error.denyHost"));
            }
        }
        boolean allowMatch = true;
        if (this.allows != null && this.allows.length > 0) {
            allowMatch = false;
        }
        for (int i = 0; i < this.allows.length; ++i) {
            if (!this.allows[i].match(host)) continue;
            allowMatch = true;
        }
        if (!allowMatch) {
            errors.add("allow", new ActionError("error.allowHost"));
        }
        return errors;
    }
}

