/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.users;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.Locale;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.users.GroupForm;
import org.apache.webapp.admin.users.UserUtils;

public final class SetUpGroupAction
extends Action {
    private MBeanServer mserver = null;
    private MessageResources resources = null;

    public ActionForward perform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.mserver == null) {
            this.mserver = ((ApplicationServlet)this.getServlet()).getServer();
        }
        if (this.resources == null) {
            this.resources = this.getServlet().getResources();
        }
        HttpSession session = request.getSession();
        Locale locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        String databaseName = URLDecoder.decode(request.getParameter("databaseName"));
        try {
            request.setAttribute("rolesForm", (Object)UserUtils.getRolesForm(this.mserver, databaseName));
        }
        catch (Exception e) {
            this.getServlet().log(this.resources.getMessage(locale, "users.error.attribute.get", (Object)"roles"), (Throwable)e);
            response.sendError(500, this.resources.getMessage(locale, "users.error.attribute.get", (Object)"roles"));
            return null;
        }
        String objectName = request.getParameter("objectName");
        GroupForm groupForm = new GroupForm();
        if (objectName == null) {
            groupForm.setNodeLabel(this.resources.getMessage(locale, "users.group.newGroup"));
            groupForm.setObjectName(null);
        } else {
            groupForm.setNodeLabel(this.resources.getMessage(locale, "users.group.oldGroup"));
            groupForm.setObjectName(objectName);
            String attribute = null;
            try {
                ObjectName oname = new ObjectName(objectName);
                attribute = "groupname";
                groupForm.setGroupname((String)this.mserver.getAttribute(oname, attribute));
                attribute = "description";
                groupForm.setDescription((String)this.mserver.getAttribute(oname, attribute));
                attribute = "roles";
                groupForm.setRoles((String[])this.mserver.getAttribute(oname, attribute));
            }
            catch (Exception e) {
                this.getServlet().log(this.resources.getMessage(locale, "users.error.attribute.get", (Object)attribute), (Throwable)e);
                response.sendError(500, this.resources.getMessage(locale, "users.error.attribute.get", (Object)attribute));
                return null;
            }
        }
        groupForm.setDatabaseName(databaseName);
        this.saveToken(request);
        request.setAttribute("groupForm", (Object)groupForm);
        return mapping.findForward("Group");
    }
}

