/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.users;

import java.io.IOException;
import java.util.Locale;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.users.GroupsForm;

public final class DeleteGroupsAction
extends Action {
    private MBeanServer mserver = null;
    private MessageResources resources = null;

    public ActionForward perform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ObjectName dname;
        if (this.mserver == null) {
            this.mserver = ((ApplicationServlet)this.getServlet()).getServer();
        }
        if (this.resources == null) {
            this.resources = this.getServlet().getResources();
        }
        HttpSession session = request.getSession();
        Locale locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        if (this.isCancelled(request)) {
            return mapping.findForward("List Groups Setup");
        }
        if (!this.isTokenValid(request)) {
            response.sendError(400, this.resources.getMessage(locale, "users.error.token"));
            return null;
        }
        GroupsForm groupsForm = (GroupsForm)form;
        String databaseName = groupsForm.getDatabaseName();
        String[] groups = groupsForm.getGroups();
        if (groups == null) {
            groups = new String[]{};
        }
        try {
            dname = new ObjectName(databaseName);
            String[] signature = new String[]{"java.lang.String"};
            Object[] params = new String[1];
            for (int i = 0; i < groups.length; ++i) {
                ObjectName oname = new ObjectName(groups[i]);
                params[0] = oname.getKeyProperty("groupname");
                this.mserver.invoke(dname, "removeGroup", params, signature);
            }
        }
        catch (Throwable t) {
            this.getServlet().log(this.resources.getMessage(locale, "users.error.invoke", (Object)"removeGroup"), t);
            response.sendError(500, this.resources.getMessage(locale, "users.error.invoke", (Object)"removeGroup"));
            return null;
        }
        try {
            dname = new ObjectName(databaseName);
            this.mserver.invoke(dname, "save", new Object[0], new String[0]);
        }
        catch (Throwable t) {
            this.getServlet().log(this.resources.getMessage(locale, "users.error.invoke", (Object)"save"), t);
            response.sendError(500, this.resources.getMessage(locale, "users.error.invoke", (Object)"save"));
            return null;
        }
        return mapping.findForward("Groups List Setup");
    }
}

