/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.host;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.host.AliasForm;

public final class SaveAliasAction
extends Action {
    private String[] createStandardAliasTypes = new String[]{"java.lang.String"};
    private MBeanServer mBServer = null;
    private MessageResources resources = null;

    public ActionForward perform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session = request.getSession();
        Locale locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        if (this.resources == null) {
            this.resources = this.getServlet().getResources();
        }
        try {
            this.mBServer = ((ApplicationServlet)this.getServlet()).getServer();
        }
        catch (Throwable t) {
            throw new ServletException("Cannot acquire MBeanServer reference", t);
        }
        AliasForm aform = (AliasForm)form;
        String operation = "addAlias";
        Object[] values = new String[]{aform.getAliasName()};
        String hostName = aform.getHostName();
        List aliasVals = aform.getAliasVals();
        if (aliasVals.contains(values[0])) {
            ActionErrors errors = new ActionErrors();
            errors.add("aliasName", new ActionError("error.aliasName.exists"));
            this.saveErrors(request, errors);
            return new ActionForward(mapping.getInput());
        }
        try {
            ObjectName hname = new ObjectName(hostName);
            this.mBServer.invoke(hname, operation, values, this.createStandardAliasTypes);
        }
        catch (Throwable t) {
            this.getServlet().log(this.resources.getMessage(locale, "users.error.invoke", (Object)operation), t);
            response.sendError(500, this.resources.getMessage(locale, "users.error.invoke", (Object)operation));
            return null;
        }
        session.removeAttribute(mapping.getAttribute());
        return mapping.findForward("Save Successful");
    }
}

