/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin.defaultcontext;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Locale;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.apache.webapp.admin.ApplicationServlet;
import org.apache.webapp.admin.TomcatTreeBuilder;
import org.apache.webapp.admin.TreeControl;
import org.apache.webapp.admin.TreeControlNode;
import org.apache.webapp.admin.defaultcontext.DefaultContextForm;

public final class SaveDefaultContextAction
extends Action {
    private String[] createDefaultContextTypes = new String[]{"java.lang.String"};
    private String[] createStandardLoaderTypes = new String[]{"java.lang.String"};
    private String[] createStandardManagerTypes = new String[]{"java.lang.String"};
    private MBeanServer mBServer = null;
    private MessageResources resources = null;

    public ActionForward perform(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSession session = request.getSession();
        Locale locale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        if (this.resources == null) {
            this.resources = this.getServlet().getResources();
        }
        try {
            this.mBServer = ((ApplicationServlet)this.getServlet()).getServer();
        }
        catch (Throwable t) {
            throw new ServletException("Cannot acquire MBeanServer reference", t);
        }
        DefaultContextForm cform = (DefaultContextForm)form;
        String adminAction = cform.getAdminAction();
        String cObjectName = cform.getObjectName();
        String lObjectName = cform.getLoaderObjectName();
        String mObjectName = cform.getManagerObjectName();
        if ("Create".equals(adminAction)) {
            String operation = null;
            Object[] values = null;
            try {
                String parentName = cform.getParentObjectName();
                ObjectName poname = new ObjectName(parentName);
                String host = poname.getKeyProperty("host");
                String domain = poname.getDomain();
                ObjectName oname = null;
                oname = host != null ? new ObjectName(domain + ":type=DefaultContext" + ",host=" + host) : new ObjectName(domain + ":type=DefaultContext");
                if (this.mBServer.isRegistered(oname)) {
                    ActionErrors errors = new ActionErrors();
                    errors.add("contextName", new ActionError("error.defaultcontextName.exists"));
                    this.saveErrors(request, errors);
                    return new ActionForward(mapping.getInput());
                }
                ObjectName fname = TomcatTreeBuilder.getMBeanFactory();
                values = new Object[]{parentName};
                operation = "createDefaultContext";
                cObjectName = (String)this.mBServer.invoke(fname, operation, values, this.createDefaultContextTypes);
                values = new String[]{cObjectName.toString()};
                operation = "createWebappLoader";
                lObjectName = (String)this.mBServer.invoke(fname, operation, values, this.createStandardLoaderTypes);
                values = new String[]{cObjectName.toString()};
                operation = "createStandardManager";
                mObjectName = (String)this.mBServer.invoke(fname, operation, values, this.createStandardManagerTypes);
                this.addToTreeControlNode(oname, cObjectName, parentName, this.resources, session, locale);
            }
            catch (Exception e) {
                this.getServlet().log(this.resources.getMessage(locale, "users.error.invoke", operation), (Throwable)e);
                response.sendError(500, this.resources.getMessage(locale, "users.error.invoke", operation));
                return null;
            }
        }
        String attribute = null;
        try {
            ObjectName coname = new ObjectName(cObjectName);
            ObjectName loname = new ObjectName(lObjectName);
            ObjectName moname = new ObjectName(mObjectName);
            attribute = "cookies";
            String cookies = "false";
            try {
                cookies = cform.getCookies();
            }
            catch (Throwable t) {
                cookies = "false";
            }
            this.mBServer.setAttribute(coname, new Attribute("cookies", new Boolean(cookies)));
            attribute = "crossContext";
            String crossContext = "false";
            try {
                crossContext = cform.getCrossContext();
            }
            catch (Throwable t) {
                crossContext = "false";
            }
            this.mBServer.setAttribute(coname, new Attribute("crossContext", new Boolean(crossContext)));
            attribute = "reloadable";
            String reloadable = "false";
            try {
                reloadable = cform.getReloadable();
            }
            catch (Throwable t) {
                reloadable = "false";
            }
            this.mBServer.setAttribute(coname, new Attribute("reloadable", new Boolean(reloadable)));
            attribute = "swallowOutput";
            String swallowOutput = "false";
            try {
                swallowOutput = cform.getSwallowOutput();
            }
            catch (Throwable t) {
                swallowOutput = "false";
            }
            this.mBServer.setAttribute(coname, new Attribute("swallowOutput", new Boolean(swallowOutput)));
            attribute = "useNaming";
            String useNaming = "false";
            try {
                useNaming = cform.getUseNaming();
            }
            catch (Throwable t) {
                useNaming = "false";
            }
            this.mBServer.setAttribute(coname, new Attribute("useNaming", new Boolean(useNaming)));
            attribute = "reloadable";
            try {
                reloadable = cform.getLdrReloadable();
            }
            catch (Throwable t) {
                reloadable = "false";
            }
            this.mBServer.setAttribute(loname, new Attribute("reloadable", new Boolean(reloadable)));
            attribute = "debug";
            int debug = 0;
            try {
                debug = Integer.parseInt(cform.getLdrDebugLvl());
            }
            catch (Throwable t) {
                debug = 0;
            }
            this.mBServer.setAttribute(loname, new Attribute("debug", new Integer(debug)));
            attribute = "checkInterval";
            int checkInterval = 15;
            try {
                checkInterval = Integer.parseInt(cform.getLdrCheckInterval());
            }
            catch (Throwable t) {
                checkInterval = 15;
            }
            this.mBServer.setAttribute(loname, new Attribute("checkInterval", new Integer(checkInterval)));
            attribute = "entropy";
            String entropy = cform.getMgrSessionIDInit();
            if (entropy != null && entropy.length() >= 1) {
                this.mBServer.setAttribute(moname, new Attribute("entropy", entropy));
            }
            attribute = "debug";
            try {
                debug = Integer.parseInt(cform.getMgrDebugLvl());
            }
            catch (Throwable t) {
                debug = 0;
            }
            this.mBServer.setAttribute(moname, new Attribute("debug", new Integer(debug)));
            attribute = "checkInterval";
            try {
                checkInterval = Integer.parseInt(cform.getMgrCheckInterval());
            }
            catch (Throwable t) {
                checkInterval = 60;
            }
            this.mBServer.setAttribute(moname, new Attribute("checkInterval", new Integer(checkInterval)));
            attribute = "maxActiveSessions";
            int maxActiveSessions = -1;
            try {
                maxActiveSessions = Integer.parseInt(cform.getMgrMaxSessions());
            }
            catch (Throwable t) {
                maxActiveSessions = -1;
            }
            this.mBServer.setAttribute(moname, new Attribute("maxActiveSessions", new Integer(maxActiveSessions)));
        }
        catch (Exception e) {
            this.getServlet().log(this.resources.getMessage(locale, "users.error.attribute.set", attribute), (Throwable)e);
            response.sendError(500, this.resources.getMessage(locale, "users.error.attribute.set", (Object)attribute));
            return null;
        }
        session.removeAttribute(mapping.getAttribute());
        return mapping.findForward("Save Successful");
    }

    public void addToTreeControlNode(ObjectName oname, String containerName, String parentName, MessageResources resources, HttpSession session, Locale locale) throws Exception {
        String domain = oname.getDomain();
        TreeControl control = (TreeControl)session.getAttribute("treeControlTest");
        if (control != null) {
            TreeControlNode parentNode = control.findNode(parentName);
            if (parentNode != null) {
                String host;
                String path;
                String nodeLabel = "DefaultContext";
                String encodedName = URLEncoder.encode(oname.toString());
                TreeControlNode childNode = new TreeControlNode(oname.toString(), "DefaultContext.gif", nodeLabel, "EditDefaultContext.do?select=" + encodedName, "content", true, domain);
                parentNode.addChild(childNode);
                String type = oname.getKeyProperty("type");
                if (type == null) {
                    type = "";
                }
                if ((path = oname.getKeyProperty("path")) == null) {
                    path = "";
                }
                if ((host = oname.getKeyProperty("host")) == null) {
                    host = "";
                }
                TreeControlNode subtree = new TreeControlNode("Context Resource Administration " + containerName, "folder_16_pad.gif", resources.getMessage(locale, "resources.treeBuilder.subtreeNode"), null, "content", true, domain);
                childNode.addChild(subtree);
                TreeControlNode datasources = new TreeControlNode("Context Data Sources " + containerName, "Datasource.gif", resources.getMessage(locale, "resources.treeBuilder.datasources"), "resources/listDataSources.do?resourcetype=" + URLEncoder.encode(type) + "&path=" + URLEncoder.encode(path) + "&host=" + URLEncoder.encode(host) + "&forward=" + URLEncoder.encode("DataSources List Setup"), "content", false, domain);
                TreeControlNode mailsessions = new TreeControlNode("Context Mail Sessions " + containerName, "Mailsession.gif", resources.getMessage(locale, "resources.treeBuilder.mailsessions"), "resources/listMailSessions.do?resourcetype=" + URLEncoder.encode(type) + "&path=" + URLEncoder.encode(path) + "&host=" + URLEncoder.encode(host) + "&forward=" + URLEncoder.encode("MailSessions List Setup"), "content", false, domain);
                TreeControlNode resourcelinks = new TreeControlNode("Resource Links " + containerName, "ResourceLink.gif", resources.getMessage(locale, "resources.treeBuilder.resourcelinks"), "resources/listResourceLinks.do?resourcetype=" + URLEncoder.encode(type) + "&path=" + URLEncoder.encode(path) + "&host=" + URLEncoder.encode(host) + "&forward=" + URLEncoder.encode("ResourceLinks List Setup"), "content", false, domain);
                TreeControlNode envs = new TreeControlNode("Context Environment Entries " + containerName, "EnvironmentEntries.gif", resources.getMessage(locale, "resources.env.entries"), URLEncoder.encode(type) + "&path=" + URLEncoder.encode(path) + "&host=" + URLEncoder.encode(host) + "&forward=" + URLEncoder.encode("EnvEntries List Setup"), "content", false, domain);
                subtree.addChild(datasources);
                subtree.addChild(mailsessions);
                subtree.addChild(resourcelinks);
                subtree.addChild(envs);
            } else {
                this.getServlet().log("Cannot find parent node '" + parentName + "'");
            }
        } else {
            this.getServlet().log("Cannot find TreeControlNode!");
        }
    }
}

