/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webapp.admin;

import java.io.IOException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.beanutils.PropertyUtils;

public class AttributeTag
extends TagSupport {
    protected String attribute = null;
    protected String name = null;
    protected String property = null;
    protected String scope = null;

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public int doEndTag() throws JspException {
        Object bean = null;
        if (this.scope == null) {
            bean = this.pageContext.findAttribute(this.name);
        } else if ("page".equalsIgnoreCase(this.scope)) {
            bean = this.pageContext.getAttribute(this.name, 1);
        } else if ("request".equalsIgnoreCase(this.scope)) {
            bean = this.pageContext.getAttribute(this.name, 2);
        } else if ("session".equalsIgnoreCase(this.scope)) {
            bean = this.pageContext.getAttribute(this.name, 3);
        } else if ("application".equalsIgnoreCase(this.scope)) {
            bean = this.pageContext.getAttribute(this.name, 4);
        } else {
            throw new JspException("Invalid scope value '" + this.scope + "'");
        }
        if (bean == null) {
            throw new JspException("No bean '" + this.name + "' found");
        }
        if (this.property != null) {
            try {
                bean = PropertyUtils.getProperty((Object)bean, (String)this.property);
            }
            catch (Throwable t) {
                throw new JspException("Exception retrieving property '" + this.property + "': " + t);
            }
            if (bean == null) {
                throw new JspException("No property '" + this.property + "' found");
            }
        }
        ObjectName oname = null;
        try {
            oname = bean instanceof ObjectName ? (ObjectName)bean : (bean instanceof String ? new ObjectName((String)bean) : new ObjectName(bean.toString()));
        }
        catch (Throwable t) {
            throw new JspException("Exception creating object name for '" + bean + "': " + t);
        }
        MBeanServer mserver = (MBeanServer)this.pageContext.getAttribute("org.apache.catalina.MBeanServer", 4);
        if (mserver == null) {
            throw new JspException("MBeanServer is not available");
        }
        Object value = null;
        try {
            value = mserver.getAttribute(oname, this.attribute);
        }
        catch (Throwable t) {
            throw new JspException("Exception retrieving attribute '" + this.attribute + "'");
        }
        if (value != null) {
            JspWriter out = this.pageContext.getOut();
            try {
                out.print(value);
            }
            catch (IOException e) {
                throw new JspException("IOException: " + e);
            }
        }
        return 6;
    }

    public void release() {
        this.attribute = null;
        this.name = null;
        this.property = null;
        this.scope = null;
    }
}

