/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.io.ByteArrayInputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.apache.commons.dbcp.BasicDataSource;

public class BasicDataSourceFactory
implements ObjectFactory {
    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        if (obj == null || !(obj instanceof Reference)) {
            return null;
        }
        Reference ref = (Reference)obj;
        if (!"javax.sql.DataSource".equals(ref.getClassName())) {
            return null;
        }
        BasicDataSource dataSource = new BasicDataSource();
        RefAddr ra = null;
        ra = ref.get("defaultAutoCommit");
        if (ra != null) {
            dataSource.setDefaultAutoCommit(Boolean.valueOf(ra.getContent().toString()));
        }
        if ((ra = ref.get("defaultReadOnly")) != null) {
            dataSource.setDefaultReadOnly(Boolean.valueOf(ra.getContent().toString()));
        }
        if ((ra = ref.get("defaultTransactionIsolation")) != null) {
            String value = ra.getContent().toString();
            int level = -1;
            if ("NONE".equalsIgnoreCase(value)) {
                level = 0;
            } else if ("READ_COMMITTED".equalsIgnoreCase(value)) {
                level = 2;
            } else if ("READ_UNCOMMITTED".equalsIgnoreCase(value)) {
                level = 1;
            } else if ("REPEATABLE_READ".equalsIgnoreCase(value)) {
                level = 4;
            } else if ("SERIALIZABLE".equalsIgnoreCase(value)) {
                level = 8;
            } else {
                try {
                    level = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    System.err.println("Could not parse defaultTransactionIsolation: " + value);
                    System.err.println("WARNING: defaultTransactionIsolation not set");
                    System.err.println("using default value of database driver");
                    level = -1;
                }
            }
            dataSource.setDefaultTransactionIsolation(level);
        }
        if ((ra = ref.get("defaultCatalog")) != null) {
            dataSource.setDefaultCatalog(ra.getContent().toString());
        }
        if ((ra = ref.get("driverClassName")) != null) {
            dataSource.setDriverClassName(ra.getContent().toString());
        }
        if ((ra = ref.get("maxActive")) != null) {
            dataSource.setMaxActive(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("maxIdle")) != null) {
            dataSource.setMaxIdle(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("minIdle")) != null) {
            dataSource.setMinIdle(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("maxWait")) != null) {
            dataSource.setMaxWait(Long.parseLong(ra.getContent().toString()));
        }
        if ((ra = ref.get("testOnBorrow")) != null) {
            dataSource.setTestOnBorrow(Boolean.valueOf(ra.getContent().toString()));
        }
        if ((ra = ref.get("testOnReturn")) != null) {
            dataSource.setTestOnReturn(Boolean.valueOf(ra.getContent().toString()));
        }
        if ((ra = ref.get("timeBetweenEvictionRunsMillis")) != null) {
            dataSource.setTimeBetweenEvictionRunsMillis(Long.parseLong(ra.getContent().toString()));
        }
        if ((ra = ref.get("numTestsPerEvictionRun")) != null) {
            dataSource.setNumTestsPerEvictionRun(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("minEvictableIdleTimeMillis")) != null) {
            dataSource.setMinEvictableIdleTimeMillis(Long.parseLong(ra.getContent().toString()));
        }
        if ((ra = ref.get("testWhileIdle")) != null) {
            dataSource.setTestWhileIdle(Boolean.valueOf(ra.getContent().toString()));
        }
        if ((ra = ref.get("password")) != null) {
            dataSource.setPassword(ra.getContent().toString());
        }
        if ((ra = ref.get("url")) != null) {
            dataSource.setUrl(ra.getContent().toString());
        }
        if ((ra = ref.get("username")) != null) {
            dataSource.setUsername(ra.getContent().toString());
        }
        if ((ra = ref.get("validationQuery")) != null) {
            dataSource.setValidationQuery(ra.getContent().toString());
        }
        if ((ra = ref.get("accessToUnderlyingConnectionAllowed")) != null) {
            dataSource.setAccessToUnderlyingConnectionAllowed(Boolean.valueOf(ra.getContent().toString()));
        }
        if ((ra = ref.get("removeAbandoned")) != null) {
            dataSource.setRemoveAbandoned(Boolean.valueOf(ra.getContent().toString()));
        }
        if ((ra = ref.get("removeAbandonedTimeout")) != null) {
            dataSource.setRemoveAbandonedTimeout(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("logAbandoned")) != null) {
            dataSource.setLogAbandoned(Boolean.valueOf(ra.getContent().toString()));
        }
        if ((ra = ref.get("poolPreparedStatements")) != null) {
            dataSource.setPoolPreparedStatements(Boolean.valueOf(ra.getContent().toString()));
        }
        if ((ra = ref.get("maxOpenPreparedStatements")) != null) {
            dataSource.setMaxOpenPreparedStatements(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("connectionProperties")) != null) {
            Properties p = BasicDataSourceFactory.getProperties(ra.getContent().toString());
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String propertyName = (String)e.nextElement();
                dataSource.addConnectionProperty(propertyName, p.getProperty(propertyName));
            }
        }
        return dataSource;
    }

    private static Properties getProperties(String propText) throws Exception {
        Properties p = new Properties();
        if (propText != null) {
            p.load(new ByteArrayInputStream(propText.replace(';', '\n').getBytes()));
        }
        return p;
    }
}

