-module(megaco_text_parser_v1).
-export([parse/1, parse_and_scan/1, format_error/1]).
-file("megaco_text_parser_v1.yrl", 1288).

%% The following directive is needed for (significantly) faster compilation
%% of the generated .erl file by the HiPE compiler.  Please do not remove.
-compile([{hipe,[{regalloc,linear_scan}]}]).

-include("megaco_text_parser_v1.hrl").

%i(F) ->
%    i(F, []).

%i(F, A) ->
%    i(get(dbg), F, A).

%i(true, F, A) ->
%    io:format("DBG:~p:" ++ F ++ "~n", [?MODULE|A]);
%i(_, _, _) ->
%    ok.


-file("/usr/obj/ports/erlang-11b.0/otp_src_R11B-0/bootstrap/lib/parsetools/include/yeccpre.hrl", 0).
%% ``The contents of this file are subject to the Erlang Public License,
%% Version 1.1, (the "License"); you may not use this file except in
%% compliance with the License. You should have received a copy of the
%% Erlang Public License along with this software. If not, it can be
%% retrieved via the world wide web at http://www.erlang.org/.
%% 
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%% 
%% The Initial Developer of the Original Code is Ericsson Utvecklings AB.
%% Portions created by Ericsson are Copyright 1999, Ericsson Utvecklings
%% AB. All Rights Reserved.''
%% 
%%     $Id $
%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% The parser generator will insert appropriate declarations before this line.%

parse(Tokens) ->
    yeccpars0(Tokens, false).

parse_and_scan({F, A}) -> % Fun or {M, F}
    yeccpars0([], {F, A});
parse_and_scan({M, F, A}) ->
    yeccpars0([], {{M, F}, A}).

format_error(Message) ->
    case io_lib:deep_char_list(Message) of
	true ->
	    Message;
	_ ->
	    io_lib:write(Message)
    end.

% To be used in grammar files to throw an error message to the parser
% toplevel. Doesn't have to be exported!
-compile({nowarn_unused_function,{return_error,2}}).
return_error(Line, Message) ->
    throw({error, {Line, ?MODULE, Message}}).

yeccpars0(Tokens, MFA) ->
    try yeccpars1(Tokens, MFA, 0, [], [])
    catch 
        throw: {error, {_Line, ?MODULE, _M}} = Error -> 
                   Error % probably from return_error/1
    end.

% Don't change yeccpars1/6 too much, it is called recursively by yeccpars2/8!
yeccpars1([Token | Tokens], Tokenizer, State, States, Vstack) ->
    yeccpars2(State, element(1, Token), States, Vstack, Token, Tokens,
	      Tokenizer);
yeccpars1([], {F, A}, State, States, Vstack) ->
    case apply(F, A) of
        {ok, Tokens, _Endline} ->
	    yeccpars1(Tokens, {F, A}, State, States, Vstack);
        {eof, _Endline} ->
            yeccpars1([], false, State, States, Vstack);
        {error, Descriptor, _Endline} ->
            {error, Descriptor}
    end;
yeccpars1([], false, State, States, Vstack) ->
    yeccpars2(State, '$end', States, Vstack, {'$end', 999999}, [], false).

% For internal use only.
yeccerror(Token) ->
    {error,
     {element(2, Token), ?MODULE,
      ["syntax error before: ", yecctoken2string(Token)]}}.

yecctoken2string({atom, _, A}) -> io_lib:write(A);
yecctoken2string({integer,_,N}) -> io_lib:write(N);
yecctoken2string({float,_,F}) -> io_lib:write(F);
yecctoken2string({char,_,C}) -> io_lib:write_char(C);
yecctoken2string({var,_,V}) -> io_lib:format('~s', [V]);
yecctoken2string({string,_,S}) -> io_lib:write_string(S);
yecctoken2string({reserved_symbol, _, A}) -> io_lib:format('~w', [A]);
yecctoken2string({_Cat, _, Val}) -> io_lib:format('~w', [Val]);
yecctoken2string({'dot', _}) -> io_lib:format('~w', ['.']);
yecctoken2string({'$end', _}) ->
    [];
yecctoken2string({Other, _}) when is_atom(Other) ->
    io_lib:format('~w', [Other]);
yecctoken2string(Other) ->
    io_lib:write(Other).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



-file("megaco_text_parser_v1.erl", 116).

yeccpars2(0, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [0 | __Ss], [__T | __Stack]);
yeccpars2(0, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_0_(__Stack),
 yeccpars2(1, __Cat, [0 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(1, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 5, [1 | __Ss], [__T | __Stack]);
yeccpars2(1, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_1_(__Stack),
 yeccpars2(4, __Cat, [1 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(2, '$end', _, __Stack, _, _, _) ->
 {ok, hd(__Stack)};
yeccpars2(2, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(3, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_3_(__Stack),
 yeccpars2(yeccgoto(optSep, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(4, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [4 | __Ss], [__T | __Stack]);
yeccpars2(4, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(5, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 6, [5 | __Ss], [__T | __Stack]);
yeccpars2(5, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(6, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [6 | __Ss], [__T | __Stack]);
yeccpars2(6, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(7, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 102, [7 | __Ss], [__T | __Stack]);
yeccpars2(7, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(8, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_8_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(9, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_9_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(10, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_10_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(11, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_11_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(12, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_12_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(13, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_13_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(14, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_14_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(15, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_15_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(16, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_16_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(17, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_17_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(18, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_18_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(19, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_19_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(20, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_20_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(21, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_21_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(22, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_22_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(23, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_23_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(24, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_24_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(25, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_25_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(26, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_26_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(27, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_27_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(28, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_28_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(29, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_29_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(30, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_30_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(31, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_31_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(32, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_32_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(33, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_33_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(34, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_34_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(35, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_35_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(36, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_36_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(37, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_37_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(38, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_38_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(39, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_39_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(40, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_40_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(41, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_41_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(42, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_42_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(43, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_43_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(44, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_44_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(45, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_45_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(46, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_46_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(47, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_47_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(48, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_48_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(49, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_49_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(50, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_50_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(51, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_51_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(52, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_52_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(53, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_53_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(54, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_54_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(55, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_55_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(56, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_56_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(57, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_57_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(58, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_58_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(59, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_59_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(60, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_60_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(61, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_61_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(62, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_62_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(63, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_63_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(64, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_64_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(65, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_65_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(66, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_66_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(67, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_67_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(68, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_68_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(69, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_69_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(70, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_70_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(71, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_71_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(72, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_72_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(73, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_73_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(74, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_74_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(75, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_75_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(76, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_76_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(77, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_77_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(78, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_78_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(79, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_79_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(80, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_80_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(81, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_81_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(82, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_82_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(83, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_83_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(84, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_84_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(85, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_85_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(86, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_86_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(87, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_87_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(88, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_88_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(89, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_89_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(90, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_90_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(91, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_91_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(92, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_92_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(93, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_93_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(94, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_94_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(95, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_95_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(96, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_96_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(97, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_97_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(98, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_98_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(99, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_99_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(100, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_100_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(101, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_101_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(102, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [102 | __Ss], [__T | __Stack]);
yeccpars2(102, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(103, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 104, [103 | __Ss], [__T | __Stack]);
yeccpars2(103, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(104, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [104 | __Ss], [__T | __Stack]);
yeccpars2(104, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(105, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [105 | __Ss], [__T | __Stack]);
yeccpars2(105, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_105_(__Stack),
 yeccpars2(106, __Cat, [105 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(106, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_106_(__Stack),
 __Nss = lists:nthtail(7, __Ss),
 yeccpars2(yeccgoto(authenticationHeader, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(107, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 114, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 115, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [107 | __Ss], [__T | __Stack]);
yeccpars2(107, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_107_(__Stack),
 yeccpars2(110, __Cat, [107 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(108, endOfMessage, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 109, [108 | __Ss], [__T | __Stack]);
yeccpars2(108, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(109, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_109_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(megacoMessage, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(110, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'MtpAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 784, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [110 | __Ss], [__T | __Stack]);
yeccpars2(110, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(111, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 139, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 140, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 141, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 142, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 143, [111 | __Ss], [__T | __Stack]);
yeccpars2(111, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(112, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(mId, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(113, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(mId, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(114, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [114 | __Ss], [__T | __Stack]);
yeccpars2(114, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(115, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 118, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [115 | __Ss], [__T | __Stack]);
yeccpars2(115, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_115_(__Stack),
 yeccpars2(117, __Cat, [115 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(116, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 118, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [116 | __Ss], [__T | __Stack]);
yeccpars2(116, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_116_(__Stack),
 yeccpars2(125, __Cat, [116 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(117, 'RSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 120, [117 | __Ss], [__T | __Stack]);
yeccpars2(117, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(118, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 118, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [118 | __Ss], [__T | __Stack]);
yeccpars2(118, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_118_(__Stack),
 yeccpars2(119, __Cat, [118 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(119, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_119_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(daddr, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(120, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 121, [120 | __Ss], [__T | __Stack]);
yeccpars2(120, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_120_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(domainAddress, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(121, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [121 | __Ss], [__T | __Stack]);
yeccpars2(121, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(122, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_122_(__Stack),
 yeccpars2(yeccgoto(portNumber, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(123, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [123 | __Ss], [__T | __Stack]);
yeccpars2(123, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_123_(__Stack),
 yeccpars2(124, __Cat, [123 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(124, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_124_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(domainAddress, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(125, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_125_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(daddr, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(126, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 127, [126 | __Ss], [__T | __Stack]);
yeccpars2(126, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(127, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 128, [127 | __Ss], [__T | __Stack]);
yeccpars2(127, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_127_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(domainName, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(128, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [128 | __Ss], [__T | __Stack]);
yeccpars2(128, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(129, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [129 | __Ss], [__T | __Stack]);
yeccpars2(129, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_129_(__Stack),
 yeccpars2(130, __Cat, [129 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(130, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_130_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(domainName, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(131, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_131_(__Stack),
 yeccpars2(yeccgoto(transactionItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(132, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_132_(__Stack),
 yeccpars2(yeccgoto(transactionItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(133, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_133_(__Stack),
 yeccpars2(yeccgoto(transactionItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(134, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_134_(__Stack),
 yeccpars2(yeccgoto(transactionItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(135, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_135_(__Stack),
 yeccpars2(yeccgoto(messageBody, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(136, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 140, [136 | __Ss], [__T | __Stack]);
yeccpars2(136, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 141, [136 | __Ss], [__T | __Stack]);
yeccpars2(136, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 142, [136 | __Ss], [__T | __Stack]);
yeccpars2(136, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 143, [136 | __Ss], [__T | __Stack]);
yeccpars2(136, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_136_(__Stack),
 yeccpars2(yeccgoto(transactionList, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(137, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_137_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(message, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(138, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_138_(__Stack),
 yeccpars2(yeccgoto(messageBody, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(139, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 702, [139 | __Ss], [__T | __Stack]);
yeccpars2(139, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(140, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 775, [140 | __Ss], [__T | __Stack]);
yeccpars2(140, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(141, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 632, [141 | __Ss], [__T | __Stack]);
yeccpars2(141, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(142, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 624, [142 | __Ss], [__T | __Stack]);
yeccpars2(142, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(143, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 144, [143 | __Ss], [__T | __Stack]);
yeccpars2(143, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 145, [143 | __Ss], [__T | __Stack]);
yeccpars2(143, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(144, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 616, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [144 | __Ss], [__T | __Stack]);
yeccpars2(144, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(145, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 147, [145 | __Ss], [__T | __Stack]);
yeccpars2(145, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(146, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 610, [146 | __Ss], [__T | __Stack]);
yeccpars2(146, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_146_(__Stack),
 yeccpars2(609, __Cat, [146 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(147, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 148, [147 | __Ss], [__T | __Stack]);
yeccpars2(147, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(148, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [148 | __Ss], [__T | __Stack]);
yeccpars2(148, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(149, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_149_(__Stack),
 yeccpars2(yeccgoto(contextID, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(150, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 151, [150 | __Ss], [__T | __Stack]);
yeccpars2(150, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(151, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 164, [151 | __Ss], [__T | __Stack]);
yeccpars2(151, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 165, [151 | __Ss], [__T | __Stack]);
yeccpars2(151, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 166, [151 | __Ss], [__T | __Stack]);
yeccpars2(151, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 167, [151 | __Ss], [__T | __Stack]);
yeccpars2(151, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 168, [151 | __Ss], [__T | __Stack]);
yeccpars2(151, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 169, [151 | __Ss], [__T | __Stack]);
yeccpars2(151, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 170, [151 | __Ss], [__T | __Stack]);
yeccpars2(151, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 171, [151 | __Ss], [__T | __Stack]);
yeccpars2(151, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 172, [151 | __Ss], [__T | __Stack]);
yeccpars2(151, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 173, [151 | __Ss], [__T | __Stack]);
yeccpars2(151, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 174, [151 | __Ss], [__T | __Stack]);
yeccpars2(151, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 175, [151 | __Ss], [__T | __Stack]);
yeccpars2(151, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(152, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_152_(__Stack),
 yeccpars2(yeccgoto(contextProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(153, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(commandRequest, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(154, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(commandRequest, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(155, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_155_(__Stack),
 yeccpars2(yeccgoto(contextProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(156, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(commandRequest, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(157, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(actionRequestItem, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(158, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(actionRequestItem, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(159, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(actionRequestItem, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(160, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(commandRequest, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(161, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 355, [161 | __Ss], [__T | __Stack]);
yeccpars2(161, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(162, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(commandRequest, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(163, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 351, [163 | __Ss], [__T | __Stack]);
yeccpars2(163, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_163_(__Stack),
 yeccpars2(350, __Cat, [163 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(164, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_164_(__Stack),
 yeccpars2(yeccgoto(ammToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(165, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 347, [165 | __Ss], [__T | __Stack]);
yeccpars2(165, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(166, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 344, [166 | __Ss], [__T | __Stack]);
yeccpars2(166, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(167, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 334, [167 | __Ss], [__T | __Stack]);
yeccpars2(167, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(168, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_168_(__Stack),
 yeccpars2(yeccgoto(contextProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(169, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_169_(__Stack),
 yeccpars2(yeccgoto(ammToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(170, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_170_(__Stack),
 yeccpars2(yeccgoto(ammToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(171, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 295, [171 | __Ss], [__T | __Stack]);
yeccpars2(171, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(172, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 293, [172 | __Ss], [__T | __Stack]);
yeccpars2(172, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(173, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 220, [173 | __Ss], [__T | __Stack]);
yeccpars2(173, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(174, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 194, [174 | __Ss], [__T | __Stack]);
yeccpars2(174, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(175, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 176, [175 | __Ss], [__T | __Stack]);
yeccpars2(175, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(176, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [176 | __Ss], [__T | __Stack]);
yeccpars2(176, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(177, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 190, [177 | __Ss], [__T | __Stack]);
yeccpars2(177, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_177_(__Stack),
 yeccpars2(189, __Cat, [177 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(178, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(terminationA, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(179, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 181, [179 | __Ss], [__T | __Stack]);
yeccpars2(179, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(180, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_180_(__Stack),
 yeccpars2(yeccgoto(terminationID, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(181, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [181 | __Ss], [__T | __Stack]);
yeccpars2(181, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(182, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(terminationB, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(183, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 184, [183 | __Ss], [__T | __Stack]);
yeccpars2(183, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(184, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 186, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 187, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 188, [184 | __Ss], [__T | __Stack]);
yeccpars2(184, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(185, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_185_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(topologyTriple, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(186, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_186_(__Stack),
 yeccpars2(yeccgoto(topologyDirection, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(187, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_187_(__Stack),
 yeccpars2(yeccgoto(topologyDirection, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(188, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_188_(__Stack),
 yeccpars2(yeccgoto(topologyDirection, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(189, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 193, [189 | __Ss], [__T | __Stack]);
yeccpars2(189, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(190, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [190 | __Ss], [__T | __Stack]);
yeccpars2(190, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(191, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 190, [191 | __Ss], [__T | __Stack]);
yeccpars2(191, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_191_(__Stack),
 yeccpars2(192, __Cat, [191 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(192, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_192_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(topologyTripleList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(193, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_193_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(topologyDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(194, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [194 | __Ss], [__T | __Stack]);
yeccpars2(194, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(195, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 197, [195 | __Ss], [__T | __Stack]);
yeccpars2(195, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_195_(__Stack),
 yeccpars2(196, __Cat, [195 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(196, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_196_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(subtractRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(197, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 199, [197 | __Ss], [__T | __Stack]);
yeccpars2(197, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(198, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 219, [198 | __Ss], [__T | __Stack]);
yeccpars2(198, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(199, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 200, [199 | __Ss], [__T | __Stack]);
yeccpars2(199, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(200, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 204, [200 | __Ss], [__T | __Stack]);
yeccpars2(200, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 205, [200 | __Ss], [__T | __Stack]);
yeccpars2(200, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 206, [200 | __Ss], [__T | __Stack]);
yeccpars2(200, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 207, [200 | __Ss], [__T | __Stack]);
yeccpars2(200, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 208, [200 | __Ss], [__T | __Stack]);
yeccpars2(200, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 209, [200 | __Ss], [__T | __Stack]);
yeccpars2(200, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 210, [200 | __Ss], [__T | __Stack]);
yeccpars2(200, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 211, [200 | __Ss], [__T | __Stack]);
yeccpars2(200, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 212, [200 | __Ss], [__T | __Stack]);
yeccpars2(200, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 213, [200 | __Ss], [__T | __Stack]);
yeccpars2(200, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_200_(__Stack),
 yeccpars2(203, __Cat, [200 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(201, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(auditItem, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(202, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 216, [202 | __Ss], [__T | __Stack]);
yeccpars2(202, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_202_(__Stack),
 yeccpars2(215, __Cat, [202 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(203, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 214, [203 | __Ss], [__T | __Stack]);
yeccpars2(203, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(204, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_204_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(205, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_205_(__Stack),
 yeccpars2(yeccgoto(auditItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(206, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_206_(__Stack),
 yeccpars2(yeccgoto(auditItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(207, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_207_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(208, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_208_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(209, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_209_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(210, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_210_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(211, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_211_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(212, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_212_(__Stack),
 yeccpars2(yeccgoto(auditItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(213, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_213_(__Stack),
 yeccpars2(yeccgoto(auditReturnItem, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(214, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_214_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(auditDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(215, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_215_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(auditDescriptorBody, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(216, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 204, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 205, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 206, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 207, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 208, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 209, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 210, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 211, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 212, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 213, [216 | __Ss], [__T | __Stack]);
yeccpars2(216, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(217, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 216, [217 | __Ss], [__T | __Stack]);
yeccpars2(217, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_217_(__Stack),
 yeccpars2(218, __Cat, [217 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(218, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_218_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(auditItemList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(219, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_219_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(optAuditDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(220, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [220 | __Ss], [__T | __Stack]);
yeccpars2(220, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(221, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 222, [221 | __Ss], [__T | __Stack]);
yeccpars2(221, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(222, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 224, [222 | __Ss], [__T | __Stack]);
yeccpars2(222, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(223, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 292, [223 | __Ss], [__T | __Stack]);
yeccpars2(223, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(224, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 225, [224 | __Ss], [__T | __Stack]);
yeccpars2(224, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(225, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 238, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 239, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 240, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 241, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 242, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 243, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 244, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 245, [225 | __Ss], [__T | __Stack]);
yeccpars2(225, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(226, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_226_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(227, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_227_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(228, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_228_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(229, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_229_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(230, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 288, [230 | __Ss], [__T | __Stack]);
yeccpars2(230, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_230_(__Stack),
 yeccpars2(287, __Cat, [230 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(231, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_231_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(232, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_232_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(233, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_233_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(234, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_234_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(235, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_235_(__Stack),
 yeccpars2(yeccgoto(extensionParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(236, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 264, [236 | __Ss], [__T | __Stack]);
yeccpars2(236, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 265, [236 | __Ss], [__T | __Stack]);
yeccpars2(236, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 266, [236 | __Ss], [__T | __Stack]);
yeccpars2(236, 'NEQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 267, [236 | __Ss], [__T | __Stack]);
yeccpars2(236, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(237, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_237_(__Stack),
 yeccpars2(yeccgoto(serviceChangeParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(238, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 261, [238 | __Ss], [__T | __Stack]);
yeccpars2(238, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_238_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(239, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 259, [239 | __Ss], [__T | __Stack]);
yeccpars2(239, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_239_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(240, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 257, [240 | __Ss], [__T | __Stack]);
yeccpars2(240, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_240_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(241, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 255, [241 | __Ss], [__T | __Stack]);
yeccpars2(241, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_241_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(242, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 251, [242 | __Ss], [__T | __Stack]);
yeccpars2(242, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_242_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(243, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 248, [243 | __Ss], [__T | __Stack]);
yeccpars2(243, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_243_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(244, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_244_(__Stack),
 yeccpars2(yeccgoto(timeStamp, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(245, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 246, [245 | __Ss], [__T | __Stack]);
yeccpars2(245, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_245_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(246, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [246 | __Ss], [__T | __Stack]);
yeccpars2(246, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(247, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_247_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeVersion, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(248, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 114, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 115, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [248 | __Ss], [__T | __Stack]);
yeccpars2(248, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_248_(__Stack),
 yeccpars2(110, __Cat, [248 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(249, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_249_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeAddress, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(250, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_250_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeAddress, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(251, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 254, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [251 | __Ss], [__T | __Stack]);
yeccpars2(251, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(252, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_252_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeReason, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(253, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_253_(__Stack),
 yeccpars2(yeccgoto(value, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(254, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_254_(__Stack),
 yeccpars2(yeccgoto(value, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(255, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [255 | __Ss], [__T | __Stack]);
yeccpars2(255, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(256, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_256_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeProfile, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(257, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 114, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 115, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [257 | __Ss], [__T | __Stack]);
yeccpars2(257, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_257_(__Stack),
 yeccpars2(110, __Cat, [257 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(258, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_258_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeMgcId, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(259, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [259 | __Ss], [__T | __Stack]);
yeccpars2(259, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(260, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_260_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeMethod, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(261, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [261 | __Ss], [__T | __Stack]);
yeccpars2(261, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(262, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_262_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeDelay, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(263, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_263_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(extension, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(264, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 273, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 274, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 254, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [264 | __Ss], [__T | __Stack]);
yeccpars2(264, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(265, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 254, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [265 | __Ss], [__T | __Stack]);
yeccpars2(265, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(266, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 254, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [266 | __Ss], [__T | __Stack]);
yeccpars2(266, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(267, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 254, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [267 | __Ss], [__T | __Stack]);
yeccpars2(267, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(268, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_268_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(parmValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(269, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_269_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(parmValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(270, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_270_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(parmValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(271, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_271_(__Stack),
 yeccpars2(yeccgoto(alternativeValue, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(272, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_272_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(parmValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(273, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 254, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [273 | __Ss], [__T | __Stack]);
yeccpars2(273, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(274, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 254, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [274 | __Ss], [__T | __Stack]);
yeccpars2(274, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(275, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 277, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 278, [275 | __Ss], [__T | __Stack]);
yeccpars2(275, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_275_(__Stack),
 yeccpars2(276, __Cat, [275 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(276, 'RSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 283, [276 | __Ss], [__T | __Stack]);
yeccpars2(276, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(277, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 254, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [277 | __Ss], [__T | __Stack]);
yeccpars2(277, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(278, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'QuotedChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 254, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [278 | __Ss], [__T | __Stack]);
yeccpars2(278, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(279, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 278, [279 | __Ss], [__T | __Stack]);
yeccpars2(279, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_279_(__Stack),
 yeccpars2(280, __Cat, [279 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(280, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_280_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(valueList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(281, 'RSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 282, [281 | __Ss], [__T | __Stack]);
yeccpars2(281, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(282, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_282_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(alternativeValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(283, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_283_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(alternativeValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(284, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 278, [284 | __Ss], [__T | __Stack]);
yeccpars2(284, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_284_(__Stack),
 yeccpars2(285, __Cat, [284 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(285, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 286, [285 | __Ss], [__T | __Stack]);
yeccpars2(285, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(286, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_286_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(alternativeValue, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(287, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 291, [287 | __Ss], [__T | __Stack]);
yeccpars2(287, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(288, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 238, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 239, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 240, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 241, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 242, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 243, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 244, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 245, [288 | __Ss], [__T | __Stack]);
yeccpars2(288, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(289, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 288, [289 | __Ss], [__T | __Stack]);
yeccpars2(289, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_289_(__Stack),
 yeccpars2(290, __Cat, [289 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(290, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_290_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceChangeParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(291, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_291_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(serviceChangeDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(292, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_292_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(serviceChangeRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(293, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [293 | __Ss], [__T | __Stack]);
yeccpars2(293, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(294, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_294_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(priority, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(295, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [295 | __Ss], [__T | __Stack]);
yeccpars2(295, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(296, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 297, [296 | __Ss], [__T | __Stack]);
yeccpars2(296, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(297, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 139, [297 | __Ss], [__T | __Stack]);
yeccpars2(297, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 301, [297 | __Ss], [__T | __Stack]);
yeccpars2(297, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(298, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_298_(__Stack),
 yeccpars2(yeccgoto(notifyRequestBody, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(299, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 333, [299 | __Ss], [__T | __Stack]);
yeccpars2(299, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(300, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_300_(__Stack),
 yeccpars2(yeccgoto(notifyRequestBody, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(301, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 302, [301 | __Ss], [__T | __Stack]);
yeccpars2(301, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(302, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [302 | __Ss], [__T | __Stack]);
yeccpars2(302, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(303, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_303_(__Stack),
 yeccpars2(yeccgoto(requestID, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(304, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 305, [304 | __Ss], [__T | __Stack]);
yeccpars2(304, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(305, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 244, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [305 | __Ss], [__T | __Stack]);
yeccpars2(305, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_305_(__Stack),
 yeccpars2(309, __Cat, [305 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(306, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [306 | __Ss], [__T | __Stack]);
yeccpars2(306, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_306_(__Stack),
 yeccpars2(331, __Cat, [306 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(307, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_307_(__Stack),
 yeccpars2(yeccgoto(pkgdName, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(308, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 319, [308 | __Ss], [__T | __Stack]);
yeccpars2(308, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_308_(__Stack),
 yeccpars2(330, __Cat, [308 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(309, 'SEP', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 3, [309 | __Ss], [__T | __Stack]);
yeccpars2(309, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_309_(__Stack),
 yeccpars2(316, __Cat, [309 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(310, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 312, [310 | __Ss], [__T | __Stack]);
yeccpars2(310, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_310_(__Stack),
 yeccpars2(311, __Cat, [310 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(311, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 315, [311 | __Ss], [__T | __Stack]);
yeccpars2(311, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(312, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'TimeStampToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 244, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [312 | __Ss], [__T | __Stack]);
yeccpars2(312, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_312_(__Stack),
 yeccpars2(309, __Cat, [312 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(313, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 312, [313 | __Ss], [__T | __Stack]);
yeccpars2(313, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_313_(__Stack),
 yeccpars2(314, __Cat, [313 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(314, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_314_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(observedEvents, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(315, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_315_(__Stack),
 __Nss = lists:nthtail(6, __Ss),
 yeccpars2(yeccgoto(observedEventsDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(316, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [316 | __Ss], [__T | __Stack]);
yeccpars2(316, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(317, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 319, [317 | __Ss], [__T | __Stack]);
yeccpars2(317, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_317_(__Stack),
 yeccpars2(318, __Cat, [317 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(318, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_318_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(observedEvent, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(319, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [319 | __Ss], [__T | __Stack]);
yeccpars2(319, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(320, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_320_(__Stack),
 yeccpars2(yeccgoto(eventParameterName, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(321, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 326, [321 | __Ss], [__T | __Stack]);
yeccpars2(321, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_321_(__Stack),
 yeccpars2(325, __Cat, [321 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(322, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(observedEventParameter, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(323, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 264, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 265, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 266, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, 'NEQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 267, [323 | __Ss], [__T | __Stack]);
yeccpars2(323, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(324, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_324_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(eventStreamOrOther, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(325, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 329, [325 | __Ss], [__T | __Stack]);
yeccpars2(325, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(326, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [326 | __Ss], [__T | __Stack]);
yeccpars2(326, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(327, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 326, [327 | __Ss], [__T | __Stack]);
yeccpars2(327, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_327_(__Stack),
 yeccpars2(328, __Cat, [327 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(328, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_328_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(observedEventParameters, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(329, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_329_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(observedEventBody, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(330, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_330_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(observedEvent, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(331, 'COLON', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 332, [331 | __Ss], [__T | __Stack]);
yeccpars2(331, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(332, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_332_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(observedEventTimeStamp, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(333, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_333_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(notifyRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(334, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 336, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 337, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 338, [334 | __Ss], [__T | __Stack]);
yeccpars2(334, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(335, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 340, [335 | __Ss], [__T | __Stack]);
yeccpars2(335, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_335_(__Stack),
 yeccpars2(339, __Cat, [335 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(336, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_336_(__Stack),
 yeccpars2(yeccgoto(contextAuditProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(337, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_337_(__Stack),
 yeccpars2(yeccgoto(contextAuditProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(338, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_338_(__Stack),
 yeccpars2(yeccgoto(contextAuditProperty, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(339, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 343, [339 | __Ss], [__T | __Stack]);
yeccpars2(339, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(340, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 336, [340 | __Ss], [__T | __Stack]);
yeccpars2(340, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 337, [340 | __Ss], [__T | __Stack]);
yeccpars2(340, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 338, [340 | __Ss], [__T | __Stack]);
yeccpars2(340, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(341, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 340, [341 | __Ss], [__T | __Stack]);
yeccpars2(341, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_341_(__Stack),
 yeccpars2(342, __Cat, [341 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(342, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_342_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(contextAuditProperties, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(343, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_343_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(contextAudit, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(344, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [344 | __Ss], [__T | __Stack]);
yeccpars2(344, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(345, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 197, [345 | __Ss], [__T | __Stack]);
yeccpars2(345, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_345_(__Stack),
 yeccpars2(346, __Cat, [345 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(346, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_346_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(auditRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(347, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [347 | __Ss], [__T | __Stack]);
yeccpars2(347, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(348, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 197, [348 | __Ss], [__T | __Stack]);
yeccpars2(348, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_348_(__Stack),
 yeccpars2(349, __Cat, [348 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(349, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_349_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(auditRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(350, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 354, [350 | __Ss], [__T | __Stack]);
yeccpars2(350, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(351, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 164, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 165, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 166, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 167, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 168, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 169, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 170, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 171, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 172, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 173, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 174, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 175, [351 | __Ss], [__T | __Stack]);
yeccpars2(351, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(352, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 351, [352 | __Ss], [__T | __Stack]);
yeccpars2(352, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_352_(__Stack),
 yeccpars2(353, __Cat, [352 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(353, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_353_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(actionRequestItems, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(354, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_354_(__Stack),
 __Nss = lists:nthtail(6, __Ss),
 yeccpars2(yeccgoto(actionRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(355, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [355 | __Ss], [__T | __Stack]);
yeccpars2(355, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(356, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 358, [356 | __Ss], [__T | __Stack]);
yeccpars2(356, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_356_(__Stack),
 yeccpars2(357, __Cat, [356 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(357, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_357_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(ammRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(358, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 199, [358 | __Ss], [__T | __Stack]);
yeccpars2(358, 'DigitMapDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 368, [358 | __Ss], [__T | __Stack]);
yeccpars2(358, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 369, [358 | __Ss], [__T | __Stack]);
yeccpars2(358, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 370, [358 | __Ss], [__T | __Stack]);
yeccpars2(358, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 371, [358 | __Ss], [__T | __Stack]);
yeccpars2(358, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 372, [358 | __Ss], [__T | __Stack]);
yeccpars2(358, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 373, [358 | __Ss], [__T | __Stack]);
yeccpars2(358, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 374, [358 | __Ss], [__T | __Stack]);
yeccpars2(358, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(359, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_359_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(360, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_360_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(361, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_361_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(362, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_362_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(363, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_363_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(364, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_364_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(365, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_365_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(366, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_366_(__Stack),
 yeccpars2(yeccgoto(ammParameter, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(367, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 605, [367 | __Ss], [__T | __Stack]);
yeccpars2(367, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_367_(__Stack),
 yeccpars2(604, __Cat, [367 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(368, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_368_(__Stack),
 yeccpars2(yeccgoto(digitMapDescriptor, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(369, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 596, [369 | __Ss], [__T | __Stack]);
yeccpars2(369, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_369_(__Stack),
 yeccpars2(yeccgoto(eventBufferDescriptor, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(370, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 536, [370 | __Ss], [__T | __Stack]);
yeccpars2(370, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_370_(__Stack),
 yeccpars2(yeccgoto(eventsDescriptor, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(371, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 466, [371 | __Ss], [__T | __Stack]);
yeccpars2(371, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(372, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 445, [372 | __Ss], [__T | __Stack]);
yeccpars2(372, 'LSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 446, [372 | __Ss], [__T | __Stack]);
yeccpars2(372, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(373, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 434, [373 | __Ss], [__T | __Stack]);
yeccpars2(373, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(374, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 375, [374 | __Ss], [__T | __Stack]);
yeccpars2(374, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_374_(__Stack),
 yeccpars2(yeccgoto(signalsDescriptor, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(375, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 381, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [375 | __Ss], [__T | __Stack]);
yeccpars2(375, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(376, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_376_(__Stack),
 yeccpars2(yeccgoto(signalParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(377, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 430, [377 | __Ss], [__T | __Stack]);
yeccpars2(377, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_377_(__Stack),
 yeccpars2(429, __Cat, [377 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(378, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 393, [378 | __Ss], [__T | __Stack]);
yeccpars2(378, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_378_(__Stack),
 yeccpars2(yeccgoto(signalRequest, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(379, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_379_(__Stack),
 yeccpars2(yeccgoto(signalParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(380, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(signalName, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(381, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 382, [381 | __Ss], [__T | __Stack]);
yeccpars2(381, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_381_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(382, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [382 | __Ss], [__T | __Stack]);
yeccpars2(382, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(383, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 385, [383 | __Ss], [__T | __Stack]);
yeccpars2(383, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(384, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_384_(__Stack),
 yeccpars2(yeccgoto(signalListId, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(385, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [385 | __Ss], [__T | __Stack]);
yeccpars2(385, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(386, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(signalListParm, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(387, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 389, [387 | __Ss], [__T | __Stack]);
yeccpars2(387, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_387_(__Stack),
 yeccpars2(388, __Cat, [387 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(388, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 392, [388 | __Ss], [__T | __Stack]);
yeccpars2(388, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(389, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [389 | __Ss], [__T | __Stack]);
yeccpars2(389, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(390, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 389, [390 | __Ss], [__T | __Stack]);
yeccpars2(390, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_390_(__Stack),
 yeccpars2(391, __Cat, [390 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(391, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_391_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(signalListParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(392, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_392_(__Stack),
 __Nss = lists:nthtail(6, __Ss),
 yeccpars2(yeccgoto(signalList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(393, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 396, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 397, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 398, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 399, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 400, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [393 | __Ss], [__T | __Stack]);
yeccpars2(393, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(394, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 425, [394 | __Ss], [__T | __Stack]);
yeccpars2(394, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_394_(__Stack),
 yeccpars2(424, __Cat, [394 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(395, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 264, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 265, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 266, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, 'NEQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 267, [395 | __Ss], [__T | __Stack]);
yeccpars2(395, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(396, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 421, [396 | __Ss], [__T | __Stack]);
yeccpars2(396, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_396_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(397, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_397_COMMA(__Stack),
 yeccpars2(yeccgoto(sigParameter, hd(__Ss)), 'COMMA', __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(397, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_397_RBRKT(__Stack),
 yeccpars2(yeccgoto(sigParameter, hd(__Ss)), 'RBRKT', __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(397, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_397_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(398, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 409, [398 | __Ss], [__T | __Stack]);
yeccpars2(398, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_398_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(399, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 404, [399 | __Ss], [__T | __Stack]);
yeccpars2(399, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_399_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(400, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 401, [400 | __Ss], [__T | __Stack]);
yeccpars2(400, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_400_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(401, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [401 | __Ss], [__T | __Stack]);
yeccpars2(401, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(402, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_402_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(403, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_403_(__Stack),
 yeccpars2(yeccgoto(streamID, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(404, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 406, [404 | __Ss], [__T | __Stack]);
yeccpars2(404, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 407, [404 | __Ss], [__T | __Stack]);
yeccpars2(404, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 408, [404 | __Ss], [__T | __Stack]);
yeccpars2(404, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(405, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_405_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(406, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_406_(__Stack),
 yeccpars2(yeccgoto(signalType, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(407, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_407_(__Stack),
 yeccpars2(yeccgoto(signalType, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(408, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_408_(__Stack),
 yeccpars2(yeccgoto(signalType, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(409, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 410, [409 | __Ss], [__T | __Stack]);
yeccpars2(409, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(410, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 412, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 413, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 414, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 415, [410 | __Ss], [__T | __Stack]);
yeccpars2(410, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(411, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 417, [411 | __Ss], [__T | __Stack]);
yeccpars2(411, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_411_(__Stack),
 yeccpars2(416, __Cat, [411 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(412, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_412_(__Stack),
 yeccpars2(yeccgoto(notificationReason, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(413, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_413_(__Stack),
 yeccpars2(yeccgoto(notificationReason, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(414, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_414_(__Stack),
 yeccpars2(yeccgoto(notificationReason, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(415, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_415_(__Stack),
 yeccpars2(yeccgoto(notificationReason, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(416, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 420, [416 | __Ss], [__T | __Stack]);
yeccpars2(416, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(417, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 412, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 413, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 414, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 415, [417 | __Ss], [__T | __Stack]);
yeccpars2(417, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(418, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 417, [418 | __Ss], [__T | __Stack]);
yeccpars2(418, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_418_(__Stack),
 yeccpars2(419, __Cat, [418 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(419, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_419_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(notificationReasons, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(420, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_420_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(421, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [421 | __Ss], [__T | __Stack]);
yeccpars2(421, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(422, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_422_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(423, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_423_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(sigParameter, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(424, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 428, [424 | __Ss], [__T | __Stack]);
yeccpars2(424, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(425, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 396, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 397, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 398, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 399, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 400, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [425 | __Ss], [__T | __Stack]);
yeccpars2(425, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(426, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 425, [426 | __Ss], [__T | __Stack]);
yeccpars2(426, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_426_(__Stack),
 yeccpars2(427, __Cat, [426 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(427, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_427_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(sigParameters, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(428, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_428_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(signalRequest, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(429, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 433, [429 | __Ss], [__T | __Stack]);
yeccpars2(429, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(430, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 381, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [430 | __Ss], [__T | __Stack]);
yeccpars2(430, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(431, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 430, [431 | __Ss], [__T | __Stack]);
yeccpars2(431, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_431_(__Stack),
 yeccpars2(432, __Cat, [431 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(432, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_432_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(signalParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(433, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_433_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(signalsDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(434, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [434 | __Ss], [__T | __Stack]);
yeccpars2(434, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(435, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_435_(__Stack),
 yeccpars2(yeccgoto(muxType, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(436, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 438, [436 | __Ss], [__T | __Stack]);
yeccpars2(436, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(437, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_437_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(muxDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(438, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [438 | __Ss], [__T | __Stack]);
yeccpars2(438, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(439, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 441, [439 | __Ss], [__T | __Stack]);
yeccpars2(439, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_439_(__Stack),
 yeccpars2(440, __Cat, [439 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(440, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 444, [440 | __Ss], [__T | __Stack]);
yeccpars2(440, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(441, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [441 | __Ss], [__T | __Stack]);
yeccpars2(441, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(442, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 441, [442 | __Ss], [__T | __Stack]);
yeccpars2(442, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_442_(__Stack),
 yeccpars2(443, __Cat, [442 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(443, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_443_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(terminationIDListRepeat, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(444, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_444_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(terminationIDList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(445, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [445 | __Ss], [__T | __Stack]);
yeccpars2(445, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(446, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [446 | __Ss], [__T | __Stack]);
yeccpars2(446, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(447, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_447_(__Stack),
 yeccpars2(yeccgoto(modemType, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(448, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 450, [448 | __Ss], [__T | __Stack]);
yeccpars2(448, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_448_(__Stack),
 yeccpars2(449, __Cat, [448 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(449, 'RSBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 453, [449 | __Ss], [__T | __Stack]);
yeccpars2(449, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(450, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [450 | __Ss], [__T | __Stack]);
yeccpars2(450, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(451, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 450, [451 | __Ss], [__T | __Stack]);
yeccpars2(451, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_451_(__Stack),
 yeccpars2(452, __Cat, [451 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(452, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_452_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(modemTypeList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(453, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 455, [453 | __Ss], [__T | __Stack]);
yeccpars2(453, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_453_(__Stack),
 yeccpars2(454, __Cat, [453 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(454, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_454_(__Stack),
 __Nss = lists:nthtail(5, __Ss),
 yeccpars2(yeccgoto(modemDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(455, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [455 | __Ss], [__T | __Stack]);
yeccpars2(455, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(456, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 460, [456 | __Ss], [__T | __Stack]);
yeccpars2(456, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_456_(__Stack),
 yeccpars2(459, __Cat, [456 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(457, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 264, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'GREATER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 265, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'LESSER', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 266, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, 'NEQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 267, [457 | __Ss], [__T | __Stack]);
yeccpars2(457, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(458, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_458_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(propertyParm, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(459, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 463, [459 | __Ss], [__T | __Stack]);
yeccpars2(459, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(460, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [460 | __Ss], [__T | __Stack]);
yeccpars2(460, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(461, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 460, [461 | __Ss], [__T | __Stack]);
yeccpars2(461, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_461_(__Stack),
 yeccpars2(462, __Cat, [461 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(462, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_462_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(propertyParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(463, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_463_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(optPropertyParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(464, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 455, [464 | __Ss], [__T | __Stack]);
yeccpars2(464, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_464_(__Stack),
 yeccpars2(465, __Cat, [464 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(465, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_465_(__Stack),
 __Nss = lists:nthtail(3, __Ss),
 yeccpars2(yeccgoto(modemDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(466, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 472, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'LocalDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 473, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'RemoteDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 474, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 475, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 476, [466 | __Ss], [__T | __Stack]);
yeccpars2(466, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(467, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_467_(__Stack),
 yeccpars2(yeccgoto(mediaParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(468, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_468_(__Stack),
 yeccpars2(yeccgoto(mediaParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(469, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_469_(__Stack),
 yeccpars2(yeccgoto(mediaParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(470, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 532, [470 | __Ss], [__T | __Stack]);
yeccpars2(470, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_470_(__Stack),
 yeccpars2(531, __Cat, [470 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(471, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_471_(__Stack),
 yeccpars2(yeccgoto(streamParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(472, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 507, [472 | __Ss], [__T | __Stack]);
yeccpars2(472, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(473, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_473_(__Stack),
 yeccpars2(yeccgoto(streamParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(474, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_474_(__Stack),
 yeccpars2(yeccgoto(streamParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(475, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 498, [475 | __Ss], [__T | __Stack]);
yeccpars2(475, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(476, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 477, [476 | __Ss], [__T | __Stack]);
yeccpars2(476, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(477, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 482, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 483, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [477 | __Ss], [__T | __Stack]);
yeccpars2(477, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(478, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 494, [478 | __Ss], [__T | __Stack]);
yeccpars2(478, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_478_(__Stack),
 yeccpars2(493, __Cat, [478 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(479, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_479_(__Stack),
 yeccpars2(yeccgoto(terminationStateParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(480, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_480_(__Stack),
 yeccpars2(yeccgoto(terminationStateParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(481, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_481_(__Stack),
 yeccpars2(yeccgoto(terminationStateParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(482, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 489, [482 | __Ss], [__T | __Stack]);
yeccpars2(482, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_482_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(483, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 484, [483 | __Ss], [__T | __Stack]);
yeccpars2(483, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_483_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(484, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 486, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 487, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 488, [484 | __Ss], [__T | __Stack]);
yeccpars2(484, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(485, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_485_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(serviceStates, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(486, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_486_(__Stack),
 yeccpars2(yeccgoto(serviceState, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(487, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_487_(__Stack),
 yeccpars2(yeccgoto(serviceState, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(488, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_488_(__Stack),
 yeccpars2(yeccgoto(serviceState, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(489, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 491, [489 | __Ss], [__T | __Stack]);
yeccpars2(489, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 492, [489 | __Ss], [__T | __Stack]);
yeccpars2(489, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(490, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_490_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(eventBufferControl, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(491, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_491_(__Stack),
 yeccpars2(yeccgoto(eventBufferControlState, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(492, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_492_(__Stack),
 yeccpars2(yeccgoto(eventBufferControlState, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(493, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 497, [493 | __Ss], [__T | __Stack]);
yeccpars2(493, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(494, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 482, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 483, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [494 | __Ss], [__T | __Stack]);
yeccpars2(494, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(495, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 494, [495 | __Ss], [__T | __Stack]);
yeccpars2(495, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_495_(__Stack),
 yeccpars2(496, __Cat, [495 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(496, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_496_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(terminationStateParms, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(497, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_497_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(terminationStateDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(498, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [498 | __Ss], [__T | __Stack]);
yeccpars2(498, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(499, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 500, [499 | __Ss], [__T | __Stack]);
yeccpars2(499, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(500, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 472, [500 | __Ss], [__T | __Stack]);
yeccpars2(500, 'LocalDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 473, [500 | __Ss], [__T | __Stack]);
yeccpars2(500, 'RemoteDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 474, [500 | __Ss], [__T | __Stack]);
yeccpars2(500, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(501, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 503, [501 | __Ss], [__T | __Stack]);
yeccpars2(501, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_501_(__Stack),
 yeccpars2(502, __Cat, [501 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(502, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 506, [502 | __Ss], [__T | __Stack]);
yeccpars2(502, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(503, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 472, [503 | __Ss], [__T | __Stack]);
yeccpars2(503, 'LocalDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 473, [503 | __Ss], [__T | __Stack]);
yeccpars2(503, 'RemoteDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 474, [503 | __Ss], [__T | __Stack]);
yeccpars2(503, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(504, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 503, [504 | __Ss], [__T | __Stack]);
yeccpars2(504, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_504_(__Stack),
 yeccpars2(505, __Cat, [504 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(505, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_505_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(streamParmList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(506, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_506_(__Stack),
 __Nss = lists:nthtail(6, __Ss),
 yeccpars2(yeccgoto(streamDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(507, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 510, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 511, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 512, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [507 | __Ss], [__T | __Stack]);
yeccpars2(507, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(508, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_508_(__Stack),
 yeccpars2(yeccgoto(localParm, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(509, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 527, [509 | __Ss], [__T | __Stack]);
yeccpars2(509, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_509_(__Stack),
 yeccpars2(526, __Cat, [509 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(510, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 519, [510 | __Ss], [__T | __Stack]);
yeccpars2(510, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_510_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(511, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 517, [511 | __Ss], [__T | __Stack]);
yeccpars2(511, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_511_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(512, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 513, [512 | __Ss], [__T | __Stack]);
yeccpars2(512, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_512_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(513, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 515, [513 | __Ss], [__T | __Stack]);
yeccpars2(513, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 516, [513 | __Ss], [__T | __Stack]);
yeccpars2(513, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(514, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_514_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(localParm, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(515, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_515_(__Stack),
 yeccpars2(yeccgoto(onOrOff, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(516, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_516_(__Stack),
 yeccpars2(yeccgoto(onOrOff, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(517, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 515, [517 | __Ss], [__T | __Stack]);
yeccpars2(517, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 516, [517 | __Ss], [__T | __Stack]);
yeccpars2(517, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(518, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_518_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(localParm, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(519, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 521, [519 | __Ss], [__T | __Stack]);
yeccpars2(519, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 522, [519 | __Ss], [__T | __Stack]);
yeccpars2(519, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 523, [519 | __Ss], [__T | __Stack]);
yeccpars2(519, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 524, [519 | __Ss], [__T | __Stack]);
yeccpars2(519, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 525, [519 | __Ss], [__T | __Stack]);
yeccpars2(519, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(520, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_520_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(localParm, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(521, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_521_(__Stack),
 yeccpars2(yeccgoto(streamModes, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(522, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_522_(__Stack),
 yeccpars2(yeccgoto(streamModes, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(523, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_523_(__Stack),
 yeccpars2(yeccgoto(streamModes, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(524, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_524_(__Stack),
 yeccpars2(yeccgoto(streamModes, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(525, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_525_(__Stack),
 yeccpars2(yeccgoto(streamModes, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(526, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 530, [526 | __Ss], [__T | __Stack]);
yeccpars2(526, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(527, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 510, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 511, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 512, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [527 | __Ss], [__T | __Stack]);
yeccpars2(527, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(528, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 527, [528 | __Ss], [__T | __Stack]);
yeccpars2(528, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_528_(__Stack),
 yeccpars2(529, __Cat, [528 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(529, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_529_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(localParmList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(530, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_530_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(localControlDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(531, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 535, [531 | __Ss], [__T | __Stack]);
yeccpars2(531, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(532, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 472, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'LocalDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 473, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'RemoteDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 474, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 475, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 476, [532 | __Ss], [__T | __Stack]);
yeccpars2(532, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(533, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 532, [533 | __Ss], [__T | __Stack]);
yeccpars2(533, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_533_(__Stack),
 yeccpars2(534, __Cat, [533 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(534, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_534_(__Stack),
 __Nss = lists:nthtail(2, __Ss),
 yeccpars2(yeccgoto(mediaParmList, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(535, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_535_(__Stack),
 __Nss = lists:nthtail(4, __Ss),
 yeccpars2(yeccgoto(mediaDescriptor, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(536, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [536 | __Ss], [__T | __Stack]);
yeccpars2(536, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(537, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 538, [537 | __Ss], [__T | __Stack]);
yeccpars2(537, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(538, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [538 | __Ss], [__T | __Stack]);
yeccpars2(538, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(539, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 592, [539 | __Ss], [__T | __Stack]);
yeccpars2(539, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_539_(__Stack),
 yeccpars2(591, __Cat, [539 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(540, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 542, [540 | __Ss], [__T | __Stack]);
yeccpars2(540, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_540_(__Stack),
 yeccpars2(541, __Cat, [540 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(541, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_541_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(requestedEvent, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(542, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'DigitMapDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 548, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 549, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 550, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [542 | __Ss], [__T | __Stack]);
yeccpars2(542, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(543, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(eventParameter, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(544, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 587, [544 | __Ss], [__T | __Stack]);
yeccpars2(544, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_544_(__Stack),
 yeccpars2(586, __Cat, [544 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(545, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(eventParameter, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(546, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(eventParameter, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(547, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars2(yeccgoto(eventParameter, hd(__Ss)), __Cat, __Ss, __Stack, __T, __Ts, __Tzr);
yeccpars2(548, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_548_(__Stack),
 yeccpars2(yeccgoto(eventDM, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(549, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 551, [549 | __Ss], [__T | __Stack]);
yeccpars2(549, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_549_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(550, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_550_COMMA(__Stack),
 yeccpars2(yeccgoto(eventParameter, hd(__Ss)), 'COMMA', __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(550, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_550_RBRKT(__Stack),
 yeccpars2(yeccgoto(eventParameter, hd(__Ss)), 'RBRKT', __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(550, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_550_(__Stack),
 yeccpars2(yeccgoto(safeToken, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(551, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 554, [551 | __Ss], [__T | __Stack]);
yeccpars2(551, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 374, [551 | __Ss], [__T | __Stack]);
yeccpars2(551, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(552, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 582, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 583, [552 | __Ss], [__T | __Stack]);
yeccpars2(552, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(553, 'RBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 581, [553 | __Ss], [__T | __Stack]);
yeccpars2(553, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(554, 'EQUAL', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 555, [554 | __Ss], [__T | __Stack]);
yeccpars2(554, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_554_(__Stack),
 yeccpars2(yeccgoto(embedFirst, hd(__Ss)), __Cat, __Ss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(555, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [555 | __Ss], [__T | __Stack]);
yeccpars2(555, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(556, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 557, [556 | __Ss], [__T | __Stack]);
yeccpars2(556, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(557, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 23, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 41, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'SignalListToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 80, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'SignalTypeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 81, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'SignalsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 82, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'StatsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 83, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'StreamToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 84, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'SubtractToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 85, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'SynchISDNToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 86, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'TerminationStateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 87, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'TestToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 88, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'TimeOutToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 89, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'TopologyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 90, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'TransToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 91, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'V18Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 92, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'V22Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 93, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'V22bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 94, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'V32Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 95, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'V32bisToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 96, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'V34Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 97, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'V76Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 98, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'V90Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 99, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'V91Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 100, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, 'VersionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 101, [557 | __Ss], [__T | __Stack]);
yeccpars2(557, _, _, _, __T, _, _) ->
 yeccerror(__T);
yeccpars2(558, 'COMMA', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 577, [558 | __Ss], [__T | __Stack]);
yeccpars2(558, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_558_(__Stack),
 yeccpars2(576, __Cat, [558 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(559, 'LBRKT', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 561, [559 | __Ss], [__T | __Stack]);
yeccpars2(559, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_559_(__Stack),
 yeccpars2(560, __Cat, [559 | __Ss], __NewStack, __T, __Ts, __Tzr);
yeccpars2(560, __Cat, __Ss, __Stack, __T, __Ts, __Tzr) ->
 __NewStack = yeccpars2_560_(__Stack),
 __Nss = lists:nthtail(1, __Ss),
 yeccpars2(yeccgoto(secondRequestedEvent, hd(__Nss)), __Cat, __Nss, __NewStack, __T, __Ts, __Tzr);
yeccpars2(561, 'AddToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 8, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'AuditCapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 9, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'AuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 10, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'AuditValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 11, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'AuthToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 12, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'BothwayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 13, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'BriefToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 14, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'BufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 15, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'ContextAuditToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 16, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'CtxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 17, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'DelayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 18, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'DigitMapDescriptorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 548, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'DigitMapToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 19, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'DiscardToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 20, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'DisconnectedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 21, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'DurationToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 22, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'EmbedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 566, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'EmergencyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 24, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'ErrorToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 25, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'EventBufferToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 26, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'EventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 27, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'FailoverToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 28, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'ForcedToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 29, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'GracefulToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 30, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'H221Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 31, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'H223Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 32, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'H226Token', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 33, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'HandOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 34, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'ImmAckRequiredToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 35, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'InSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 36, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'InactiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 37, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'InterruptByEventToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 38, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'InterruptByNewSignalsDescrToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 39, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'IsolateToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 40, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'KeepActiveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 567, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'LocalControlToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 42, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'LockStepToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 43, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'LoopbackToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 44, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'MediaToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 45, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'MethodToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 46, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'MgcIdToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 47, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'ModeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 48, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'ModemToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 49, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'ModifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 50, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'MoveToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 51, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'MuxToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 52, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'NotifyCompletionToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 53, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'NotifyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 54, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'ObservedEventsToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 55, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'OffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 56, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'OnOffToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 57, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'OnToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 58, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'OnewayToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 59, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'OtherReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 60, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'OutOfSvcToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 61, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'PackagesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 62, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'PendingToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 63, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'PriorityToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 64, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'ProfileToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 65, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'ReasonToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 66, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'RecvonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 67, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'ReplyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 68, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'ReservedGroupToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 69, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'ReservedValueToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 70, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'ResponseAckToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 71, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'RestartToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 72, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'SafeChars', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 73, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'SendonlyToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 74, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'SendrecvToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 75, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'ServiceChangeAddressToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 76, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'ServiceChangeToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 77, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'ServiceStatesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 78, [561 | __Ss], [__T | __Stack]);
yeccpars2(561, 'ServicesToken', __Ss, __Stack, __T, __Ts, __Tzr) ->
 yeccpars1(__Ts, __Tzr, 79, [561 | __Ss], [__T | __Stack]);
yeccp