########################################################################
#
# File Name:            HTMLTextAreaElement
#
# Documentation:        http://docs.4suite.com/4DOM/HTMLTextAreaElement.html
#

### This file is automatically generated by GenerateHtml.py.
### DO NOT EDIT!

"""
WWW: http://4suite.com/4DOM         e-mail: support@4suite.com

Copyright (c) 2000 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.com/COPYRIGHT  for license and copyright information
"""

import string
from xml.dom import Node
from xml.dom.html.HTMLElement import HTMLElement

class HTMLTextAreaElement(HTMLElement):

    def __init__(self, ownerDocument, nodeName="TEXTAREA"):
        HTMLElement.__init__(self, ownerDocument, nodeName)

    ### Attribute Methods ###

    def _get_accessKey(self):
        return self.getAttribute("ACCESSKEY")

    def _set_accessKey(self, value):
        self.setAttribute("ACCESSKEY", value)

    def _get_cols(self):
        value = self.getAttribute("COLS")
        if value:
            return int(value)
        return 0

    def _set_cols(self, value):
        self.setAttribute("COLS", str(value))

    def _get_defaultValue(self):
        if not self.firstChild:
            return
        if self.firstChild == self.lastChild:
            return self.firstChild.data
        self.normalize()
        text = filter(lambda x: x.nodeType == Node.TEXT_NODE, self.childNodes)
        return text[0].data

    def _set_defaultValue(self, value):
        text = None
        for node in self.childNodes:
            if not text and node.nodeType == Node.TEXT_NODE:
                text = node
            else:
                self.removeChild(node)
        if text:
            text.data = value
        else:
            text = self.ownerDocument.createTextNode(value)
            self.appendChild(text)

    def _get_disabled(self):
        return self.hasAttribute("DISABLED")

    def _set_disabled(self, value):
        if value:
            self.setAttribute("DISABLED", "DISABLED")
        else:
            self.removeAttribute("DISABLED")

    def _get_form(self):
        parent = self.parentNode
        while parent:
            if parent.nodeName == "FORM":
                return parent
            parent = parent.parentNode
        return None

    def _get_name(self):
        return self.getAttribute("NAME")

    def _set_name(self, value):
        self.setAttribute("NAME", value)

    def _get_readonly(self):
        return self.hasAttribute("READONLY")

    def _set_readonly(self, value):
        if value:
            self.setAttribute("READONLY", "READONLY")
        else:
            self.removeAttribute("READONLY")

    def _get_rows(self):
        value = self.getAttribute("ROWS")
        if value:
            return int(value)
        return 0

    def _set_rows(self, value):
        self.setAttribute("ROWS", str(value))

    def _get_tabIndex(self):
        value = self.getAttribute("TABINDEX")
        if value:
            return int(value)
        return 0

    def _set_tabIndex(self, value):
        self.setAttribute("TABINDEX", str(value))

    def _get_type(self):
        return "textarea"

    def _get_value(self):
        if not self.firstChild:
            return
        if self.firstChild == self.lastChild:
            return self.firstChild.data
        self.normalize()
        text = filter(lambda x: x.nodeType == Node.TEXT_NODE, self.childNodes)
        return text[0].data

    def _set_value(self, value):
        text = None
        for node in self.childNodes:
            if not text and node.nodeType == Node.TEXT_NODE:
                text = node
            else:
                self.removeChild(node)
        if text:
            text.data = value
        else:
            text = self.ownerDocument.createTextNode(value)
            self.appendChild(text)

    ### Methods ###

    def blur(self):
        pass

    def focus(self):
        pass

    def select(self):
        pass

    ### Attribute Access Mappings ###

    _readComputedAttrs = HTMLElement._readComputedAttrs.copy()
    _readComputedAttrs.update({
        "accessKey" : _get_accessKey,
        "cols" : _get_cols,
        "defaultValue" : _get_defaultValue,
        "disabled" : _get_disabled,
        "form" : _get_form,
        "name" : _get_name,
        "readonly" : _get_readonly,
        "rows" : _get_rows,
        "tabIndex" : _get_tabIndex,
        "type" : _get_type,
        "value" : _get_value
        })

    _writeComputedAttrs = HTMLElement._writeComputedAttrs.copy()
    _writeComputedAttrs.update({
        "accessKey" : _set_accessKey,
        "cols" : _set_cols,
        "defaultValue" : _set_defaultValue,
        "disabled" : _set_disabled,
        "name" : _set_name,
        "readonly" : _set_readonly,
        "rows" : _set_rows,
        "tabIndex" : _set_tabIndex,
        "value" : _set_value
        })

    _readOnlyAttrs = filter(lambda k,m=_writeComputedAttrs: not m.has_key(k),
                     HTMLElement._readOnlyAttrs + _readComputedAttrs.keys())
