/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999-2002  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#ifndef _MOUSE_H
#define _MOUSE_H

#include "point.h"
#include "rect.h"
#include "surface.h"
#include "widget.h"

#include <vector>
#include <list>

namespace uta {

///
class Pointer
{

 public:
  ///
  Pointer(const Surface* bm, const Rect &rect = Rect(0,0,0,0));

  ///
  Pointer(std::vector<const Surface*>& bmlist, const Rect &rect = Rect(0,0,0,0));
  ///
  ~Pointer();

  ///
  Surface* surface;
  ///
  Rect screenArea;

  ///
  void tick();

 protected:
  ///
  std::vector<Surface*> bmList_;
  ///
  std::vector<Surface*>::iterator bmItr_;

  
  
};
  
class Application;

/**software mouse pointer.
   it allows setting special mousepointers for specified areas of
   the screen.
*/
class Mouse : public SigC::Object
{
  friend class uta::Application;

 public:

  ///
  ~Mouse();
  ///
  static Mouse* create();

  ///if passed NULL as surface, the default pointer is used
  void setPointer(const Surface*);
  ///set animated mousecursor as defaultcursor
  void setPointer(std::vector<const Surface*>&);
  ///if passed NULL as surface, the default pointer is used
  void setPointer(const Surface*, const Rect&);
  ///set animated cursor for this region
  void setPointer(std::vector<const Surface*>&, const Rect&);
  ///
  void paint();
  ///
  void remove();
  ///
  void blit();
  ///
  void tick() { if(ptr != 0) ptr->tick(); };
  ///
  void warp(const Point&);

  ///
  void refreshRect(const Rect&);
  ///
  static Point position() { if(instance_) return instance_->pos_; return Point(0,0); }; 
  ///
  enum { MAXX = 32, MAXY = 32 };

 protected:

  ///
  Mouse();
  ///
  void move(const Point&);
  ///
  std::list<Pointer*> pointers_;
  ///
  Pointer* defaultPointer_;
  ///
  Surface pointer_;
  ///
  Point pos_;
  ///
  Surface* backBuffer_;
  ///
  Surface* doubleBuffer_;
  ///
  Rect dest;
  ///
  Rect src;
  ///
  Rect new_dest;
  ///
  Rect new_src;
  ///
  Pointer* ptr; 
  ///
  static Mouse* instance_;

};
  

}



#endif

