#!/bin/csh -f
##
## $Id: gentxt.csh,v 1.12 2006/04/17 19:51:02 msk Exp $
##
## Copyright (c) 2005, 2006 Sendmail, Inc. and its suppliers.
## All rights reserved.
##
## gentxt.csh -- generate a TXT record for DKIM service
##
## Usage: gentext.csh <selector> [<domain>]
##
## This will write a TXT record suitable for insertion into a DNS zone file
## on standard output, and the matching public/private keys will be in
## PEM-formatted files called <selector>.public and <selector>.private,
## respectively, in the current directory.
##
## To translate the record produced by this script, see the DKIM
## draft.  The script will output a record which advertises an RSA-style
## public key in test mode.


# verify usage
if ("$3" != "" || "$1" == "") then
	echo "usage: $0 selector [domain]"
	exit 1
endif

# copy the argument
set selector="$1"
set domain="$2"

# generate a private key
umask 077
openssl genrsa -out ${selector}.private 1024 >& /dev/null

# generate a public key based on the private key
openssl rsa -in ${selector}.private -out ${selector}.public -pubout \
	-outform PEM >& /dev/null

# prepare the data
set keydata = `grep -v '^-' ${selector}.public`
set pubkey  = `echo $keydata | sed 's/ //g'`

# output the record
echo -n ${selector}._domainkey   IN   TXT  '"'v=DKIM1\; k=rsa\; t=y\; p=$pubkey'"'
if ("$domain" != "") then
	echo " ; ----- DKIM $selector for $domain"
else
	echo ""
endif

# all done!
exit 0
