package WWW::Curl::Easy;

use strict;
use Carp;
use vars qw($VERSION @ISA @EXPORT @EXPORT_OK $AUTOLOAD);

require WWW::Curl;
require Exporter;
require AutoLoader;

@ISA = qw(Exporter DynaLoader);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.
@EXPORT = qw(
CURLOPT_AUTOREFERER
CURLOPT_BUFFERSIZE
CURLOPT_CAINFO
CURLOPT_CAPATH
CURLOPT_CLOSEPOLICY
CURLOPT_CONNECTTIMEOUT
CURLOPT_CONNECT_ONLY
CURLOPT_CONV_FROM_NETWORK_FUNCTION
CURLOPT_CONV_FROM_UTF8_FUNCTION
CURLOPT_CONV_TO_NETWORK_FUNCTION
CURLOPT_COOKIE
CURLOPT_COOKIEFILE
CURLOPT_COOKIEJAR
CURLOPT_COOKIELIST
CURLOPT_COOKIESESSION
CURLOPT_CRLF
CURLOPT_CUSTOMREQUEST
CURLOPT_DEBUGDATA
CURLOPT_DEBUGFUNCTION
CURLOPT_DNS_CACHE_TIMEOUT
CURLOPT_DNS_USE_GLOBAL_CACHE
CURLOPT_EGDSOCKET
CURLOPT_ENCODING
CURLOPT_ERRORBUFFER
CURLOPT_FAILONERROR
CURLOPT_FILE
CURLOPT_FILETIME
CURLOPT_FOLLOWLOCATION
CURLOPT_FORBID_REUSE
CURLOPT_FRESH_CONNECT
CURLOPT_FTPAPPEND
CURLOPT_FTPLISTONLY
CURLOPT_FTPPORT
CURLOPT_FTPSSLAUTH
CURLOPT_FTP_ACCOUNT
CURLOPT_FTP_CREATE_MISSING_DIRS
CURLOPT_FTP_FILEMETHOD
CURLOPT_FTP_RESPONSE_TIMEOUT
CURLOPT_FTP_SKIP_PASV_IP
CURLOPT_FTP_SSL
CURLOPT_FTP_USE_EPRT
CURLOPT_FTP_USE_EPSV
CURLOPT_HEADER
CURLOPT_HEADERFUNCTION
CURLOPT_HTTP200ALIASES
CURLOPT_HTTPAUTH
CURLOPT_HTTPGET
CURLOPT_HTTPHEADER
CURLOPT_HTTPPOST
CURLOPT_HTTPPROXYTUNNEL
CURLOPT_HTTP_VERSION
CURLOPT_IGNORE_CONTENT_LENGTH
CURLOPT_INFILE
CURLOPT_INFILESIZE
CURLOPT_INFILESIZE_LARGE
CURLOPT_INTERFACE
CURLOPT_IOCTLDATA
CURLOPT_IOCTLFUNCTION
CURLOPT_IPRESOLVE
CURLOPT_KRB4LEVEL
CURLOPT_LOCALPORT
CURLOPT_LOCALPORTRANGE
CURLOPT_LOW_SPEED_LIMIT
CURLOPT_LOW_SPEED_TIME
CURLOPT_MAXCONNECTS
CURLOPT_MAXFILESIZE
CURLOPT_MAXFILESIZE_LARGE
CURLOPT_MAXREDIRS
CURLOPT_NETRC
CURLOPT_NETRC_FILE
CURLOPT_NOBODY
CURLOPT_NOPROGRESS
CURLOPT_NOSIGNAL
CURLOPT_PORT
CURLOPT_POST
CURLOPT_POSTFIELDS
CURLOPT_POSTFIELDSIZE
CURLOPT_POSTFIELDSIZE_LARGE
CURLOPT_POSTQUOTE
CURLOPT_PREQUOTE
CURLOPT_PRIVATE
CURLOPT_PROGRESSDATA
CURLOPT_PROGRESSFUNCTION
CURLOPT_PROXY
CURLOPT_PROXYAUTH
CURLOPT_PROXYPORT
CURLOPT_PROXYTYPE
CURLOPT_PROXYUSERPWD
CURLOPT_PUT
CURLOPT_QUOTE
CURLOPT_RANDOM_FILE
CURLOPT_RANGE
CURLOPT_READFUNCTION
CURLOPT_REFERER
CURLOPT_RESUME_FROM
CURLOPT_RESUME_FROM_LARGE
CURLOPT_SHARE
CURLOPT_SOURCE_POSTQUOTE
CURLOPT_SOURCE_PREQUOTE
CURLOPT_SOURCE_QUOTE
CURLOPT_SOURCE_URL
CURLOPT_SOURCE_USERPWD
CURLOPT_SSLCERT
CURLOPT_SSLCERTPASSWD
CURLOPT_SSLCERTTYPE
CURLOPT_SSLENGINE
CURLOPT_SSLENGINE_DEFAULT
CURLOPT_SSLKEY
CURLOPT_SSLKEYPASSWD
CURLOPT_SSLKEYTYPE
CURLOPT_SSLVERSION
CURLOPT_SSL_CIPHER_LIST
CURLOPT_SSL_CTX_DATA
CURLOPT_SSL_CTX_FUNCTION
CURLOPT_SSL_VERIFYHOST
CURLOPT_SSL_VERIFYPEER
CURLOPT_STDERR
CURLOPT_TCP_NODELAY
CURLOPT_TELNETOPTIONS
CURLOPT_TIMECONDITION
CURLOPT_TIMEOUT
CURLOPT_TIMEVALUE
CURLOPT_TRANSFERTEXT
CURLOPT_UNRESTRICTED_AUTH
CURLOPT_UPLOAD
CURLOPT_URL
CURLOPT_USERAGENT
CURLOPT_USERPWD
CURLOPT_VERBOSE
CURLOPT_WRITEFUNCTION
CURLOPT_WRITEHEADER
CURLOPT_WRITEINFO
CURLINFO_CONNECT_TIME
CURLINFO_CONTENT_LENGTH_DOWNLOAD
CURLINFO_CONTENT_LENGTH_UPLOAD
CURLINFO_CONTENT_TYPE
CURLINFO_COOKIELIST
CURLINFO_DATA_IN
CURLINFO_DATA_OUT
CURLINFO_EFFECTIVE_URL
CURLINFO_END
CURLINFO_FILETIME
CURLINFO_FTP_ENTRY_PATH
CURLINFO_HEADER_IN
CURLINFO_HEADER_OUT
CURLINFO_HEADER_SIZE
CURLINFO_HTTPAUTH_AVAIL
CURLINFO_HTTP_CODE
CURLINFO_HTTP_CONNECTCODE
CURLINFO_LASTONE
CURLINFO_LASTSOCKET
CURLINFO_NAMELOOKUP_TIME
CURLINFO_NONE
CURLINFO_NUM_CONNECTS
CURLINFO_OS_ERRNO
CURLINFO_PRETRANSFER_TIME
CURLINFO_PRIVATE
CURLINFO_PROXYAUTH_AVAIL
CURLINFO_REDIRECT_COUNT
CURLINFO_REDIRECT_TIME
CURLINFO_REQUEST_SIZE
CURLINFO_RESPONSE_CODE
CURLINFO_SIZE_DOWNLOAD
CURLINFO_SIZE_UPLOAD
CURLINFO_SPEED_DOWNLOAD
CURLINFO_SPEED_UPLOAD
CURLINFO_SSL_DATA_IN
CURLINFO_SSL_DATA_OUT
CURLINFO_SSL_ENGINES
CURLINFO_SSL_VERIFYRESULT
CURLINFO_STARTTRANSFER_TIME
CURLINFO_TEXT
CURLINFO_TOTAL_TIME
);

$WWW::Curl::Easy::headers = "";
$WWW::Curl::Easy::content = "";

sub AUTOLOAD {

    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.

    ( my $constname = $AUTOLOAD ) =~ s/.*:://;
    return constant( $constname, 0 );
}

1;
__END__

=head1 NAME

WWW::Curl::Easy - Perl extension interface for libcurl

=head1 SYNOPSIS

    use WWW::Curl::Easy;
    my $curl = new WWW::Curl::Easy;
    $curl->setopt(CURLOPT_URL, 'http://oook.de');
    $curl->perform;
    my $err = $curl->errbuf;
    my $info = $curl->getinfo(CURLINFO_HTTP_CODE);

=head1 DESCRIPTION

WWW::Curl::Easy is a Perl extension interface for libcurl.

=head1 METHODS

    $curl = new WWW::Curl::Easy
        This method constructs a new WWW::Curl::Easy object.

    $curl->setopt( CURLOPT_OPTION, $option )
        This method sets a curl option in the object.

    $curl->perform
        This method performs the object.

    $curl->errbuf
        This method returns all errors from the buffer of the object.

    $curl->getinfo( CURLINFO_OPTION )
        This method returns the requested info from the object.

=head1 CONSTANTS

    These are some short descriptions of the most common constants.
    A full list with descriptions can be found in the libcurl
    manpages, curl_easy_setopt(3) and curl_easy_getinfo(3).
    This binding resembles the C one, so it should be OK to study the
    regular libcurl C/C++ API documentation.

    CURLOPT_URL
        The actual URL to deal with. The parameter should be a scalar.
        NOTE: this option is (the only one) required to be set before
        perform() is called.

    This is a list of all available constants.

    @CURLOPT_INCLUDE@

=head1 AUTHOR

Version 3.1 has backwards compatibility to v2 & added some support for
pre-multi versions of libcurl

Version 3.00 has many new features, new module names and a better
documentation, by Sebastian Riedel.

Version 2.00 of WWW::Curl::easy is a renaming of the previous version
(named Curl::easy), to follow CPAN naming guidelines, by Cris Bailiff.

Versions 1.30, a (hopefully) threadable, object-oriented,
multiple-callback compatible version of Curl::easy was substantially
reworked from the previous Curl::easy release (1.21) by Cris Bailiff.

Original Author Georg Horn <horn@koblenz-net.de>, with additional callback,
pod and test work by Cris Bailiff <c.bailiff+curl@devsecure.com> and
Forrest Cahoon <forrest.cahoon@merrillcorp.com>

Currently maintained by Cris Bailiff <c.bailiff+curl@devsecure.com>

=head1 COPYRIGHT

Copyright (C) 2000,2001,2002,2003,2004 Daniel Stenberg, Cris Bailiff,
Sebastian Riedel, et al.
 
You may opt to use, copy, modify, merge, publish, distribute and/or sell
copies of the Software, and permit persons to whom the Software is furnished
to do so, under the terms of the MPL or the MIT/X-derivate licenses. You may
pick one of these licenses.

=head1 SEE ALSO

WWW::Curl, WWW::Curl::Multi, curl_easy_setopt(3), curl_easy_getinfo(3),
http://curl.haxx.se/
