<?php
/**
 * $Horde: kronolith/editeventaction.php,v 1.53.12.1 2005/05/04 08:06:53 jan Exp $
 *
 * Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

@define('KRONOLITH_BASE', dirname(__FILE__));
require_once KRONOLITH_BASE . '/lib/base.php';

$url = Util::getFormData('url');

if (!Util::getFormData('cancel')) {
    if (Util::getFormData('delete')) {
        $delurl = 'delevent.php';
        Util::addParameter($delurl, 'eventID', Util::getFormData('eventID'));
        Util::addParameter($delurl, 'calendar', Util::getFormData('existingcalendar'));
        $location = Horde::applicationUrl($delUrl);
        if (!empty($url)) {
            $location = Util::addParameter($location, 'url', $url);
        }
        if ($timestamp = Util::getFormData('timestamp')) {
            $location = Util::addParameter($location, 'timestamp', $timestamp);
        }
        header('Location: ' . $location);
    } else {
        $source = Util::getFormData('existingcalendar');
        $target = Util::getFormData('targetcalendar');
        $share = &$kronolith_shares->getShare($target);

        if (is_a($share, 'PEAR_Error')) {
            $notification->push(sprintf(_("There was an error accessing the calendar: %s"), $share->getMessage()), 'horde.error');
        } else {
            if (Util::getFormData('saveAsNew')) {
                $kronolith->open($target);
                $event = &$kronolith->getEvent();

                // Don't go back to the old event.
                unset($url);
            } else {
                if ($target != $source) {
                    // Only delete the event from the source calendar
                    // if this user has permissions to do so.
                    $sourceShare = &$kronolith_shares->getShare($source);
                    if (!is_a($share, 'PEAR_Error') && !is_a($sourceShare, 'PEAR_Error') &&
                        $sourceShare->hasPermission(Auth::getAuth(), PERMS_DELETE) &&
                        $share->hasPermission(Auth::getAuth(), PERMS_EDIT)) {
                        $kronolith->open($source);
                        $res = $kronolith->move(Util::getFormData('eventID'), $target);
                        if (is_a($res, 'PEAR_Error')) {
                            $notification->push(sprintf(_("There was an error moving the event: %s"), $res->getMessage()), 'horde.error');
                        }
                        $kronolith->close();
                    }

                    $kronolith->open($target);
                    $event = &$kronolith->getEvent(Util::getFormData('eventID'));
                } else {
                    $kronolith->open($source);
                    $event = &$kronolith->getEvent(Util::getFormData('eventID'));
                }
            }

            if (!$share->hasPermission(Auth::getAuth(), PERMS_EDIT, $event->getCreatorID())) {
                $notification->push(_("You do not have permission to edit this event."), 'horde.warning');
            } else {
                $event->readForm();
                $res = $event->save();
                if (is_a($res, 'PEAR_Error')) {
                    $notification->push(sprintf(_("There was an error editing the event: %s"), $res->getMessage()), 'horde.error');
                } elseif (Util::getFormData('sendupdates', false)) {
                    Kronolith::sendITipNotifications($event, $notification, KRONOLITH_ITIP_REQUEST);
                }
            }
        }
    }
}

if (!empty($url)) {
    $location = Horde::applicationUrl($url, true);
} else {
    $url = Util::addParameter($prefs->getValue('defaultview') . '.php', 'month', Util::getFormData('month'));
    $url = Util::addParameter($url, 'year', Util::getFormData('year'));
    $location = Horde::applicationUrl($url, true);
}

// Make sure URL is unique.
$location = Util::addParameter($location, 'unique', md5(microtime()));

header('Location: ' . $location);
