(define-interface test-base-interface
  (export add-test!
	  add-test-multiple!
	  test-all
	  test-group
	  test-single
	  test-single/args
	  test-summary))

(define-structure test-base test-base-interface
  (open scsh
	scheme
	list-lib
	define-record-types)
  (files test-base))

(define-structure file-system-test (export)
  (open scsh
	scheme
	test-base)
  (files file-system-tests))

(define-structure process-state-test (export)
  (open scsh
	scheme
	test-base)
  (files process-state-tests))

(define-structure env-test 
  (export   
   setenv-test
   getenv-test
   env->alist-test
   alist->env-test
   alist-delete-test
   alist-update-test
   alist-compress-test
   with-env*-test
   with-total-env*-test
   home-directory-test
   exec-path-list-test
   add-before-test
   add-after-test)
  (open scsh
	scheme
 	thread-fluids
	list-lib
	string-lib)
  (files env-test-code))
  
(define-structure add-env-test
  (export)
  (open scsh
	scheme
	test-base
        env-test)
  (files env-test-add))

(define-structure test-all
  (export test-all)
  (open scheme
	test-base
	add-env-test
	process-state-test
	file-system-test))

    
	
