/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.paul;

import de.tu_darmstadt.sp.paul.CharStream;
import de.tu_darmstadt.sp.paul.PDFArray;
import de.tu_darmstadt.sp.paul.PDFBinString;
import de.tu_darmstadt.sp.paul.PDFBool;
import de.tu_darmstadt.sp.paul.PDFCharStream;
import de.tu_darmstadt.sp.paul.PDFDictionary;
import de.tu_darmstadt.sp.paul.PDFInputStream;
import de.tu_darmstadt.sp.paul.PDFInteger;
import de.tu_darmstadt.sp.paul.PDFName;
import de.tu_darmstadt.sp.paul.PDFObject;
import de.tu_darmstadt.sp.paul.PDFParserConstants;
import de.tu_darmstadt.sp.paul.PDFParserException;
import de.tu_darmstadt.sp.paul.PDFParserTokenManager;
import de.tu_darmstadt.sp.paul.PDFReal;
import de.tu_darmstadt.sp.paul.PDFReference;
import de.tu_darmstadt.sp.paul.PDFReferenceContainer;
import de.tu_darmstadt.sp.paul.PDFTextString;
import de.tu_darmstadt.sp.paul.ParseException;
import de.tu_darmstadt.sp.paul.Token;
import de.tu_darmstadt.sp.paul.XRefTable;
import de.tu_darmstadt.sp.util.BufferedRandomFileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

class PDFParser
implements PDFParserConstants {
    PDFCharStream charStream;
    PDFDictionary trailer;
    XRefTable xref;
    public PDFParserTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[7];
    private final int[] jj_la1_0;
    private final int[] jj_la1_1;
    private final JJCalls[] jj_2_rtns;
    private boolean jj_rescan;
    private int jj_gc;
    private Vector jj_expentries;
    private int[] jj_expentry;
    private int jj_kind;
    private int[] jj_lasttokens;
    private int jj_endpos;

    public PDFParser(CharStream stream) {
        int[] nArray = new int[7];
        nArray[0] = 65568;
        nArray[1] = -2147438578;
        nArray[2] = -2147438578;
        nArray[4] = -2147438578;
        nArray[5] = 4096;
        nArray[6] = 4096;
        this.jj_la1_0 = nArray;
        int[] nArray2 = new int[7];
        nArray2[1] = 0xA08000;
        nArray2[2] = 0xA08000;
        nArray2[3] = 32768;
        nArray2[4] = 0xA08000;
        this.jj_la1_1 = nArray2;
        this.jj_2_rtns = new JJCalls[1];
        this.jj_rescan = false;
        this.jj_gc = 0;
        this.jj_expentries = new Vector();
        this.jj_kind = -1;
        this.jj_lasttokens = new int[100];
        this.token_source = new PDFParserTokenManager(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 7) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public PDFParser(PDFParserTokenManager tm) {
        int[] nArray = new int[7];
        nArray[0] = 65568;
        nArray[1] = -2147438578;
        nArray[2] = -2147438578;
        nArray[4] = -2147438578;
        nArray[5] = 4096;
        nArray[6] = 4096;
        this.jj_la1_0 = nArray;
        int[] nArray2 = new int[7];
        nArray2[1] = 0xA08000;
        nArray2[2] = 0xA08000;
        nArray2[3] = 32768;
        nArray2[4] = 0xA08000;
        this.jj_la1_1 = nArray2;
        this.jj_2_rtns = new JJCalls[1];
        this.jj_rescan = false;
        this.jj_gc = 0;
        this.jj_expentries = new Vector();
        this.jj_kind = -1;
        this.jj_lasttokens = new int[100];
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 7) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public PDFParser(BufferedRandomFileInputStream inStream, int startXref) throws IOException {
        int[] nArray = new int[7];
        nArray[0] = 65568;
        nArray[1] = -2147438578;
        nArray[2] = -2147438578;
        nArray[4] = -2147438578;
        nArray[5] = 4096;
        nArray[6] = 4096;
        this.jj_la1_0 = nArray;
        int[] nArray2 = new int[7];
        nArray2[1] = 0xA08000;
        nArray2[2] = 0xA08000;
        nArray2[3] = 32768;
        nArray2[4] = 0xA08000;
        this.jj_la1_1 = nArray2;
        this.jj_2_rtns = new JJCalls[1];
        this.jj_rescan = false;
        this.jj_gc = 0;
        this.jj_expentries = new Vector();
        this.jj_kind = -1;
        this.jj_lasttokens = new int[100];
        this.charStream = new PDFCharStream(inStream);
        this.ReInit(new PDFParserTokenManager(this.charStream));
        try {
            this.xref = new XRefTable();
            this.charStream.seek(startXref);
            this.parseTrailer();
        }
        catch (ParseException e) {
            throw new PDFParserException(e.getMessage());
        }
    }

    public final PDFArray Array() throws ParseException {
        PDFArray result = new PDFArray();
        this.jj_consume_token(53);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block3;
                }
                case 1: 
                case 2: 
                case 3: 
                case 12: 
                case 13: 
                case 15: 
                case 31: 
                case 47: 
                case 53: 
                case 55: {
                    PDFObject elem = this.ObjectOrReference();
                    result.add(elem);
                    continue block3;
                }
            }
            break;
        }
        this.jj_consume_token(54);
        return result;
    }

    public final PDFDictionary Dictionary() throws ParseException {
        PDFDictionary result = new PDFDictionary();
        this.jj_consume_token(55);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block3;
                }
                case 47: {
                    Token key = this.jj_consume_token(47);
                    PDFObject value = this.ObjectOrReference();
                    result.put(PDFName.forString(key.image), value);
                    continue block3;
                }
            }
            break;
        }
        this.jj_consume_token(56);
        return result;
    }

    public final PDFObject IndirectObject() throws ParseException {
        this.jj_consume_token(12);
        this.jj_consume_token(12);
        this.jj_consume_token(4);
        PDFObject result = this.Object();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                this.jj_consume_token(5);
                return result;
            }
            case 16: {
                this.jj_consume_token(16);
                if (!(result instanceof PDFDictionary)) {
                    throw new ParseException("stream after non-dictionary.");
                }
                return new PDFInputStream((PDFDictionary)result, this.charStream);
            }
        }
        this.jj_la1[0] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final PDFObject Object() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                this.jj_consume_token(1);
                return PDFObject.NULL;
            }
            case 2: {
                this.jj_consume_token(2);
                return new PDFBool(true);
            }
            case 3: {
                this.jj_consume_token(3);
                return new PDFBool(false);
            }
            case 12: {
                Token tok = this.jj_consume_token(12);
                return PDFInteger.forInt(Integer.parseInt(tok.image));
            }
            case 13: {
                Token tok = this.jj_consume_token(13);
                return new PDFReal(tok.image);
            }
            case 31: {
                Token tok = this.jj_consume_token(31);
                return new PDFTextString(tok.image);
            }
            case 15: {
                Token tok = this.jj_consume_token(15);
                return new PDFBinString(tok.image.substring(1, tok.image.length() - 1), null);
            }
            case 47: {
                Token tok = this.jj_consume_token(47);
                return PDFName.forString(tok.image);
            }
            case 53: {
                PDFArray array = this.Array();
                return array;
            }
            case 55: {
                PDFDictionary dict = this.Dictionary();
                return dict;
            }
        }
        this.jj_la1[1] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final PDFObject ObjectOrReference() throws ParseException {
        if (this.jj_2_1(3)) {
            Token int1 = this.jj_consume_token(12);
            Token int2 = this.jj_consume_token(12);
            this.jj_consume_token(57);
            return new PDFReference(Integer.parseInt(int1.image), Integer.parseInt(int2.image));
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 12: 
            case 13: 
            case 15: 
            case 31: 
            case 47: 
            case 53: 
            case 55: {
                PDFObject result = this.Object();
                return result;
            }
        }
        this.jj_la1[4] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public void ReInit(CharStream stream) {
        this.token_source.ReInit(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 7) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public void ReInit(PDFParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 7) {
            this.jj_la1[i] = -1;
            ++i;
        }
        int i2 = 0;
        while (i2 < this.jj_2_rtns.length) {
            this.jj_2_rtns[i2] = new JJCalls();
            ++i2;
        }
    }

    public final PDFDictionary Trailer() throws ParseException {
        this.jj_consume_token(7);
        PDFDictionary result = this.Dictionary();
        this.jj_consume_token(9);
        this.jj_consume_token(12);
        this.jj_consume_token(10);
        return result;
    }

    public final void Xref(XRefTable xref) throws ParseException {
        this.jj_consume_token(8);
        this.XrefSection(xref);
    }

    public final void XrefSection(XRefTable xref) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 12: {
                Token tok1 = this.jj_consume_token(12);
                int i = Integer.parseInt(tok1.image);
                Token tok2 = this.jj_consume_token(12);
                int max = i + Integer.parseInt(tok2.image);
                block6: while (true) {
                    tok1 = this.jj_consume_token(12);
                    tok2 = this.jj_consume_token(12);
                    Token tok3 = this.jj_consume_token(11);
                    long filePos = Long.parseLong(tok1.image);
                    int genNr = Integer.parseInt(tok2.image);
                    char nf = tok3.image.charAt(0);
                    xref.put(filePos, i, genNr, nf);
                    if (++i >= max) {
                        this.XrefSection(xref);
                        return;
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 12: {
                            continue block6;
                        }
                    }
                    break;
                }
                this.jj_la1[5] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
    }

    public final void disable_tracing() {
    }

    public final void enable_tracing() {
    }

    public final ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[58];
        int i = 0;
        while (i < 58) {
            la1tokens[i] = false;
            ++i;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int i2 = 0;
        while (i2 < 7) {
            if (this.jj_la1[i2] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((this.jj_la1_0[i2] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    if ((this.jj_la1_1[i2] & 1 << j) != 0) {
                        la1tokens[32 + j] = true;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < 58) {
            if (la1tokens[i3]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i3;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i3;
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i4 = 0;
        while (i4 < this.jj_expentries.size()) {
            exptokseq[i4] = (int[])this.jj_expentries.elementAt(i4);
            ++i4;
        }
        return new ParseException(this.token, exptokseq, PDFParserConstants.tokenImage);
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    PDFObject getObj(PDFReference ref) throws IOException, ParseException {
        if (this.xref.containsJavaP(ref)) {
            return this.xref.getJavaP(ref);
        }
        if (!this.xref.containsFileP(ref)) {
            return PDFObject.NULL;
        }
        PDFObject result = this.parseObj(ref);
        this.resolveObject(result);
        result.setIndirect();
        return result;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    public PDFDictionary getTrailer() {
        return this.trailer;
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = this.jj_3_1() ^ true;
        this.jj_save(0, xla);
        return retval;
    }

    private final boolean jj_3_1() {
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(12)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(57)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            int i = 0;
            while (i < this.jj_endpos) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
                ++i;
            }
            boolean exists = false;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] oldentry = (int[])enumeration.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                int i2 = 0;
                while (i2 < this.jj_expentry.length) {
                    if (oldentry[i2] != this.jj_expentry[i2]) {
                        exists = false;
                        break;
                    }
                    ++i2;
                }
                if (exists) break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                int i = 0;
                while (i < this.jj_2_rtns.length) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                    ++i;
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        int i = 0;
        while (i < 1) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                }
            } while ((p = p.next) != null);
            ++i;
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        return this.jj_scanpos.kind != kind;
    }

    public PDFObject parseObj(PDFReference ref) throws IOException, ParseException {
        this.charStream.seek(this.xref.getFileP(ref));
        this.ReInit(this.charStream);
        PDFObject result = this.IndirectObject();
        this.xref.put(ref, result);
        return result;
    }

    void parseTrailer() throws IOException, ParseException {
        this.Xref(this.xref);
        PDFDictionary current = this.trailer = this.Trailer();
        PDFName prev = PDFName.PREV;
        while (current.containsKey(prev)) {
            int prevPos = ((PDFInteger)current.get(prev)).intValue();
            this.charStream.seek(prevPos);
            this.Xref(this.xref);
            current = this.Trailer();
        }
        if (this.trailer.containsKey(prev)) {
            this.trailer.remove(prev);
        }
        this.resolveObject(this.trailer);
    }

    public void resolveObject(PDFObject obj) throws IOException, ParseException {
        if (obj instanceof PDFReferenceContainer) {
            ((PDFReferenceContainer)obj).resolveReferences(this);
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

