<?php
/**
 * The Kronolith_Day:: class provides an API for dealing with days.
 *
 * $Horde: kronolith/lib/Day.php,v 1.26.10.1 2005/04/21 11:27:03 selsky Exp $
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @since   Kronolith 0.1
 * @package Kronolith
 */
class Kronolith_Day extends Horde_Date {

    var $hours;

    function Kronolith_Day($month = null, $day = null, $year = null)
    {
        if (empty($month)) {
            $month = date('n');
        }
        if (empty($year)) {
            $year = date('Y');
        }
        if (empty($day)) {
            $day = date('j');
        }

        $this->Horde_Date(array('year' => $year, 'month' => $month, 'mday' => $day));
        $this->correct();

        // Make the data array.
        $this->makeHours();
    }

    function makeHours()
    {
        $this->hours = array();

        $row = 0;
        for ($i = 0; $i < 48; $i++) {
            $this->hours[$i]['timestamp'] = mktime(0, $i * 30, 0, $this->month, $this->mday, $this->year);
        }
    }

    function getTime($format, $offset = 0)
    {
        return strftime($format,
                        mktime(0, 0, 0, $this->month, ($this->mday + $offset), $this->year));
    }

    function getTomorrow()
    {
        return mktime(0, 0, 0, $this->month, $this->mday + 1, $this->year);
    }

    function getStamp()
    {
        return mktime(0, 0, 0, $this->month, $this->mday, $this->year);
    }

    function isToday()
    {
        return (mktime(0, 0, 0, $this->month, $this->mday, $this->year) == mktime(0, 0, 0));
    }

    function isTomorrow()
    {
        return (mktime(0, 0, 0, $this->month, $this->mday - 1, $this->year) == mktime(0, 0, 0));
    }

    function diff()
    {
        $day2 = &new Kronolith_Day();
        return Date_Calc::dateDiff($this->mday, $this->month, $this->year,
                                   $day2->mday, $day2->month, $day2->year);
    }

}
