/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.authenticator.SavedRequest;
import org.apache.catalina.deploy.LoginConfig;

public class FormAuthenticator
extends AuthenticatorBase {
    protected static final String info = "org.apache.catalina.authenticator.FormAuthenticator/1.0";

    public String getInfo() {
        return info;
    }

    public boolean authenticate(HttpRequest request, HttpResponse response, LoginConfig config) throws IOException {
        boolean loginAction;
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        Session session = null;
        Principal principal = hreq.getUserPrincipal();
        String ssoId = (String)request.getNote("org.apache.catalina.request.SSOID");
        if (principal != null) {
            if (this.debug >= 1) {
                this.log("Already authenticated '" + principal.getName() + "'");
            }
            if (ssoId != null) {
                this.associate(ssoId, this.getSession(request, true));
            }
            return true;
        }
        if (ssoId != null) {
            if (this.debug >= 1) {
                this.log("SSO Id " + ssoId + " set; attempting reauthentication");
            }
            if (this.reauthenticateFromSSO(ssoId, request)) {
                return true;
            }
        }
        if (!this.cache) {
            session = this.getSession(request, true);
            if (this.debug >= 1) {
                this.log("Checking for reauthenticate in session " + session);
            }
            String username = (String)session.getNote("org.apache.catalina.session.USERNAME");
            String password = (String)session.getNote("org.apache.catalina.session.PASSWORD");
            if (username != null && password != null) {
                if (this.debug >= 1) {
                    this.log("Reauthenticating username '" + username + "'");
                }
                if ((principal = this.context.getRealm().authenticate(username, password)) != null) {
                    session.setNote("org.apache.catalina.authenticator.PRINCIPAL", principal);
                    this.register(request, response, principal, "FORM", username, password);
                    return true;
                }
                if (this.debug >= 1) {
                    this.log("Reauthentication failed, proceed normally");
                }
            }
        }
        if (this.matchRequest(request)) {
            session = this.getSession(request, true);
            if (this.debug >= 1) {
                this.log("Restore request from session '" + session.getId() + "'");
            }
            principal = (Principal)session.getNote("org.apache.catalina.authenticator.PRINCIPAL");
            this.register(request, response, principal, "FORM", (String)session.getNote("org.apache.catalina.session.USERNAME"), (String)session.getNote("org.apache.catalina.session.PASSWORD"));
            if (this.restoreRequest(request, session)) {
                if (this.debug >= 1) {
                    this.log("Proceed to restored request");
                }
                return true;
            }
            if (this.debug >= 1) {
                this.log("Restore of original request failed");
            }
            hres.sendError(400);
            return false;
        }
        String contextPath = hreq.getContextPath();
        String requestURI = request.getDecodedRequestURI();
        response.setContext(request.getContext());
        String loginURI = contextPath + config.getLoginPage();
        if (requestURI.equals(loginURI)) {
            if (this.debug >= 1) {
                this.log("Requesting login page normally");
            }
            return true;
        }
        String errorURI = contextPath + config.getErrorPage();
        if (requestURI.equals(errorURI)) {
            if (this.debug >= 1) {
                this.log("Requesting error page normally");
            }
            return true;
        }
        boolean bl = loginAction = requestURI.startsWith(contextPath) && requestURI.endsWith("/j_security_check");
        if (!loginAction) {
            session = this.getSession(request, true);
            if (this.debug >= 1) {
                this.log("Save request in session '" + session.getId() + "'");
            }
            this.saveRequest(request, session);
            if (this.debug >= 1) {
                this.log("Redirect to login page '" + loginURI + "'");
            }
            hres.sendRedirect(hres.encodeRedirectURL(loginURI));
            return false;
        }
        Realm realm = this.context.getRealm();
        String username = hreq.getParameter("j_username");
        String password = hreq.getParameter("j_password");
        if (this.debug >= 1) {
            this.log("Authenticating username '" + username + "'");
        }
        if ((principal = realm.authenticate(username, password)) == null) {
            if (this.debug >= 1) {
                this.log("Redirect to error page '" + errorURI + "'");
            }
            hres.sendRedirect(hres.encodeRedirectURL(errorURI));
            return false;
        }
        if (this.debug >= 1) {
            this.log("Authentication of '" + username + "' was successful");
        }
        if (session == null) {
            session = this.getSession(request, false);
        }
        if (session == null) {
            if (this.debug >= 1) {
                this.log("User took so long to log on the session expired");
            }
            hres.sendError(408, sm.getString("authenticator.sessionExpired"));
            return false;
        }
        session.setNote("org.apache.catalina.authenticator.PRINCIPAL", principal);
        if (!this.cache) {
            session.setNote("org.apache.catalina.session.USERNAME", username);
            session.setNote("org.apache.catalina.session.PASSWORD", password);
        }
        requestURI = this.savedRequestURL(session);
        if (this.debug >= 1) {
            this.log("Redirecting to original '" + requestURI + "'");
        }
        if (requestURI == null) {
            hres.sendError(400, sm.getString("authenticator.formlogin"));
        } else {
            hres.sendRedirect(hres.encodeRedirectURL(requestURI));
        }
        return false;
    }

    protected boolean matchRequest(HttpRequest request) {
        Session session = this.getSession(request, false);
        if (session == null) {
            return false;
        }
        SavedRequest sreq = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        if (sreq == null) {
            return false;
        }
        if (session.getNote("org.apache.catalina.authenticator.PRINCIPAL") == null) {
            return false;
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        String requestURI = hreq.getRequestURI();
        if (requestURI == null) {
            return false;
        }
        return requestURI.equals(sreq.getRequestURI());
    }

    protected boolean restoreRequest(HttpRequest request, Session session) {
        SavedRequest saved = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        session.removeNote("org.apache.catalina.authenticator.REQUEST");
        session.removeNote("org.apache.catalina.authenticator.PRINCIPAL");
        if (saved == null) {
            return false;
        }
        request.clearCookies();
        Iterator cookies = saved.getCookies();
        while (cookies.hasNext()) {
            request.addCookie((Cookie)cookies.next());
        }
        request.clearHeaders();
        Iterator names = saved.getHeaderNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            Iterator values = saved.getHeaderValues(name);
            while (values.hasNext()) {
                request.addHeader(name, (String)values.next());
            }
        }
        request.clearLocales();
        Iterator locales = saved.getLocales();
        while (locales.hasNext()) {
            request.addLocale((Locale)locales.next());
        }
        request.clearParameters();
        if ("POST".equalsIgnoreCase(saved.getMethod())) {
            Iterator paramNames = saved.getParameterNames();
            while (paramNames.hasNext()) {
                String paramName = (String)paramNames.next();
                String[] paramValues = saved.getParameterValues(paramName);
                request.addParameter(paramName, paramValues);
            }
        }
        request.setMethod(saved.getMethod());
        request.setQueryString(saved.getQueryString());
        request.setRequestURI(saved.getRequestURI());
        return true;
    }

    private void saveRequest(HttpRequest request, Session session) {
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        SavedRequest saved = new SavedRequest();
        Cookie[] cookies = hreq.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                saved.addCookie(cookies[i]);
            }
        }
        Enumeration names = hreq.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = hreq.getHeaders(name);
            while (values.hasMoreElements()) {
                String value = (String)values.nextElement();
                saved.addHeader(name, value);
            }
        }
        Enumeration locales = hreq.getLocales();
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            saved.addLocale(locale);
        }
        Map parameters = hreq.getParameterMap();
        Iterator paramNames = parameters.keySet().iterator();
        while (paramNames.hasNext()) {
            String paramName = (String)paramNames.next();
            String[] paramValues = (String[])parameters.get(paramName);
            saved.addParameter(paramName, paramValues);
        }
        saved.setMethod(hreq.getMethod());
        saved.setQueryString(hreq.getQueryString());
        saved.setRequestURI(hreq.getRequestURI());
        session.setNote("org.apache.catalina.authenticator.REQUEST", saved);
    }

    private String savedRequestURL(Session session) {
        SavedRequest saved = (SavedRequest)session.getNote("org.apache.catalina.authenticator.REQUEST");
        if (saved == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(saved.getRequestURI());
        if (saved.getQueryString() != null) {
            sb.append('?');
            sb.append(saved.getQueryString());
        }
        return sb.toString();
    }
}

