/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.commands;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.xsd.ui.internal.common.commands.BaseCommand;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDCommonUIUtils;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Text;

public class AddXSDAttributeGroupDefinitionCommand
extends BaseCommand {
    XSDComplexTypeDefinition xsdComplexTypeDefinition;
    XSDSchema xsdSchema;
    ArrayList names;

    public AddXSDAttributeGroupDefinitionCommand(String label, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        super(label);
        this.xsdComplexTypeDefinition = xsdComplexTypeDefinition;
    }

    public AddXSDAttributeGroupDefinitionCommand(String label, XSDSchema xsdSchema) {
        super(label);
        this.xsdSchema = xsdSchema;
    }

    public void execute() {
        XSDAttributeGroupDefinition attributeGroup = XSDFactory.eINSTANCE.createXSDAttributeGroupDefinition();
        if (this.xsdSchema == null) {
            attributeGroup.setName(this.getNewName("AttributeGroup"));
            EList list = this.xsdComplexTypeDefinition.getSchema().getAttributeGroupDefinitions();
            if (list.size() > 0) {
                attributeGroup.setResolvedAttributeGroupDefinition((XSDAttributeGroupDefinition)list.get(0));
            } else {
                attributeGroup.setName(null);
                XSDAttributeGroupDefinition attributeGroup2 = XSDFactory.eINSTANCE.createXSDAttributeGroupDefinition();
                attributeGroup2.setName(XSDCommonUIUtils.createUniqueElementName("NewAttributeGroup", (List)this.xsdComplexTypeDefinition.getSchema().getAttributeGroupDefinitions()));
                this.xsdComplexTypeDefinition.getSchema().getContents().add((Object)attributeGroup2);
                attributeGroup.setResolvedAttributeGroupDefinition(attributeGroup2);
            }
            if (this.xsdComplexTypeDefinition.getAttributeContents() != null) {
                this.xsdComplexTypeDefinition.getAttributeContents().add((Object)attributeGroup);
            }
            this.addedXSDConcreteComponent = attributeGroup;
        } else {
            AddXSDAttributeGroupDefinitionCommand.ensureSchemaElement(this.xsdSchema);
            attributeGroup.setName(XSDCommonUIUtils.createUniqueElementName("NewAttributeGroup", (List)this.xsdSchema.getAttributeGroupDefinitions()));
            Text textNode = this.xsdSchema.getDocument().createTextNode("\n");
            this.xsdSchema.getElement().appendChild(textNode);
            this.xsdSchema.getContents().add((Object)attributeGroup);
            this.addedXSDConcreteComponent = attributeGroup;
        }
    }

    protected String getNewName(String description) {
        String candidateName = "New" + description;
        XSDComplexTypeDefinition parent = this.xsdComplexTypeDefinition;
        this.names = new ArrayList();
        int i = 1;
        if (parent instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition ct = parent;
            this.walkUpInheritance(ct);
            boolean ready = false;
            while (!ready) {
                ready = true;
                Iterator iter = this.names.iterator();
                while (iter.hasNext()) {
                    String attrName = (String)iter.next();
                    if (!candidateName.equals(attrName)) continue;
                    ready = false;
                    candidateName = "New" + description + String.valueOf(i);
                    ++i;
                }
            }
        }
        return candidateName;
    }

    private void walkUpInheritance(XSDComplexTypeDefinition ct) {
        this.updateNames(ct);
        XSDTypeDefinition typeDef = ct.getBaseTypeDefinition();
        if (ct != ct.getRootType() && typeDef instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition ct2 = (XSDComplexTypeDefinition)typeDef;
            this.walkUpInheritance(ct2);
        }
    }

    private void updateNames(XSDComplexTypeDefinition ct) {
        Iterator iter = ct.getAttributeContents().iterator();
        while (iter.hasNext()) {
            XSDAttributeUse use;
            XSDAttributeDeclaration attr;
            String attrName;
            Object obj = iter.next();
            if (!(obj instanceof XSDAttributeUse) || (attrName = (attr = (use = (XSDAttributeUse)obj).getAttributeDeclaration()).getName()) == null) continue;
            this.names.add(attrName);
        }
    }
}

