/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class WTPProjectUtilities {
    static /* synthetic */ Class class$0;

    public static void addOldNatureToProject(IProject proj, String natureId) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        boolean addNature = true;
        int i = 0;
        while (i < prevNatures.length) {
            String nature = prevNatures[i];
            if (nature.equals(natureId)) {
                addNature = false;
                break;
            }
            ++i;
        }
        if (addNature) {
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 1, prevNatures.length);
            newNatures[0] = natureId;
            description.setNatureIds(newNatures);
            proj.setDescription(description, 64, null);
        }
    }

    public static void addOldNatureToProject(IProject proj, String natureId, int index) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        boolean addNature = true;
        int i = 0;
        while (i < prevNatures.length) {
            String nature = prevNatures[i];
            if (nature.equals(natureId)) {
                addNature = false;
                break;
            }
            ++i;
        }
        if (addNature) {
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, index);
            newNatures[index] = natureId;
            System.arraycopy(prevNatures, index, newNatures, index + 1, prevNatures.length - index);
            description.setNatureIds(newNatures);
            proj.setDescription(description, 64, null);
        }
    }

    public static void addNatureToProject(IProject proj, String natureId) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 1, prevNatures.length);
        newNatures[0] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, null);
    }

    public static void addNatureToProjectLast(IProject proj, String natureId) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, null);
    }

    public static void removeNatureFromProject(IProject project, String natureId) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        int size = prevNatures.length;
        int newsize = 0;
        String[] newNatures = new String[size];
        boolean matchfound = false;
        int i = 0;
        while (i < size) {
            if (prevNatures[i].equals(natureId)) {
                matchfound = true;
            } else {
                newNatures[newsize++] = prevNatures[i];
            }
            ++i;
        }
        if (!matchfound) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.common.frameworks", 0, "The nature id " + natureId + " does not exist on the project " + project.getName(), null));
        }
        String[] temp = newNatures;
        newNatures = new String[newsize];
        System.arraycopy(temp, 0, newNatures, 0, newsize);
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
    }

    public static IProject getProject(Object object) {
        IProject result = null;
        if (object instanceof IProject) {
            result = (IProject)object;
        } else if (object instanceof IResource) {
            result = ((IResource)object).getProject();
        } else if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            result = (IProject)iAdaptable.getAdapter((Class)clazz);
        }
        return result;
    }
}

