/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.ui.internal.common.taginfo;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.javascript.ui.internal.common.Logger;
import org.eclipse.wst.javascript.ui.internal.common.taginfo.JavaScriptTagInfoProvider;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.taginfo.AbstractHoverProcessor;

public class JavaScriptTagInfoHoverProcessor
extends AbstractHoverProcessor {
    protected static final char chEndBracket = ']';
    protected static final char chEndBrace = ')';
    protected static final char chBeginBracket = '[';
    protected static final char chBeginBrace = '(';
    protected static final char chPeriod = '.';
    protected JavaScriptTagInfoProvider tagInfoProvider = null;

    protected IStructuredDocumentRegion getStructuredDocumentRegion(StructuredTextViewer viewer, int offset) {
        IStructuredDocumentRegion flatNode = null;
        if (viewer != null && viewer.getDocument() != null) {
            flatNode = ((IStructuredDocument)viewer.getDocument()).getRegionAtCharacterOffset(offset);
        }
        return flatNode;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (textViewer instanceof StructuredTextViewer) {
            StructuredTextViewer viewer = (StructuredTextViewer)textViewer;
            IStructuredDocumentRegion flatNode = this.getStructuredDocumentRegion(viewer, offset);
            ITextRegion region = null;
            if (flatNode != null) {
                region = flatNode.getRegionAtCharacterOffset(offset);
            }
            if (region == null || offset > flatNode.getTextEndOffset(region)) {
                return null;
            }
        }
        try {
            IRegion line = textViewer.getDocument().getLineInformationOfOffset(offset);
            if (offset > line.getOffset() && offset < line.getOffset() + line.getLength()) {
                Region codeRegion = this.getSegmentRegion(textViewer, offset);
                if (codeRegion == null) {
                    codeRegion = new Region(offset, 0);
                }
                return codeRegion;
            }
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        return null;
    }

    public String getHoverInfo(ITextViewer viewer, IRegion hoverRegion) {
        if (hoverRegion == null || viewer == null) {
            return null;
        }
        int documentOffset = hoverRegion.getOffset();
        String displayText = null;
        displayText = this.computeHoverHelp(viewer, documentOffset);
        return displayText;
    }

    public String computeHoverHelp(ITextViewer textViewer, int documentPosition) {
        String result = null;
        IStructuredDocumentRegion scriptNode = null;
        ITextRegion scriptRegion = null;
        Region segmentRegion = null;
        String segment = null;
        if (textViewer == null || textViewer.getDocument() == null) {
            return null;
        }
        if (textViewer instanceof StructuredTextViewer && (scriptNode = this.getStructuredDocumentRegion((StructuredTextViewer)textViewer, documentPosition)) != null) {
            scriptRegion = scriptNode.getRegionAtCharacterOffset(documentPosition);
        }
        segmentRegion = scriptRegion == null ? this.getSegmentRegion(textViewer, documentPosition) : this.getSegmentRegion(textViewer, documentPosition, scriptNode.getStartOffset(scriptRegion), scriptNode.getEndOffset(scriptRegion));
        segment = this.getSegmentString(textViewer, segmentRegion);
        result = this.getJSTagInfo(segment);
        return result;
    }

    protected String getSegmentString(ITextViewer textViewer, Region codeRegion) {
        String fullPath = null;
        if (codeRegion == null) {
            return null;
        }
        try {
            fullPath = textViewer.getDocument().get(codeRegion.getOffset(), codeRegion.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        return fullPath;
    }

    public Region getSegmentRegion(ITextViewer viewer, int docPos) {
        if (viewer == null) {
            return null;
        }
        IDocument doc = viewer.getDocument();
        return this.getSegmentRegion(viewer, docPos, 0, doc.getLength());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Region getSegmentRegion(ITextViewer viewer, int docPos, int blockBegin, int blockEnd) {
        IDocument doc = viewer.getDocument();
        int begin = -1;
        int end = -1;
        if (docPos < blockBegin) return null;
        if (docPos > blockEnd || blockBegin > blockEnd) {
            return null;
        }
        int iPos = docPos;
        try {
            char ch;
            while (iPos >= blockBegin) {
                if (iPos < docPos - 100) {
                    return null;
                }
                ch = doc.getChar(iPos);
                if (!Character.isLetterOrDigit(ch)) break;
                --iPos;
            }
            begin = iPos;
            iPos = docPos;
            while (iPos <= blockEnd) {
                if (iPos > docPos + 100) {
                    return null;
                }
                ch = doc.getChar(iPos);
                if (!Character.isLetterOrDigit(ch)) break;
                ++iPos;
            }
            end = iPos;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        if (begin == docPos && end == docPos) {
            return new Region(docPos, 0);
        }
        if (begin == docPos) {
            return new Region(begin, end - begin);
        }
        return new Region(begin + 1, end - begin - 1);
    }

    protected JavaScriptTagInfoProvider getTagInfoProvider() {
        if (this.tagInfoProvider == null) {
            this.tagInfoProvider = new JavaScriptTagInfoProvider();
        }
        return this.tagInfoProvider;
    }

    protected String getJSTagInfo(String fullPath) {
        String result = null;
        result = this.getTagInfoProvider().getTagInfo(fullPath);
        return result;
    }
}

