/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.visitor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.MessageReference;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.ui.internal.adapters.visitor.W11XSDVisitorForFields;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public class WSDLVisitorForParameters {
    public List concreteComponents = new ArrayList();
    public List thingsToListenTo = new ArrayList();

    public void visitMessageReference(MessageReference messageReference) {
        if (messageReference.getEMessage() != null) {
            this.visitMessage(messageReference.getEMessage());
        }
    }

    public void visitMessage(Message message) {
        if (message != null) {
            this.thingsToListenTo.add(message);
            EList parts = message.getEParts();
            if (parts.size() > 0) {
                this.visitPart((Part)parts.get(0));
            }
        }
    }

    void visitPart(Part part) {
        this.thingsToListenTo.add(part);
        if (part.getElementDeclaration() != null) {
            this.visitXSDElementDeclaration(part.getElementDeclaration());
        } else if (part.getTypeDefinition() instanceof XSDComplexTypeDefinition) {
            this.visitXSDComplextTypeDefinition((XSDComplexTypeDefinition)part.getTypeDefinition());
        } else {
            this.concreteComponents.add(part);
        }
    }

    void visitXSDElementDeclaration(XSDElementDeclaration ed) {
        XSDTypeDefinition td = ed.getTypeDefinition();
        if (td instanceof XSDSimpleTypeDefinition) {
            this.concreteComponents.add(ed);
        } else if (td instanceof XSDComplexTypeDefinition) {
            this.thingsToListenTo.add(ed);
            this.visitXSDComplextTypeDefinition((XSDComplexTypeDefinition)td);
        }
    }

    void visitXSDComplextTypeDefinition(XSDComplexTypeDefinition td) {
        W11XSDVisitorForFields fieldVisitor = new W11XSDVisitorForFields();
        fieldVisitor.visitComplexTypeDefinition(td);
        this.concreteComponents.addAll(fieldVisitor.getConcreteComponentList());
        this.thingsToListenTo.addAll(fieldVisitor.getThingsWeNeedToListenTo());
    }
}

