/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.design.editparts;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.Messages;
import org.eclipse.wst.wsdl.ui.internal.asd.design.connections.CenteredConnectionAnchor;
import org.eclipse.wst.wsdl.ui.internal.asd.design.connections.TopLeftConnectionAnchor;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.BaseEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.BindingColumnEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDSelectionEditPolicy;
import org.eclipse.wst.wsdl.ui.internal.asd.design.figures.BoxComponentFigure;
import org.eclipse.wst.wsdl.ui.internal.asd.design.figures.ComponentReferenceConnection;
import org.eclipse.wst.wsdl.ui.internal.asd.design.layouts.BindingColumnLayout;
import org.eclipse.wst.wsdl.ui.internal.asd.design.layouts.BindingContentLayout;
import org.eclipse.wst.wsdl.ui.internal.asd.design.layouts.BindingLayout;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IBinding;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IInterface;

public class BindingEditPart
extends BaseEditPart {
    protected ComponentReferenceConnection connectionFigure;
    protected BoxComponentFigure figure;
    protected boolean isExpanded = false;
    private Label hoverHelpLabel = new Label("");

    protected IFigure createFigure() {
        this.figure = new BoxComponentFigure();
        this.figure.getLabel().setBorder((Border)new MarginBorder(2, 2, 1, 2));
        this.figure.setBorder((Border)new LineBorder(0));
        this.figure.getContentPane().setLayoutManager((LayoutManager)new BindingContentLayout(this));
        this.figure.getContentPane().setOpaque(true);
        this.figure.getContentPane().setBackgroundColor(ColorConstants.yellow);
        this.figure.setLayoutManager((LayoutManager)new BindingLayout(this));
        return this.figure;
    }

    public IFigure getContentPane() {
        return ((BoxComponentFigure)this.getFigure()).getContentPane();
    }

    protected List getModelChildren() {
        IBinding binding = (IBinding)this.getModel();
        return this.isExpanded ? binding.getBindingContentList() : Collections.EMPTY_LIST;
    }

    public void activate() {
        super.activate();
        this.activateConnection();
    }

    public void deactivate() {
        super.deactivate();
        this.deactivateConnection();
    }

    public void addFeedback() {
        super.addFeedback();
        LineBorder boxFigureLineBorder = (LineBorder)this.figure.getBorder();
        boxFigureLineBorder.setWidth(2);
        this.figure.setSelected(true);
        this.figure.repaint();
        if (this.connectionFigure != null) {
            this.connectionFigure.setHighlight(true);
            this.getLayer("Feedback Layer").add((IFigure)this.connectionFigure);
        }
    }

    public void removeFeedback() {
        super.removeFeedback();
        LineBorder boxFigureLineBorder = (LineBorder)this.figure.getBorder();
        boxFigureLineBorder.setWidth(1);
        boxFigureLineBorder.setColor(ColorConstants.black);
        this.figure.setSelected(false);
        this.figure.repaint();
        if (this.connectionFigure != null) {
            this.connectionFigure.setHighlight(false);
            this.getLayer("Connection Layer").add((IFigure)this.connectionFigure);
        }
    }

    protected void activateConnection() {
        if (this.createConnectionFigure() != null) {
            this.getLayer("Connection Layer").add((IFigure)this.connectionFigure);
        }
    }

    protected void deactivateConnection() {
        if (this.connectionFigure != null) {
            boolean removed = false;
            removed = this.removeConnectionFigure(this.getLayer("Connection Layer"));
            if (!removed) {
                this.removeConnectionFigure(this.getLayer("Feedback Layer"));
            }
        }
    }

    private boolean removeConnectionFigure(IFigure parent) {
        boolean contains = false;
        Iterator it = parent.getChildren().iterator();
        while (it.hasNext()) {
            IFigure fig = (IFigure)it.next();
            if (!fig.equals((Object)this.connectionFigure)) continue;
            contains = true;
            break;
        }
        if (contains) {
            parent.remove((IFigure)this.connectionFigure);
        }
        return contains;
    }

    public ComponentReferenceConnection createConnectionFigure() {
        AbstractGraphicalEditPart referenceTypePart;
        IBinding binding;
        IInterface typeBeingRef;
        if (this.connectionFigure == null && this.shouldDrawConnection() && (typeBeingRef = (binding = (IBinding)this.getModel()).getInterface()) != null && (referenceTypePart = (AbstractGraphicalEditPart)this.getViewer().getEditPartRegistry().get(typeBeingRef)) != null) {
            this.connectionFigure = new ComponentReferenceConnection();
            this.refreshConnections();
        }
        return this.connectionFigure;
    }

    protected boolean shouldDrawConnection() {
        AbstractGraphicalEditPart referenceTypePart;
        if (this.isExpanded) {
            return false;
        }
        IBinding binding = (IBinding)this.getModel();
        IInterface typeBeingRef = binding.getInterface();
        return typeBeingRef != null && (referenceTypePart = (AbstractGraphicalEditPart)this.getViewer().getEditPartRegistry().get(typeBeingRef)) != null;
    }

    protected void refreshVisuals() {
        this.refreshConnections();
        if (this.getModel() instanceof IBinding) {
            IBinding binding = (IBinding)this.getModel();
            ((BoxComponentFigure)this.getFigure()).headingFigure.setIsReadOnly(((IBinding)this.getModel()).isReadOnly());
            this.figure.getLabel().setIcon(binding.getImage());
            String prependString = Messages.getString("_UI_LABEL_BINDING");
            this.hoverHelpLabel.setText(" " + prependString + " : " + binding.getName() + " ");
            this.figure.setToolTip((IFigure)this.hoverHelpLabel);
        }
        super.refreshVisuals();
    }

    protected AbstractGraphicalEditPart getConnectionTargetEditPart() {
        IBinding binding = (IBinding)this.getModel();
        IInterface typeBeingRef = binding.getInterface();
        if (this.connectionFigure != null) {
            AbstractGraphicalEditPart referenceTypePart = (AbstractGraphicalEditPart)this.getViewer().getEditPartRegistry().get(typeBeingRef);
            return referenceTypePart;
        }
        return null;
    }

    public void refreshConnections() {
        if (this.shouldDrawConnection()) {
            IBinding binding = (IBinding)this.getModel();
            IInterface typeBeingRef = binding.getInterface();
            if (this.connectionFigure != null) {
                AbstractGraphicalEditPart referenceTypePart = (AbstractGraphicalEditPart)this.getViewer().getEditPartRegistry().get(typeBeingRef);
                BoxComponentFigure boxComponentFigure = (BoxComponentFigure)referenceTypePart.getFigure();
                this.connectionFigure.setSourceAnchor((ConnectionAnchor)new CenteredConnectionAnchor(this.getFigure(), 3, 0));
                this.connectionFigure.setTargetAnchor((ConnectionAnchor)new TopLeftConnectionAnchor((IFigure)boxComponentFigure, (IFigure)boxComponentFigure.getLabel()));
                this.connectionFigure.setHighlight(false);
                this.connectionFigure.setVisible(true);
            } else {
                this.activateConnection();
            }
        } else if (this.connectionFigure != null) {
            this.connectionFigure.setVisible(false);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ASDSelectionEditPolicy());
    }

    public boolean isExpanded() {
        return this.isExpanded;
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
    }

    public void performRequest(Request request) {
        LayoutManager layoutManager;
        if (request.getType() == "open" && (layoutManager = this.getFigure().getParent().getLayoutManager()) instanceof BindingColumnLayout) {
            BindingColumnLayout bindingColumnLayout = (BindingColumnLayout)layoutManager;
            bindingColumnLayout.setExpanded(this, !this.isExpanded);
            ((BindingColumnEditPart)this.getParent()).refreshBindingEditParts();
        }
    }
}

