/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.wst.common.internal.emf.resource.CompatibilityPackageMappingRegistry;
import org.eclipse.wst.common.internal.emf.resource.CompatibilityXMILoadImpl;
import org.eclipse.wst.common.internal.emf.resource.CompatibilityXMIResource;
import org.eclipse.wst.common.internal.emf.resource.CompatibilityXMISaveImpl;
import org.eclipse.wst.common.internal.emf.resource.MappedXMIHelper;
import org.eclipse.wst.common.internal.emf.utilities.IDUtil;

public class CompatibilityXMIResourceImpl
extends XMIResourceImpl
implements CompatibilityXMIResource {
    protected static final String DEFAULT_ENCODING = "UTF-8";
    protected int format = 0;
    protected Map originalPackageURIs = new HashMap();
    private boolean preserveIDs = false;
    private static final String PLATFORM_PROTOCOL = "platform";
    private static final String PLATFORM_PLUGIN = "plugin";

    public CompatibilityXMIResourceImpl() {
        this.initDefaultSaveOptions();
    }

    public CompatibilityXMIResourceImpl(URI uri) {
        super(uri);
        this.initDefaultSaveOptions();
    }

    protected final XMLHelper createXMLHelper() {
        MappedXMIHelper helper = this.doCreateXMLHelper();
        helper.setPackageURIsToPrefixes(this.getPackageURIsToPrefixes());
        return helper;
    }

    protected MappedXMIHelper doCreateXMLHelper() {
        return new MappedXMIHelper((XMLResource)this, this.getPrefixToPackageURIs());
    }

    protected Map getPrefixToPackageURIs() {
        return CompatibilityPackageMappingRegistry.INSTANCE.getPrefixToPackageURIs();
    }

    protected Map getPackageURIsToPrefixes() {
        return CompatibilityPackageMappingRegistry.INSTANCE.getPackageURIsToPrefixes();
    }

    public void addOriginalPackageURI(String packageUri, String originalUri) {
        this.originalPackageURIs.put(packageUri, originalUri);
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int format) {
        if (!this.isPlatformPluginResourceURI()) {
            this.format = format;
        }
    }

    private boolean isPlatformPluginResourceURI() {
        URI aURI = this.getURI();
        return aURI != null && PLATFORM_PROTOCOL.equals(this.uri.scheme()) && PLATFORM_PLUGIN.equals(this.uri.segment(0));
    }

    public String getURIFragment(EObject eObject) {
        if (this.usesDefaultFormat()) {
            return super.getURIFragment(eObject);
        }
        return IDUtil.getOrAssignID(eObject, (XMLResource)this);
    }

    public boolean usesDefaultFormat() {
        return this.format == 0;
    }

    protected XMLSave createXMLSave() {
        if (this.usesDefaultFormat()) {
            return super.createXMLSave();
        }
        return new CompatibilityXMISaveImpl(this.createXMLHelper());
    }

    public void doSave(OutputStream outputStream, Map options) throws IOException {
        super.doSave(outputStream, options);
    }

    protected void initDefaultSaveOptions() {
        if (this.defaultSaveOptions == null) {
            this.getDefaultSaveOptions();
        }
    }

    protected EObject getEObjectByID(String id) {
        EObject eObject;
        if (this.idToEObjectMap != null && (eObject = (EObject)this.idToEObjectMap.get(id)) != null) {
            return eObject;
        }
        return null;
    }

    protected void unloaded(InternalEObject internalEObject) {
        internalEObject.eSetProxyURI(this.uri.appendFragment(super.getURIFragment((EObject)internalEObject)));
        internalEObject.eAdapters().clear();
    }

    public final void doLoad(InputStream inputStream, Map options) throws IOException {
        this.basicDoLoad(inputStream, options);
    }

    protected void basicDoLoad(InputStream inputStream, Map options) throws IOException {
        super.doLoad(inputStream, options);
    }

    protected void init() {
        super.init();
        this.setEncoding(DEFAULT_ENCODING);
    }

    protected XMLLoad createXMLLoad() {
        return new CompatibilityXMILoadImpl(this.createXMLHelper());
    }

    public void removePreservingIds(EObject rootObject) {
        this.setPreserveIDs(true);
        this.getContents().remove((Object)rootObject);
    }

    public boolean isPreserveIDs() {
        return this.preserveIDs;
    }

    public void setPreserveIDs(boolean preserveIDs) {
        this.preserveIDs = preserveIDs;
    }

    protected void detachedHelper(EObject eObject) {
        if (this.modificationTrackingAdapter != null) {
            eObject.eAdapters().remove((Object)this.modificationTrackingAdapter);
        }
        if (this.useUUIDs()) {
            DETACHED_EOBJECT_TO_ID_MAP.put(eObject, this.getID(eObject));
        }
        if (!this.isPreserveIDs() && this.idToEObjectMap != null && this.eObjectToIDMap != null) {
            this.idToEObjectMap.remove(this.eObjectToIDMap.remove(eObject));
        }
    }
}

