/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.derby.internal.ui.connection.dialogs;

import java.text.MessageFormat;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.rdb.connection.internal.ui.factories.RSCCoreUIWidgetFactory;
import org.eclipse.wst.rdb.connection.internal.ui.providers.IServerConnectionInformation;
import org.eclipse.wst.rdb.connection.internal.ui.providers.IServerConnectionUIProvider;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.NewConnectionWizard;
import org.eclipse.wst.rdb.derby.internal.ui.util.ResourceLoader;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;

public abstract class AbstractDerbyConnectionProvider
implements IServerConnectionUIProvider,
Listener {
    protected static final RSCCoreUIWidgetFactory factory = RSCCoreUIWidgetFactory.INSTANCE;
    protected static final ResourceLoader resource = ResourceLoader.INSTANCE;
    protected static final String CUI_NEWCW_DATABASE_LBL_UI_ = resource.queryString("CUI_NEWCW_UNI_DATABASE_LBL_UI_");
    protected static final String CUI_NEWCW_CREATEDB_BTN_UI_ = resource.queryString("CUI_NEWCW_CREATEDB_BTN_UI_");
    protected static final String CUI_NEWCW_UPGRADEDB_BTN_UI_ = resource.queryString("CUI_NEWCW_UPGRADEDB_BTN_UI_");
    protected static final String CUI_NEWCW_JDBCDRIVERCLS_LBL_UI_ = resource.queryString("CUI_NEWCW_JDBCDRIVERCLS_LBL_UI_");
    protected static final String CUI_NEWCW_HOST_LBL_UI_ = resource.queryString("CUI_NEWCW_UNI_HOST_LBL_UI_");
    protected static final String CUI_NEWCW_PORT_LBL_UI_ = resource.queryString("CUI_NEWCW_UNI_PORT_LBL_UI_");
    protected static final String CUI_NEWCW_JDBCCLSLOCATION_LBL_UI_ = resource.queryString("CUI_NEWCW_JDBCCLSLOCATION_LBL_UI_");
    protected static final String CUI_NEWCW_JARBROWSE_BTN_UI_ = resource.queryString("CUI_NEWCW_JARBROWSE_BTN_UI_");
    protected static final String CUI_NEWCW_CONNECTIONURL_LBL_UI_ = resource.queryString("CUI_NEWCW_CONNECTIONURL_LBL_UI_");
    protected static final String CREATE_EQUALS_TRUE_TEXT = "create=true";
    protected static final String UPGRADE_EQUALS_TRUE_TEXT = "upgrade=true";
    protected IServerConnectionInformation connectionInformation;
    protected Composite parentComposite;
    protected Label databaseLabel;
    protected Text databaseCombo;
    protected Button createCheck;
    protected boolean displayUpgrade = false;
    protected Button upgradeCheck;
    protected Label hostLabel;
    protected Text hostCombo;
    protected Label portLabel;
    protected Label driverLabel;
    protected Text driverDisplay;
    protected Label locationLabel;
    protected Text locationCombo;
    protected Button browseLocation;
    protected Label urlLabel;
    protected Text urlDisplay;
    protected Text portCombo;
    protected WizardPage parentPage;

    protected abstract void updateURL();

    protected abstract String getDriverClassName();

    public boolean determinePageCompletion() {
        return this.validateControl();
    }

    protected void setConnectionInformation() {
        this.connectionInformation.setDriverClassName(this.getDriverClassName());
        this.connectionInformation.setDatabaseName(this.databaseCombo.getText());
        this.connectionInformation.setLoadingPath(this.locationCombo.getText());
        this.connectionInformation.setURL(this.urlDisplay.getText());
        if (this.determinePageCompletion()) {
            this.connectionInformation.setInformationComplete(true);
        }
    }

    protected boolean validateControl() {
        if (this.databaseCombo.getText() == null || this.databaseCombo.getText().equals("")) {
            this.parentPage.setErrorMessage(MessageFormat.format(NewConnectionWizard.getResourceString((String)"CUI_NEWCW_VALIDATE_DATABASE_REQ_UI_"), NewConnectionWizard.getResourceString((String)"CUI_NEWCW_DEFDBNAME_VAL_UI_")));
            return false;
        }
        if (this.hostCombo != null && this.hostCombo.isEnabled() && this.hostCombo.getText().length() < 1) {
            this.parentPage.setErrorMessage(NewConnectionWizard.getResourceString((String)"CUI_NEWCW_VALIDATE_HOST_REQ_UI_"));
            return false;
        }
        if (this.portCombo != null && this.portCombo.isEnabled() && this.portCombo.getText().length() < 1) {
            this.parentPage.setErrorMessage(NewConnectionWizard.getResourceString((String)"CUI_NEWCW_VALIDATE_PORT_REQ_UI_"));
            return false;
        }
        if (this.driverDisplay != null && this.driverDisplay.getEnabled() && this.driverDisplay.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(NewConnectionWizard.getResourceString((String)"CUI_NEWCW_VALIDATE_DRIVERCLASS_REQ_UI_"));
            return false;
        }
        if (this.locationCombo != null && this.locationCombo.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(NewConnectionWizard.getResourceString((String)"CUI_NEWCW_VALIDATE_CLASSLOCATION_REQ_UI_"));
            return false;
        }
        if (this.urlDisplay != null && this.urlDisplay.getText().trim().length() == 0) {
            this.parentPage.setErrorMessage(NewConnectionWizard.getResourceString((String)"CUI_NEWCW_VALIDATE_URL_REQ_UI_"));
            return false;
        }
        return true;
    }

    protected void initialize() {
        this.driverDisplay.setText(this.getDriverClassName());
        this.connectionInformation.setDriverClassName(this.getDriverClassName());
        this.databaseCombo.setText("sample");
        this.hostCombo.setText("localhost");
        this.portCombo.setText("1527");
        this.updateURL();
        this.addListeners();
        this.determinePageCompletion();
    }

    public void addListeners() {
        this.locationCombo.addListener(24, (Listener)this);
        this.browseLocation.addListener(13, (Listener)this);
        this.databaseCombo.addListener(24, (Listener)this);
        this.createCheck.addListener(13, (Listener)this);
        if (this.displayUpgrade) {
            this.upgradeCheck.addListener(13, (Listener)this);
        }
        this.hostCombo.addListener(24, (Listener)this);
        this.portCombo.addListener(24, (Listener)this);
        this.urlDisplay.addListener(24, (Listener)this);
    }

    protected void removeListeners() {
        this.locationCombo.removeListener(24, (Listener)this);
        this.browseLocation.removeListener(13, (Listener)this);
        this.databaseCombo.removeListener(24, (Listener)this);
        this.createCheck.removeListener(13, (Listener)this);
        if (this.displayUpgrade) {
            this.upgradeCheck.removeListener(13, (Listener)this);
        }
        this.hostCombo.removeListener(24, (Listener)this);
        this.portCombo.removeListener(24, (Listener)this);
        this.urlDisplay.removeListener(24, (Listener)this);
    }

    public Composite getServerConnectionUI(Composite parent) {
        if (this.parentComposite == null || this.parentComposite.isDisposed()) {
            this.parentComposite = this.createServerConnectionUI(parent);
        }
        this.setConnectionInformation();
        return this.parentComposite;
    }

    protected Composite createServerConnectionUI(Composite parent) {
        this.parentComposite = factory.createComposite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        this.parentComposite.setLayout((Layout)layout);
        this.databaseLabel = factory.createLabel(this.parentComposite, 0);
        this.databaseLabel.setText(CUI_NEWCW_DATABASE_LBL_UI_);
        this.databaseCombo = factory.createText(this.parentComposite, 2052);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.databaseCombo.setLayoutData((Object)gd);
        this.createCheck = factory.createButton(this.parentComposite, 32);
        this.createCheck.setText(CUI_NEWCW_CREATEDB_BTN_UI_);
        this.createCheck.setSelection(true);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.createCheck.setLayoutData((Object)gd);
        if (this.displayUpgrade) {
            this.upgradeCheck = factory.createButton(this.parentComposite, 32);
            this.upgradeCheck.setText(CUI_NEWCW_UPGRADEDB_BTN_UI_);
            this.upgradeCheck.setSelection(false);
            gd = new GridData();
            gd.horizontalSpan = 3;
            this.upgradeCheck.setLayoutData((Object)gd);
        }
        this.hostLabel = factory.createLabel(this.parentComposite, 0);
        this.hostLabel.setText(CUI_NEWCW_HOST_LBL_UI_);
        this.hostCombo = factory.createText(this.parentComposite, 2052);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.hostCombo.setLayoutData((Object)gd);
        this.portLabel = factory.createLabel(this.parentComposite, 0);
        this.portLabel.setText(CUI_NEWCW_PORT_LBL_UI_);
        this.portCombo = factory.createText(this.parentComposite, 2052);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.portCombo.setLayoutData((Object)gd);
        this.driverLabel = factory.createLabel(this.parentComposite, 0);
        this.driverLabel.setText(CUI_NEWCW_JDBCDRIVERCLS_LBL_UI_);
        this.driverDisplay = factory.createText(this.parentComposite, 2060);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.driverDisplay.setLayoutData((Object)gd);
        this.locationLabel = factory.createLabel(this.parentComposite, 0);
        this.locationLabel.setText(CUI_NEWCW_JDBCCLSLOCATION_LBL_UI_);
        this.locationCombo = factory.createText(this.parentComposite, 2052);
        gd = new GridData(768);
        this.locationCombo.setLayoutData((Object)gd);
        this.browseLocation = factory.createButton(this.parentComposite, 8);
        this.browseLocation.setText(CUI_NEWCW_JARBROWSE_BTN_UI_);
        this.browseLocation.setLayoutData((Object)new GridData(256));
        gd = new GridData(64);
        gd.horizontalSpan = 1;
        this.browseLocation.setLayoutData((Object)gd);
        this.urlLabel = factory.createLabel(this.parentComposite, 0);
        this.urlLabel.setText(CUI_NEWCW_CONNECTIONURL_LBL_UI_);
        this.urlDisplay = factory.createText(this.parentComposite, 2060);
        gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.urlDisplay.setLayoutData((Object)gd);
        this.initialize();
        return this.parentComposite;
    }

    public void setServerConnectionInformation(IServerConnectionInformation connectionInformation) {
        this.connectionInformation = connectionInformation;
    }

    public void setWizardPage(WizardPage parentPage) {
        this.parentPage = parentPage;
    }

    public void setDatabaseDefinition(DatabaseDefinition definition) {
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source == this.databaseCombo) {
            this.updateURL();
        } else if (source == this.createCheck) {
            this.updateURL();
        } else if (this.displayUpgrade && source == this.upgradeCheck) {
            this.updateURL();
        } else if (source != this.locationCombo) {
            String file;
            if (source == this.hostCombo) {
                this.updateURL();
            } else if (source == this.portCombo) {
                this.updateURL();
            } else if (source == this.browseLocation && (file = NewConnectionWizard.getFile((Wizard)((Wizard)this.parentPage.getWizard()), (String[])NewConnectionWizard.fExtensions)) != null && file.length() > 0) {
                this.locationCombo.removeListener(24, (Listener)this);
                this.locationCombo.setText(file);
                this.locationCombo.addListener(24, (Listener)this);
                this.connectionInformation.setLoadingPath(file);
            }
        }
        this.setConnectionInformation();
    }
}

